#include user_scripts\mp_patches\forge\utility;
#include user_scripts\mp_patches\forge\structure;
#include user_scripts\mp_patches\forge\preload;
#include scripts\utility;
#include common_scripts\utility;
#include maps\mp\_utility;
#include maps\mp\gametypes\_hud_util;
#include maps\mp\gametypes\_gamelogic;

////////////////////////////////////////////////////////////////////////////////////////
//Init
////////////////////////////////////////////////////////////////////////////////////////

//init
init()
{

    //fx explosions
    level._effect[ "nuke_flash" ] = loadfx( "fx/explosions/nuke_flash" );
    level._effect[ "nuke_explosion" ] = loadfx( "fx/explosions/nuke_explosion" );
    level._effect[ "grenade_flash" ] = loadfx( "explosions/grenade_flash" );
    level._effect[ "aerial_explosion_large" ] = loadfx( "fx/explosions/aerial_explosion_large" );
    level._effect[ "aerial_explosion" ] = loadfx( "fx/explosions/aerial_explosion" );
    level._effect[ "helicopter_explosion_cobra" ] = loadfx( "fx/explosions/helicopter_explosion_cobra" );
    level._effect[ "concussion_grenade_sparkles" ] = loadfx( "vfx/explosion/concussion_grenade_sparkles" );
    level._effect[ "frag_grenade_flash" ] = loadfx( "vfx/explosion/frag_grenade_flash" );
    level._effect[ "vfx/explosion/mp_gametype_bomb" ] = loadfx( "vfx/explosion/mp_gametype_bomb" );
    level._effect[ "vfx/explosion/frag_grenade_default" ] = loadfx( "vfx/explosion/frag_grenade_default" );
    level._effect[ "vfx/explosion/concussion_grenade_h1" ] = loadfx( "vfx/explosion/concussion_grenade_h1" );
    
    
    //fx fire
    level._effect[ "fire_smoke_trail_l" ] = loadfx( "fx/fire/fire_smoke_trail_l" );
    level._effect[ "fire_smoke_trail_m" ] = loadfx( "fire/fire_smoke_trail_m" );
    level._effect[ "fire_spawner_small_1_cgoshp" ] = loadfx( "vfx/fire/fire_spawner_small_1_cgoshp" );

    //fx lights
    level._effect[ "lasersight_attachment" ] = loadfx( "vfx/lights/lasersight_attachment" );
    level._effect[ "light_c4_blink" ] = loadfx( "vfx/lights/light_c4_blink" );

    //fx misc
    level._effect[ "aircraft_light_red_blink" ] = loadfx( "fx/misc/aircraft_light_red_blink" );
    level._effect[ "aircraft_light_white_blink" ] = loadfx( "fx/misc/aircraft_light_white_blink" );
    level._effect[ "aircraft_light_wingtip_green" ] = loadfx( "fx/misc/aircraft_light_wingtip_green" );
    level._effect[ "aircraft_light_wingtip_red" ] = loadfx( "fx/misc/aircraft_light_wingtip_red" );
    
    //fx props
    level._effect[ "american_smoke_grenade_mp" ] = loadfx( "vfx/props/american_smoke_grenade_mp" );
    level._effect[ "claymore_laser" ] = loadfx( "vfx/props/claymore_laser" );

    //fx smoke
    level._effect[ "signal_smoke_red_estate" ] = loadfx( "fx/smoke/signal_smoke_red_estate" );
    level._effect[ "smoke_geotrail_rpg" ] = loadfx( "fx/smoke/smoke_geotrail_rpg" );
    level._effect[ "smoke_geotrail_javelin" ] = loadfx( "smoke/smoke_geotrail_javelin" );
    level._effect[ "smoke_trail_black_heli" ] = loadfx( "fx/smoke/smoke_trail_black_heli" );

    //fx trail
    level._effect[ "trail_smk_spurt_glowy_dark_large" ] = loadfx( "vfx/trail/trail_smk_spurt_glowy_dark_large" );
    level._effect[ "trail_smk_white_heli" ] = loadfx( "vfx/trail/trail_smk_white_heli" );

    //fx treadfx
    level._effect[ "heli_dust_default" ] = loadfx( "vfx/treadfx/heli_dust_default" );
    level._effect[ "heli_water_default" ] = loadfx( "vfx/treadfx/heli_water_default" );
    level._effect[ "tread_dust_default" ] = loadfx( "vfx/treadfx/tread_dust_default" );

	level.Attach1 = "";
	level.Attach2 = "";
    level.BotDifficulty = "recruit";
    level.inf_ammo = false;
    level.rapid_fire = false;
    level.cointossed = false;
	//level.DeathBarriers = true;
	//level.UFOMode = false;
	//level.FreezeBots = false;
	//level.AllPerks = false;
	//level.therm_vis = false;
	//level.wallbangs = false;
	//level.pos_print = false;
	//level.LaserToggle = false;
    //level.NoSpread = false;
    //level.customproj = false;
    //level.bulletricochet = false;
    level.DiscoSun = false;
	level.discox = "0.0";
	level.discoy = "0.0";
	level.discoz = "0.0";

    //level.ocallbackplayerdamage = level.callbackplayerdamage;
    //level.callbackplayerdamage = ::hk_callback_player_damage;

    level.RaygunWeapon = "h2_pp2000_mp_holo_xmag_camo030";

	level.RaygunFX[ "raygun" ] = loadFX( "fx/misc/aircraft_light_wingtip_red" );
	level.RaygunFX[ "impact" ] = loadFX( "fx/misc/flare_ambient" );

    level.FX_count = 0;

    level.omafx = "onemanarmy_mp";

    level.B = 0; //Starting Amount Of Bounces
    level.BounceLimit = 10; // Amount Of Bounces Allowed

    precacheModel( "fx_rock_small" );

}

////////////////////////////////////////////////////////////////////////////////////////
//Utility Functions
////////////////////////////////////////////////////////////////////////////////////////

//Location Selector
locationSelector()
{

	self _beginLocationSelection( "", "map_artillery_selector", true, ( level.mapSize / 5.625 ) );
    self.selectingLocation = true;
    self waittill( "confirm_location", location, directionYaw );
	newLocation = BulletTrace( location+( 0, 0, 0 ), location, 0, self )[ "position" ];
	self notify( "used" );
    self endLocationSelection();
    self.selectingLocation = undefined;
	return newLocation;

}


//Model Spawner
spawn_model( m )
{

    f = self getTagOrigin( "tag_eye" );
    e = self thread vector_scal( anglestoforward( self getPlayerAngles() ), 1000000 );
    p = BulletTrace( f, e, 0, self )[ "position" ];
    o = spawn( "script_model", p );
    o CloneBrushmodelToScriptmodel( level.airDropCrateCollision ); 
    o PhysicsLaunchServer( ( 0, 0, 0 ), ( 0, 0, 0 ) );
    o.angles = self.angles + ( 0, 90, 0 );
    self iprintln( "^:Spawned Object : " + m );
    o setModel( m );

}


//Destroy Model On Time
destroyModelOnTime( time )
{

	wait( time );
	self delete();

}


//Rotate Entity Yaw
rotateEntYaw(yaw,time)
{
    while(isDefined(self))
    {
        self rotateYaw(yaw,time);
        wait time;
    }
}


getPlayers()
{
    return level.players;
}


SetSafeText2( text )
{
    self notify( "stop_TextMonitor" );
    self AddToStringArray( text );
    self thread watchforoverflow( text );
}


setSafeText1( text )
{
    level.result += 1;
    level notify( "textset" );
    self setText( text );
}


isInArray(array,text)
{
    for(e=0;e<array.size;e++)
        if(array[e]==text)
            return true;
    return false;
}


AddToStringArray(text)
{
    if(!isInArray(level.strings,text))
    {
        level.strings[level.strings.size]=text;
        level notify("CHECK_OVERFLOW");
    }
}


WatchForOverflow(text)
{
    self endon("stop_TextMonitor");
    
    while(isDefined(self))
    {
        self SetText(text);
        level waittill("FIX_OVERFLOW");
    }
}


FixOverflow()
{
    level.overflow       = NewHudElem();
    level.overflow.alpha = 0;
    level.overflow setText("marker");

    for(;;)
    {
        level waittill("CHECK_OVERFLOW");
        if(level.strings.size >= 45)
        {
            level.overflow ClearAllTextAfterHudElem();
            level.strings = [];
            level notify("FIX_OVERFLOW");
        }
    }
}


setPoint1(point,relativePoint,xOffset,yOffset,moveTime){if(!isDefined(moveTime))moveTime=0;element=self getParent();if(moveTime)self moveOverTime(moveTime);if(!isDefined(xOffset))xOffset=0;self.xOffset=xOffset;if(!isDefined(yOffset))yOffset=0;self.yOffset=yOffset;self.point=point;self.alignX="center";self.alignY="middle";if(isSubStr(point,"TOP"))self.alignY="top";if(isSubStr(point,"BOTTOM"))self.alignY="bottom";if(isSubStr(point,"LEFT"))self.alignX="left";if(isSubStr(point,"RIGHT"))self.alignX="right";if(!isDefined(relativePoint))relativePoint=point;self.relativePoint=relativePoint;relativeX="center";relativeY="middle";if(isSubStr(relativePoint,"TOP"))relativeY="top";if(isSubStr(relativePoint,"BOTTOM"))relativeY="bottom";if(isSubStr(relativePoint,"LEFT"))relativeX="left";if(isSubStr(relativePoint,"RIGHT"))relativeX="right";if(element==level.uiParent){self.horzAlign=relativeX;self.vertAlign=relativeY;} else {self.horzAlign=element.horzAlign;self.vertAlign=element.vertAlign;}if(relativeX==element.alignX){offsetX=0;xFactor=0;} else  if(relativeX=="center"||element.alignX=="center"){offsetX=int(element.width / 2);if(relativeX=="left"||element.alignX=="right")xFactor=-1; else  xFactor=1;} else {offsetX=element.width;if(relativeX=="left")xFactor=-1; else  xFactor=1;}self.x=element.x +(offsetX * xFactor);if(relativeY==element.alignY){offsetY=0;yFactor=0;} else  if(relativeY=="middle"||element.alignY=="middle"){offsetY=int(element.height / 2);if(relativeY=="top"||element.alignY=="bottom")yFactor=-1; else  yFactor=1;} else {offsetY=element.height;if(relativeY=="top")yFactor=-1; else  yFactor=1;}self.y=element.y +(offsetY * yFactor);self.x += self.xOffset;self.y += self.yOffset;switch(self.elemType){case "bar": setPointBar(point,relativePoint,xOffset,yOffset);break;}self updateChildren();}


createText( font, fontScale, align, relative, x, y, sort, alpha, text, color )
{

    textElem                = self CreateFontString( font, fontScale );
    textElem.hideWhenInMenu = true;
    textElem.archived       = false;
    textElem.sort           = sort;
    textElem.alpha          = alpha;
    textElem.color          = color;
    textElem.foreground     = true;
    textElem setPoint1( align, relative, x, y );
    self addToStringArray( text );
    textElem thread watchForOverFlow( text );
    
    return textElem;

}


skyBaseBuilt(base){if(base == "Twister") return level.twister;if(base == "Coaster") return level.coaster;if(base == "Tornado") return level.TornadoSpawned;}
deleteIcon(){if(isDefined(level.notifyIcon))level.notifyIcon destroy();}
deleteSkyBase(){if(isDefined(level.skybaseArray))for(a=0;a<level.skybaseArray.size;a++)if(isDefined(level.skybaseArray[a]))level.skybaseArray[a] delete();if(isDefined(level.physicsArray))for(a=0;a<level.physicsArray.size;a++)if(isDefined(level.physicsArray[a]))level.physicsArray[a] delete();level.skybaseArray=undefined;level.physicsArray=undefined;level.skyBaseDestroyed=undefined;}
skyBaseDestroy(base){if(isDefined(level.skyBaseIsBuilding)|| !isDefined(skyBaseBuilt(base))|| skybaseUsed()|| isDefined(level.skyBaseDestroyed))return;level notify("SKYBASE_FAIL");level.skyBaseDestroyed=true;level thread deleteIcon();for(a=0;a<getPlayers().size;a++){player=getPlayers()[a];player.riding=undefined;player allowedStance(true);if(isDefined(player.inSkyBase)){player setStance("stand");player thread otherPlayerFall();}player.inSkyBase=undefined;}}
allowedStance(bool){self allowAds(bool);self allowSprint(bool);self allowJump(bool);}
skyBaseArray(delete){if(isDefined(delete))self thread skyBaseDelete(); else  self thread skyBasePhysics();if(!isDefined(level.skybaseArray))level.skybaseArray=[];level.skybaseArray[level.skybaseArray.size]=self;}
skyBaseDelete(){level waittill("SKYBASE_FAIL");if(isDefined(self))self delete();}
skyBasePhysics(){level endon("SKYBASE_DELETED");level waittill("SKYBASE_FAIL");while(true){self PhysicsLaunchServer(self.origin,AnglesToForward(self.angles)*400);wait .1;}}
skybaseUsed(){for(a=0;a<getPlayers().size;a++)if(isDefined(getPlayers()[a].usingSkyBase)&& isValidPlayer(getPlayers()[a]))return 1;return 0;}
otherPlayerFall(){fly=spawn("script_origin",self.origin);self playerLinkToDelta(fly);fly moveto(self.origin+(0,0,-200),.7);wait .8;self unlink();self allowJump(true);fly delete();}
textMarker(player,org,text,size,color,title){if(!isDefined(color))color =(1,1,1);if(isDefined(player))title=self createFontString(getFont(),2,self); else  title=createFontString(getFont(),2);title.label=text;title.color=color;if(isDefined(color)&& color=="RAIN")title thread smoothColorChange();title.x=org[0];title.y=org[1];title.z=org[2];title.alpha=1;title setWayPoint(size,title);return title;}


smoothColorChange()
{
    self endon("smoothColorChange_endon");
    while(isDefined(self))
    {
        level.smoothx=randomIntRange( 0, 255 );
        level.smoothy=randomIntRange( 0, 255 );
        level.smoothz=randomIntRange( 0, 255 );
        self fadeOverTime(.15);
        self.color = level.smoothx + " " + level.smoothy + " " + level.smoothz;
        wait .25;
    }
}


isValidPlayer(player)
{
    if(!isDefined(player))return false;
    if(!isAlive(player))return false;
    if(!isPlayer(player))return false;
    if(player.sessionstate=="spectator")return false;
    if(player.sessionstate=="intermission")return false;
    return true;
}


spawnSM( origin, model, angles, time, clip)
{
    if(isDefined(time))wait time;
    bog = spawn("script_model",origin);
    bog setModel(model);
    if(isDefined(angles))bog.angles=angles;
    if(isDefined(clip))bog CloneBrushModelToScriptModel(clip);
    return bog;
}


/*
spawnSM( origin, model, angles)
{
    ent=spawn("script_model",origin);
    ent setModel(model);
    if(isDefined(angles)) ent.angles=angles;
    return ent;
}
*/


getFont()
{
    return "default";
}


spawnTrigger(origin,width,height)
{
    trig = spawn("trigger_radius",origin,1,width,height);
    return trig;
}


hostPlayer()
{

    for( a=0; a < getPlayers().size; a++ )if(getPlayers()[a] isHost())return getPlayers()[a];

}


deleteAfter(time)
{
    wait time;
    if(isDefined(self))self delete();
}


TriggerText(text)
{
    trig = "";
    if(isDefined(trig))return;
    
    level.trigx=randomIntRange( 0, 255 );
    level.trigy=randomIntRange( 0, 255 );
    level.trigz=randomIntRange( 0, 255 );

    trig = self createText("default",1.5,"CENTER","CENTER",0,75,1,1,text, level.trigx + " " + level.trigy + " " + level.trigz );
    trig thread TriggerTextColorful();
    return trig;
}


TriggerTextColorful()
{

    self notify("endTrigColor");
    self endon("endTrigColor");

    while(isDefined(self))
    {

        level.textx=randomIntRange( 0, 255 );
        level.texty=randomIntRange( 0, 255 );
        level.textz=randomIntRange( 0, 255 );

        self FadeOverTime(.5);
        self.color = level.textx + " " + level.texty + " " + level.textz;
        wait .5;

    }

}


v_sx( vec, scale )
{

    vec = ( vec[0] * scale, vec[1] * scale, vec[2] * scale );
    return vec;

}


xoxd() 
{

    forward = self getTagOrigin( "tag_eye" );
    end = self thread vec_sl( anglestoforward( self getPlayerAngles() ), 1000000 );
    location = BulletTrace( forward, end, 0, self )[ "position" ];
    return location;

}


vec_sl( vec, scale ) 
{

    vec = ( vec[0] * scale, vec[1] * scale, vec[2] * scale );
    return vec;

}


vectorScale( vector, scale ) //new
{

    return ( vector[0] * scale, vector[1] * scale, vector[2] * scale );

}


/*
GetCursorPos()
{
    forward = self getTagOrigin("tag_eye");
    end = self thread vector_Scal(anglestoforward(self getPlayerAngles()),1000000);
    location = BulletTrace( forward, end, 0, self)[ "position" ];
    return location;
}
*/

GetCursorPos()
{

    return bulletTrace( self getEye(), self getEye() + vectorScale( anglesToForward( self getPlayerAngles() ), 1000000 ), false, self )["position"];

}


S( text )
{
    self iprintln( text );
}


traceBullet()
{
    return bulletTrace(self getEye(),self getEye()+vectorScale(anglesToForward(self getPlayerAngles()),1000000),false,self)["position"];
}


vector_scal(vec,scale)
{
    vec = (vec[0] * scale, vec[1] * scale, vec[2] * scale);
    return vec;
}


spawnEntity(class, model, origin, angle)
{

    entity = spawn(class, origin);
    entity.angles = angle;
    entity setModel(model);
    return entity;

}


modelSpawner(origin, model, angles, time)
{
    if(isDefined(time))
        wait time;
    obj = spawn("script_model", origin);
    obj setModel(model);
    if(isDefined(angles))
        obj.angles = angles;
    if(getentarray().size >= 590)
    {
        self iprintln("^1Error^7: Please delete some other structures");
        obj delete();
    }
    return obj;
}


spawnTrig(origin,width,height,cursorHint,string)
{
    trig = spawn("trigger_radius", origin, 1, width, height);
    trig setCursorHint(cursorHint, trig);
    trig setHintString( string );
    return trig;
}


Array_Physics(ID)
{
    foreach(model in ID)
        model thread DelayedFall(5);//Apply_Physics
}

DelayedFall( Num )
{
    if(isDefined(self))
        self physicsLaunchServer();
    wait Num;
    if(isDefined(self))
        self delete();
}


getColor()
{

	return ( randomIntRange( 10, 255 ) / 255, randomIntRange( 10, 255 ) / 255, randomIntRange( 10, 255 ) / 255 );

}

createRectangle( align, relative, x, y, width, height, color, shader, sort, alpha )
{

	barElemBG=newClientHudElem( self );
	barElemBG.elemType = "bar";
	barElemBG.width = width;
	barElemBG.height = height;
	barElemBG.align = align;
	barElemBG.relative = relative;
	barElemBG.xOffset = 0;
	barElemBG.yOffset = 0;
	barElemBG.children = [];
	barElemBG.sort = sort;
	barElemBG.color = color;
	barElemBG.alpha = alpha;
	barElemBG setParent( level.uiParent );
	barElemBG setShader( shader, width, height );
	barElemBG.hidden = false;
	barElemBG setPoint( align, relative, x, y );
	thread destroyElemOnDeath( barElemBG );
	return barElemBG;

}

destroyElemOnDeath( elem )
{

	self waittill( "death" );

	if( isDefined( elem.bar ) )
        elem destroyElem();
	else
        elem destroy();

}

is_offhand( item )
{

    equipment = [ "h1_fraggrenade_mp", "h1_c4_mp", "h1_flashgrenade_mp", "h1_concussiongrenade_mp", "h1_smokegrenade_mp", "h1_claymore_mp", "flare_mp", "iw9_throwknife_mp", "h2_semtex_mp", "h1_fraggrenadeshort_mp" ];

    for( a = 0; a < equipment.size; a++ )
        if( equipment[ a ] == item )
            return true;
    
    return false;

}

get_offhand_reserve( item )
{

    base_value = 1;
    /*
    if( item == "h1_fraggrenade_mp" || item == "h1_fraggrenadeshort_mp" )
        base_value = self _hasperk( "specialty_fraggrenade" ) ? 3 : 1;
    
    if( item == "h1_flashgrenade_mp" || item == "h1_concussiongrenade_mp" )
        base_value = self _hasperk( "specialty_specialgrenade" ) ? 3 : 1;
    
    if( item == "h1_smokegrenade_mp" || item == "h1_c4_mp" || item == "h1_claymore_mp" || item == "iw9_throwknife_mp" || item == "h2_semtex_mp" || item == "flare_mp" )
        base_value = ( item == "h1_smokegrenade_mp" || item == "h1_c4_mp" || item == "h1_claymore_mp" || item == "iw9_throwknife_mp" || item == "h2_semtex_mp" || item == "flare_mp" ) ? 1 : 2;
    */
    return base_value;

}

booleanopposite( bool )
{

	if( !(IsDefined( bool )) )
	{
		return 1;
	}
	if( bool )
	{
		return 0;
	}
	else
	{
        
	}

}

booleanreturnval( bool, returniffalse, returniftrue )
{
	if( bool )
	{
		return returniftrue;
	}
	else
	{
	}

}

////////////////////////////////////////////////////////////////////////////////////////
//Main Functions
////////////////////////////////////////////////////////////////////////////////////////

/*
print_test( test ) {
    self iprintln( test );
}

toggle_test( test ) {
    self.toggle_test[ test ] = !return_toggle( self.toggle_test[ test ] );
}

set_dvar( value, dvar ) {
    setdvar( dvar, value );
}

console_command( command ) {
    executecommand( command );
}
*/


// ^1 Red
// ^2 Green
// ^3 yellow
// ^4 Blue
// ^5 Cyan
// ^6 Pink
// ^7 White
// ^8 Depends on the team colors playing
// ^9 Dark Red
// ^0 Black
// ^: Rainbow


//todo
todo()
{

	self iprintln( "^1todo" );

}


//Restart Map
restart_map()
{

    if( self.access == "Host" )
    {

        map_restart( false );

    }
    else
    {

        self iprintln( "^1Host Only!" );

    }

}


//End Game
endGame()
{

    if( self.access == "Host" )
    {

        level thread maps\mp\gametypes\_gamelogic::forceend();

    }
    else
    {

        self iprintln( "^1Host Only!" );

    }

}


//Change Gametype
ChangeGametype( gametype )
{

    if( self.access == "Host" )
    {

        setDvar( "g_gametype", gametype );
        setDvar( "ui_gametype", gametype );
	    map_restart( false );

    }
    else
    {

        self iprintln( "^1Host Only!" );

    }

}


//Infinite Game
infinite_game()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self.infinite_game = !return_toggle( self.infinite_game );

        if( level.InfiniteGame == false )
	    {

            setDvar( "scr_sd_scorelimit", 0 );
            setDvar( "scr_sd_timelimit", 0 );
            setDvar( "scr_sd_roundlimit", 0 );
            setDvar( "scr_sd_winlimit", 0 );
            setDvar( "scr_dom_roundlimit", 0 );
	        setDvar( "scr_dom_scorelimit", 0 );
            setDvar( "scr_dom_timelimit", 0 );
            setDvar( "scr_dom_winlimit", 0 );
	        setDvar( "scr_horde_roundlimit", 0 );
	        setDvar( "scr_horde_winlimit", 0 );
            setDvar( "scr_horde_scorelimit", 0 );
            setDvar( "scr_horde_timelimit", 0 );
            setDvar( "scr_sr_winlimit", 0 );
            setDvar( "scr_sr_roundlimit", 0 );
            setDvar( "scr_sr_scorelimit", 0 );
            setDvar( "scr_sr_timelimit", 0 );
            setDvar( "scr_conf_roundlimit", 0 );
            setDvar( "scr_conf_scorelimit", 0 );
            setDvar( "scr_conf_winlimit", 0 );
            setDvar( "scr_infect_roundlimit", 0 );
            setDvar( "scr_infect_winlimit", 0 );
            setDvar( "scr_infect_timelimit", 0 );
            setDvar( "scr_dm_roundlimit", 0 );
            setDvar( "scr_dm_timelimit", 0 );
            setDvar( "scr_dm_scorelimit", 0 );
            setDvar( "scr_dm_winlimit", 0 );
            setDvar( "scr_war_scorelimit", 0 );
            setDvar( "scr_war_winlimit", 0 );
            setDvar( "scr_war_roundlimit", 0 );
	        maps\mp\gametypes\_gamelogic::pausetimer();
	        self iPrintln( "^:Infinite Game: ^7[^2On^7]" );
            level.InfiniteGame = true;

	    }
	    else
	    {

		    setDvar( "scr_sd_scorelimit", 1 );
            setDvar( "scr_sd_timelimit", 2.5 );
            setDvar( "scr_sd_roundlimit", 0 );
            setDvar( "scr_sd_winlimit", 4 );
            setDvar( "scr_dom_roundlimit", 1 );
	        setDvar( "scr_dom_scorelimit", 200 );
            setDvar( "scr_dom_timelimit", 0 );
            setDvar( "scr_dom_winlimit", 1 );
	        setDvar( "scr_horde_roundlimit", 1 );
	        setDvar( "scr_horde_winlimit", 1 );
            setDvar( "scr_horde_scorelimit", 0 );
            setDvar( "scr_horde_timelimit", 0 );
            setDvar( "scr_sr_winlimit", 6 );
            setDvar( "scr_sr_roundlimit", 0 );
            setDvar( "scr_sr_scorelimit", 1 );
            setDvar( "scr_sr_timelimit", 2.5 );
            setDvar( "scr_conf_roundlimit", 1 );
            setDvar( "scr_conf_scorelimit", 65 );
            setDvar( "scr_conf_winlimit", 1 );
            setDvar( "scr_infect_roundlimit", 1 );
            setDvar( "scr_infect_winlimit", 1 );
            setDvar( "scr_infect_timelimit", 10 );
            setDvar( "scr_dm_roundlimit", 1 );
            setDvar( "scr_dm_timelimit", 10 );
            setDvar( "scr_dm_scorelimit", 25 );
            setDvar( "scr_dm_winlimit", 1 );
            setDvar( "scr_war_scorelimit", 75 );
            setDvar( "scr_war_winlimit", 1 );
            setDvar( "scr_war_roundlimit", 1 );
	        maps\mp\gametypes\_gamelogic::resumetimer();
	        self iPrintln( "^:Infinite Game: ^7[^1Off^7]" );
            level.InfiniteGame = false;

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}


//Change Map
ChangeMap( map )
{

    //executecommand( "map " + map );

}


//Set FOV Slider
set_fov( fov )
{

    setDvar( "cg_fov", fov );

}


//Print Menu Controls
print_controls()
{

    self iprintln( "^:[{+speed_throw}] + [{+melee_zoom}] to open menu" );
	self iprintln( "^:[{+attack}] / [{+speed_throw}] to scroll up or down" );
    self iprintln( "^:[{+frag}] / [{+smoke}] to slide left or right" );
    self iprintln( "^:[{+activate}] to accept [{+melee_zoom}] to go back" );

}
////////////////////////////////////////////////////////////////////////////////////////
//Bots
////////////////////////////////////////////////////////////////////////////////////////

//Spawn Bot
spawn_bot( team ) //ref: maps/mp/bots/_bots.gsc
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        level thread _spawn_bot( 1 , team, undefined, undefined, "spawned_player", level.BotDifficulty );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

_spawn_bot( count, team, callback, stopWhenFull, notifyWhenDone, difficulty )
{

    name = "";
    difficulty = level.BotDifficulty;

    time = gettime() + 10000;
    connectingArray = [];
    squad_index = connectingArray.size;
    while( level.players.size < maps\mp\bots\_bots_util::bot_get_client_limit() && connectingArray.size < count && gettime() < time )
    {

        maps\mp\gametypes\_hostmigration::waitlongdurationwithhostmigrationpause( 0.05 );
        botent                 = addbot( name, team );
        connecting             = spawnstruct();
        connecting.bot         = botent;
        connecting.ready       = 0;
        connecting.abort       = 0;
        connecting.index       = squad_index;
        connecting.difficultyy = difficulty;
        connectingArray[connectingArray.size] = connecting;
        connecting.bot thread maps\mp\bots\_bots::spawn_bot_latent( team, callback, connecting );
        squad_index++;

    }

    connectedComplete = 0;
    time = gettime() + 60000;
    while( connectedComplete < connectingArray.size && gettime() < time )
    {

        connectedComplete = 0;
        foreach( connecting in connectingArray )
        {

            if( connecting.ready || connecting.abort )
                connectedComplete++;

        }

        wait 0.05;

    }

    if( isdefined( notifyWhenDone ) )
        self notify( notifyWhenDone );

}

//Spawns Multiple Bots
multi_bots( amount, team )
{

    for( i = 0; i < amount; i++ ) 
    {

        self thread spawn_bot( team );
        wait 0.1;

    }

}

//Bot Fill
bot_fill( team )
{

    while ( level.players.size < 18 )
    {

        self thread spawn_bot( team );
        wait 0.1;

    }

}


//Remove Bots
remove_bots()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        for(i = 0; i < level.players.size; i++)
	    {

		    if ( isSubStr( level.players[i].guid, "bot") )
		    {

			    kick ( level.players[i] getEntityNumber() );

		    }

		    wait 0.05;

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}


//Bot Difficulty
bot_difficulty( Difficulty )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        level.BotDifficulty = Difficulty;
	    self iprintln( "^:Bot Difficulty Set: " + level.BotDifficulty );
	    self iprintln( "^:Newly spawned bots will be the set difficulty" );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}


//Freeze Bots
freeze_bots()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self.freeze_bots = !return_toggle( self.freeze_bots );

	    if( level.FreezeBots == false )
	    {

		    foreach( player in level.players )
		    {

			    if( isSubStr( player getguid(), "bot" ) ) 
				    player freezeControls( true );

		    }

		    level.FreezeBots = true;
		    self iPrintln( "^:Bots Frozen" );

	    }
	    else
	    {

		    foreach( player in level.players )
		    {

			    if( isSubStr( player getguid(), "bot" ) )
				    player freezeControls( false );

		    }

		    level.FreezeBots = false;
		    self iPrintln( "^:Bots Unfrozen" );

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}


//Teleport Bots to Crosshair
crosshair_bots()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        // Get the crosshair trace to determine where the player is looking
        forwardTrace = self getEye() + ( anglestoforward( self getPlayerAngles() ) * 1000000 );
        traceResult = bulletTrace( self getEye(), forwardTrace, false, self );

        // Get the hit position
        teleportPosition = traceResult[ "position" ];

        // Loop through all players in the level
        foreach( player in level.players )
        {

            // Check if the player is a bot
            if( isSubStr( player.guid, "bot" ) )
            {

                // Teleport the bot to the teleport position
                player setOrigin( teleportPosition );
                self iprintln( "^:Bots Teleported" );

            }

        }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

////////////////////////////////////////////////////////////////////////////////////////
//Player Functions
////////////////////////////////////////////////////////////////////////////////////////

/*

set_health( health ) {
    self.maxhealth = isdefined( health ) ? health : 100;
    self.health    = self.maxhealth;
}

respawn_player() {
    if( self.sessionstate == "spectator" )
        self maps\mp\gametypes\_playerlogic::spawnclient();
}

*/

set_origin( origin, angles )
{

    self setorigin( isdefined( origin ) ? origin : self.m203[ "user" ].spawn_origin );
    self setplayerangles( isdefined( angles ) ? angles : self.m203[ "user" ].spawn_angles );

}


//God Mode
god_mode()
{

    self endon("disconnect");
    if( self.access == "Host" || self.access == "Admin" )
    {

        self.god_mode = !return_toggle( self.god_mode );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

give_god_mode( selected )
{

    self endon("disconnect");
    if( self.access == "Host" || self.access == "Admin" )
    {

        selected.health = 9999999;
        selected maps\mp\_utility::giveperk( "specialty_regenspeed", false );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

remove_god_mode( selected )
{

    self endon("disconnect");
    if( self.access == "Host" || self.access == "Admin" )
    {

        selected.health = 100;
        selected maps\mp\_utility::_unsetperk( "specialty_regenspeed" );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

//Commit Sudoku
kill_urself()
{

    self suicide();

}


//Change Class
ChangeClass()
{

	self endon("disconnect");
	self endon("death");
	
	self maps\mp\gametypes\_menus::beginclasschoice();
    maps\mp\gametypes\_class::giveandapplyloadout( self.team, self.class );

}


//Go to Space
sendToSpace()
{

    x = randomIntRange( -75, 75 );
    y = randomIntRange( -75, 75 );
    z = 45;
    space_location = ( 0 + x, 0 + y, 170000 + z );
    space_angle = ( 0, 176, 0 );
    self setOrigin( space_location );
    self setPlayerAngles( space_angle );

}


//Multi Jump Toggle
MultiJump()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self.MultiJump = !return_toggle( self.MultiJump );

        self endon( "disconnect" );
        self endon( "multijumpend" );

	    if( level.MultiJump == false )
	    {

            level.MultiJump = true;
            self iPrintln( "^:Multi Jump: ^7[^2On^7]" );

            self thread landsOnGround();

            if( !isDefined( self.numOfMultijumps ) )
                self.numOfMultijumps = 999;

            for(;;)
            {

                currentNum = 0;

                while( !self jumpbuttonpressed() ) wait 0.05;
                while( self jumpbuttonpressed() ) wait 0.05;

                if( getDvarInt( "jump_height" ) > 250 )
                    continue;

                if ( !isAlive( self ) )
                {

                    self waittill("spawned_player");
                    continue;

                }

                if ( !self isOnGround() )
                {

                    while( !self isOnGround() && isAlive( self ) && currentNum < self.numOfMultijumps )
                    {

                        waittillResult = self waittill_any_timeout( 0.11, "landedOnGround", "disconnect", "death" );
                        while( waittillResult == "timeout" )

                        {

                            if( self jumpbuttonpressed() )
                            {

                                waittillResult = "jump";
                                break;

                            }

                            waittillResult = self waittill_any_timeout( 0.05, "landedOnGround", "disconnect", "death" );

                        }

                        if(waittillResult == "jump" && !self isOnGround() && isAlive( self ))
                        {

                            playerAngles = self getplayerangles();
                            playerVelocity = self getVelocity();
                            self setvelocity( ( playerVelocity[0], playerVelocity[1], playerVelocity[2] / 2 ) + anglestoforward( ( 270, playerAngles[1], playerAngles[2] ) ) * getDvarInt( "jump_height" ) * ( ( ( -1 / 39 ) * getDvarInt( "jump_height" ) ) + ( 17 / 2 ) ) );

                            currentNum++;
                            while( self jumpbuttonpressed() ) 
                                wait 0.05;

                        }

                        else
                            break;

                    }

                    while( !self isOnGround() )
                        wait 0.05;

                }

            }

	    }
	    else
	    {

            level.MultiJump = false;
            self iPrintln( "^:Multi Jump: ^7[^1Off^7]" );
            self notify( "multijumpend" );

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

landsOnGround()
{

    self endon( "disconnect" );
    loopResult = true;
    for(;;)
    {

        wait 0.05;
        newResult = self isOnGround();
        if( newResult != loopResult )
        {

            if( !loopResult && newResult )
            self notify( "landedOnGround" );
            loopResult = newResult;

        }

    }

}


//Set Gravity
gravity_set( gravity_set )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        setDvar( "g_gravity", gravity_set );
	    self iPrintln( "^:Gravity set to: " + gravity_set );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}


//Set Timescale
timescale_set( timescale_set )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        setDvar( "timescale", timescale_set );
	    self iPrintln( "^:Timescale set to: " + timescale_set );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}


//Set Jumpheight
jumpheight_set( jumpheight_set )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        setDvar( "jump_height", jumpheight_set );
	    self iPrintln( "^:Jump height set to: " + jumpheight_set );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}


//Set Speed
speed_set( speed_set )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        setDvar( "g_speed", speed_set );
	    self iPrintln( "^:Speed set to: " + speed_set );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}


//Pro Mod
ProMod()
{

    self.ProMod = !return_toggle( self.ProMod );

	if( level.ProMod == false )
	{

		self VisionSetNakedForPlayer( "default", 2 ); 
        setDvar( "player_breath_snd_delay ", "0" );
        setDvar( "perk_extraBreath", "0" );
        setDvar( "cg_brass", "0" );
        setDvar( "cg_fov", "95" );
        setDvar( "cg_fovscale", "1.125" );
        setDvar( "r_blur", "0.3" );
        setDvar( "r_specularcolorscale", "10" );
        setDvar( "r_filmusetweaks", "1" );
        setDvar( "r_filmtweakenable", "1" );
        setDvar( "r_filmtweakcontrast", "1.6" );
        setDvar( "r_brightness", "0" );
        setDvar( "g_teamcolor_axis", "1 0.0 00.0" );
        setDvar( "g_teamcolor_allies", "0 0.0 00.0" );
        setDvar( "fx_drawclouds", "0" );
        setDvar( "cg_blood", "0" );
        setDvar( "r_dlightLimit", "0" );
        setDvar( "r_fog", "0" );
        level.ProMod = true;
        self iPrintln( "^:Pro Mod: ^7[^2On^7]" );

	}
	else
	{

		self VisionSetNakedForPlayer( getdvar( "mapname" ), 0.5 );
        setDvar( "player_breath_snd_delay ", "1" );
        setDvar( "perk_extraBreath", "5" );
        setDvar( "cg_brass", "1" );
        setDvar( "cg_fov", "90" );
        setDvar( "cg_fovscale", "1.125" );
        setDvar( "r_blur", "0" );
        setDvar( "r_specularcolorscale", "0" );
        setDvar( "r_filmusetweaks", "0" );
        setDvar( "r_filmtweakenable", "0" );
        setDvar( "r_filmtweakcontrast", "1.4" );
        setDvar( "r_brightness", "0" );
        setDvar( "g_teamcolor_axis", "0.721569 0.2 0.2 1" );
        setDvar( "g_teamcolor_allies", "0.439216 0.811765 1 1" );
        setDvar( "fx_drawclouds", "1" );
        setDvar( "cg_blood", "1" );
        setDvar( "r_dlightLimit", "8" );
        setDvar( "r_fog", "1" );
        level.ProMod = false;
        self iPrintln( "^:Pro Mod: ^7[^1Off^7]" );

	}

}

////////////////////////////////////////////////////////////////////////////////////////
//Perks
////////////////////////////////////////////////////////////////////////////////////////


//Give All Perks
all_perks()
{

    self endon("disconnect");
    if( self.access == "Host" || self.access == "Admin" )
    {

        self.all_perks = !return_toggle( self.all_perks );

	    if( level.AllPerks == false )
	    {

            self maps\mp\_utility::giveperk( "specialty_longersprint", false );
		    self maps\mp\_utility::giveperk( "specialty_fastmantle", false );
		    self maps\mp\_utility::giveperk( "specialty_fastreload", false );
		    self maps\mp\_utility::giveperk( "specialty_quickdraw", false );
		    self maps\mp\_utility::giveperk( "specialty_scavenger", false );
		    self maps\mp\_utility::giveperk( "specialty_extraammo", false );
		    self maps\mp\_utility::giveperk( "specialty_bling", false );
		    self maps\mp\_utility::giveperk( "specialty_secondarybling", false );
		    self maps\mp\_utility::giveperk( "specialty_onemanarmy", false );
		    self maps\mp\_utility::giveperk( "specialty_omaquickchange", false );
		    self maps\mp\_utility::giveperk( "specialty_bulletdamage", false );
		    self maps\mp\_utility::giveperk( "specialty_armorpiercing", false );
		    self maps\mp\_utility::giveperk( "specialty_lightweight", false );
		    self maps\mp\_utility::giveperk( "specialty_fastsprintrecovery", false );
		    self maps\mp\_utility::giveperk( "specialty_hardline", false );
		    self maps\mp\_utility::giveperk( "specialty_rollover", false );
		    self maps\mp\_utility::giveperk( "specialty_radarimmune", false );
		    self maps\mp\_utility::giveperk( "specialty_spygame", false );
		    self maps\mp\_utility::giveperk( "specialty_explosivedamage", false );
		    self maps\mp\_utility::giveperk( "specialty_dangerclose", false );
		    self maps\mp\_utility::giveperk( "specialty_extendedmelee", false );
		    self maps\mp\_utility::giveperk( "specialty_falldamage", false );
		    self maps\mp\_utility::giveperk( "specialty_bulletaccuracy", false );
		    self maps\mp\_utility::giveperk( "specialty_holdbreath", false );
		    self maps\mp\_utility::giveperk( "specialty_localjammer", false );
		    self maps\mp\_utility::giveperk( "specialty_delaymine", false );
		    self maps\mp\_utility::giveperk( "specialty_heartbreaker", false );
		    self maps\mp\_utility::giveperk( "specialty_quieter", false );
		    self maps\mp\_utility::giveperk( "specialty_detectexplosive", false );
		    self maps\mp\_utility::giveperk( "specialty_selectivehearing", false );
		    self maps\mp\_utility::giveperk( "specialty_pistoldeath", false );
		    self maps\mp\_utility::giveperk( "specialty_laststandoffhand", false );
		    self maps\mp\_utility::giveperk( "specialty_combathigh", false );
		    self maps\mp\_utility::giveperk( "specialty_shield", false );
		    self maps\mp\_utility::giveperk( "specialty_feigndeath", false );
		    self maps\mp\_utility::giveperk( "specialty_shellshock", false );
		    self maps\mp\_utility::giveperk( "specialty_blackbox", false );
		    self maps\mp\_utility::giveperk( "specialty_steelnerves", false );
		    self maps\mp\_utility::giveperk( "specialty_saboteur", false );
		    self maps\mp\_utility::giveperk( "specialty_endgame", false );
		    self maps\mp\_utility::giveperk( "specialty_rearview", false );
		    self maps\mp\_utility::giveperk( "specialty_primarydeath", false );
		    self maps\mp\_utility::giveperk( "specialty_hardjack", false );
		    self maps\mp\_utility::giveperk( "specialty_extraspecialduration", false );
		    self maps\mp\_utility::giveperk( "specialty_stun_resistance", false );
		    self maps\mp\_utility::giveperk( "specialty_double_load", false );
		    self maps\mp\_utility::giveperk( "specialty_regenspeed", false );
		    self maps\mp\_utility::giveperk( "specialty_autospot", false );
		    self maps\mp\_utility::giveperk( "specialty_twoprimaries", false );
		    self maps\mp\_utility::giveperk( "specialty_overkillpro", false );
		    self maps\mp\_utility::giveperk( "specialty_anytwo", false );
		    self maps\mp\_utility::giveperk( "specialty_fasterlockon", false );
		    self maps\mp\_utility::giveperk( "specialty_paint", false );
		    self maps\mp\_utility::giveperk( "specialty_paint_pro", false );
		    self maps\mp\_utility::giveperk( "specialty_silentkill", false );
		    self maps\mp\_utility::giveperk( "specialty_crouchmovement", false );
		    self maps\mp\_utility::giveperk( "specialty_personaluav", false );
		    self maps\mp\_utility::giveperk( "specialty_unwrapper", false );
		    self maps\mp\_utility::giveperk( "specialty_class_blindeye", false );
		    self maps\mp\_utility::giveperk( "specialty_class_lowprofile", false );
		    self maps\mp\_utility::giveperk( "specialty_class_coldblooded", false );
		    self maps\mp\_utility::giveperk( "specialty_class_hardwired", false );
		    self maps\mp\_utility::giveperk( "specialty_class_scavenger", false );
		    self maps\mp\_utility::giveperk( "specialty_class_hoarder", false );
		    self maps\mp\_utility::giveperk( "specialty_class_gungho", false );
		    self maps\mp\_utility::giveperk( "specialty_class_steadyhands", false );
		    self maps\mp\_utility::giveperk( "specialty_class_hardline", false );
		    self maps\mp\_utility::giveperk( "specialty_class_peripherals", false );
		    self maps\mp\_utility::giveperk( "specialty_class_quickdraw", false );
		    self maps\mp\_utility::giveperk( "specialty_class_lightweight", false );
		    self maps\mp\_utility::giveperk( "specialty_class_toughness", false );
		    self maps\mp\_utility::giveperk( "specialty_class_engineer", false );
		    self maps\mp\_utility::giveperk( "specialty_class_dangerclose", false );
		    self maps\mp\_utility::giveperk( "specialty_horde_weaponsfree", false );
		    self maps\mp\_utility::giveperk( "specialty_horde_dualprimary", false );
		    self maps\mp\_utility::giveperk( "specialty_marksman", false );
		    self maps\mp\_utility::giveperk( "specialty_sharp_focus", false );
		    self maps\mp\_utility::giveperk( "specialty_moredamage", false );
		    self maps\mp\_utility::giveperk( "specialty_copycat", false );
		    self maps\mp\_utility::giveperk( "specialty_finalstand", false );
		    self maps\mp\_utility::giveperk( "specialty_juiced", false );
		    self maps\mp\_utility::giveperk( "specialty_light_armor", false );
		    self maps\mp\_utility::giveperk( "specialty_stopping_power", false );
		    self maps\mp\_utility::giveperk( "specialty_uav", false );
		    self iPrintln( "^:All Perks: ^7[^2On^7]" );
		    level.AllPerks = true;

	    }
	    else
	    {

		    self maps\mp\_utility::_unsetperk( "specialty_longersprint" );
		    self maps\mp\_utility::_unsetperk( "specialty_fastmantle" );
		    self maps\mp\_utility::_unsetperk( "specialty_fastreload" );
		    self maps\mp\_utility::_unsetperk( "specialty_quickdraw" );
		    self maps\mp\_utility::_unsetperk( "specialty_scavenger" );
		    self maps\mp\_utility::_unsetperk( "specialty_extraammo" );
		    self maps\mp\_utility::_unsetperk( "specialty_bling" );
		    self maps\mp\_utility::_unsetperk( "specialty_secondarybling" );
		    self maps\mp\_utility::_unsetperk( "specialty_onemanarmy" );
		    self maps\mp\_utility::_unsetperk( "specialty_omaquickchange" );
		    self maps\mp\_utility::_unsetperk( "specialty_bulletdamage" );
		    self maps\mp\_utility::_unsetperk( "specialty_armorpiercing" );
		    self maps\mp\_utility::_unsetperk( "specialty_lightweight" );
		    self maps\mp\_utility::_unsetperk( "specialty_fastsprintrecovery" );
		    self maps\mp\_utility::_unsetperk( "specialty_hardline" );
		    self maps\mp\_utility::_unsetperk( "specialty_rollover" );
		    self maps\mp\_utility::_unsetperk( "specialty_radarimmune" );
		    self maps\mp\_utility::_unsetperk( "specialty_spygame" );
		    self maps\mp\_utility::_unsetperk( "specialty_explosivedamage" );
		    self maps\mp\_utility::_unsetperk( "specialty_dangerclose" );
		    self maps\mp\_utility::_unsetperk( "specialty_extendedmelee" );
		    self maps\mp\_utility::_unsetperk( "specialty_falldamage" );
		    self maps\mp\_utility::_unsetperk( "specialty_bulletaccuracy" );
		    self maps\mp\_utility::_unsetperk( "specialty_holdbreath" );
		    self maps\mp\_utility::_unsetperk( "specialty_localjammer" );
		    self maps\mp\_utility::_unsetperk( "specialty_delaymine" );
		    self maps\mp\_utility::_unsetperk( "specialty_heartbreaker" );
		    self maps\mp\_utility::_unsetperk( "specialty_quieter" );
		    self maps\mp\_utility::_unsetperk( "specialty_detectexplosive" );
		    self maps\mp\_utility::_unsetperk( "specialty_selectivehearing" );
		    self maps\mp\_utility::_unsetperk( "specialty_pistoldeath" );
		    self maps\mp\_utility::_unsetperk( "specialty_laststandoffhand" );
		    self maps\mp\_utility::_unsetperk( "specialty_combathigh" );
		    self maps\mp\_utility::_unsetperk( "specialty_shield" );
		    self maps\mp\_utility::_unsetperk( "specialty_feigndeath" );
		    self maps\mp\_utility::_unsetperk( "specialty_shellshock" );
		    self maps\mp\_utility::_unsetperk( "specialty_blackbox" );
		    self maps\mp\_utility::_unsetperk( "specialty_steelnerves" );
		    self maps\mp\_utility::_unsetperk( "specialty_saboteur" );
		    self maps\mp\_utility::_unsetperk( "specialty_endgame" );
		    self maps\mp\_utility::_unsetperk( "specialty_rearview" );
		    self maps\mp\_utility::_unsetperk( "specialty_primarydeath" );
		    self maps\mp\_utility::_unsetperk( "specialty_hardjack" );
		    self maps\mp\_utility::_unsetperk( "specialty_extraspecialduration" );
		    self maps\mp\_utility::_unsetperk( "specialty_stun_resistance" );
		    self maps\mp\_utility::_unsetperk( "specialty_double_load" );
		    self maps\mp\_utility::_unsetperk( "specialty_regenspeed" );
		    self maps\mp\_utility::_unsetperk( "specialty_autospot" );
		    self maps\mp\_utility::_unsetperk( "specialty_twoprimaries" );
		    self maps\mp\_utility::_unsetperk( "specialty_overkillpro" );
		    self maps\mp\_utility::_unsetperk( "specialty_anytwo" );
		    self maps\mp\_utility::_unsetperk( "specialty_fasterlockon" );
		    self maps\mp\_utility::_unsetperk( "specialty_paint" );
		    self maps\mp\_utility::_unsetperk( "specialty_paint_pro" );
		    self maps\mp\_utility::_unsetperk( "specialty_silentkill" );
		    self maps\mp\_utility::_unsetperk( "specialty_crouchmovement" );
		    self maps\mp\_utility::_unsetperk( "specialty_personaluav" );
		    self maps\mp\_utility::_unsetperk( "specialty_unwrapper" );
		    self maps\mp\_utility::_unsetperk( "specialty_class_blindeye" );
		    self maps\mp\_utility::_unsetperk( "specialty_class_lowprofile" );
		    self maps\mp\_utility::_unsetperk( "specialty_class_coldblooded" );
		    self maps\mp\_utility::_unsetperk( "specialty_class_hardwired" );
		    self maps\mp\_utility::_unsetperk( "specialty_class_scavenger" );
		    self maps\mp\_utility::_unsetperk( "specialty_class_hoarder" );
		    self maps\mp\_utility::_unsetperk( "specialty_class_gungho" );
		    self maps\mp\_utility::_unsetperk( "specialty_class_steadyhands" );
		    self maps\mp\_utility::_unsetperk( "specialty_class_hardline" );
		    self maps\mp\_utility::_unsetperk( "specialty_class_peripherals" );
		    self maps\mp\_utility::_unsetperk( "specialty_class_quickdraw" );
		    self maps\mp\_utility::_unsetperk( "specialty_class_lightweight" );
		    self maps\mp\_utility::_unsetperk( "specialty_class_toughness" );
		    self maps\mp\_utility::_unsetperk( "specialty_class_engineer" );
		    self maps\mp\_utility::_unsetperk( "specialty_class_dangerclose" );
		    self maps\mp\_utility::_unsetperk( "specialty_horde_weaponsfree" );
		    self maps\mp\_utility::_unsetperk( "specialty_horde_dualprimary" );
		    self maps\mp\_utility::_unsetperk( "specialty_marksman" );
		    self maps\mp\_utility::_unsetperk( "specialty_sharp_focus" );
		    self maps\mp\_utility::_unsetperk( "specialty_moredamage" );
		    self maps\mp\_utility::_unsetperk( "specialty_copycat" );
		    self maps\mp\_utility::_unsetperk( "specialty_finalstand" );
		    self maps\mp\_utility::_unsetperk( "specialty_juiced" );
		    self maps\mp\_utility::_unsetperk( "specialty_light_armor" );
		    self maps\mp\_utility::_unsetperk( "specialty_stopping_power" );
		    self maps\mp\_utility::_unsetperk( "specialty_uav" );
		    self iPrintln("^:All Perks: ^7[^1Off^7]");
		    level.AllPerks = false;

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

////////////////////////////////////////////////////////////////////////////////////////
//Third Person
////////////////////////////////////////////////////////////////////////////////////////

//Third Person Toggle
third_person()
{

    self.third_person = !return_toggle( self.third_person );

	istpp = getdvarint( "camera_thirdPerson" );

	if( istpp == false )
	{

        setDvar( "camera_thirdPerson", 1 );
		self iPrintln("^:Third Person: ^7[^2On^7]");

	}
	else
	{

		setDvar( "camera_thirdPerson", 0 );
		self iPrintln("^:Third Person: ^7[^1Off^7]");

	}

}

////////////////////////////////////////////////////////////////////////////////////////
//UFO Mode
////////////////////////////////////////////////////////////////////////////////////////

//UFO Mode Toggle
ufo_mode()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self.ufo_mode = !return_toggle( self.ufo_mode );

	    if( level.UFOMode == false )
	    {

		    self thread ufo_mode2();
            level.UFOMode = true;
            self iPrintln( "^:UFO Mode: ^7[^2On^7]" );
		    self iPrintln( "^:Hold [{+smoke}] to fly | Press [{+speed_throw}] to land" );

	    }
	    else
	    {

		    self notify( "EndUFOMode" );
            level.UFOMode = false;
            self iPrintln( "^:UFO Mode: ^7[^1Off^7]" );

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

ufo_mode2()
{

    self endon( "EndUFOMode" );
    self.Fly = 0;
    UFO = spawn( "script_model",self.origin );
    for(;;)
    {

        if( self secondaryoffhandbuttonpressed() )
        {

            self playerLinkTo( UFO );
            self.Fly = 1;

        }
        else
        {

            self.Fly = 0;

        }

        if( self AdsButtonPressed() && self.Fly == 0 )
        {

            self unlink();
            self.Fly = 0;
            self.UFO delete();

        }

        if( self.Fly == 1 )
        {

            Fly = self.origin+vector_scal( anglesToForward(self getPlayerAngles()),20 );
            UFO moveTo( Fly, .03 );

        }

        wait .001;

    }

}

////////////////////////////////////////////////////////////////////////////////////////
//Player Position
////////////////////////////////////////////////////////////////////////////////////////

//Load/Save Position
save_pos()
{

	self.pers[ "savePos" ] = self.origin;
	self.pers[ "saveAng" ] = self.angles;
	self iPrintLn( "^:Position Saved" );

}

load_pos()
{

	self setOrigin( self.pers[ "savePos" ] );
	self setPlayerAngles( self.pers[ "saveAng" ] );
	self iPrintLn( "^:Position Loaded" );

}


//Print Position
pos_print()
{

    self iPrintln( "^:" + self.origin );

}

//Print Weapon
pos_weapon()
{
    self iPrintln( "^:" + self getCurrentWeapon() );

}

////////////////////////////////////////////////////////////////////////////////////////
//Player Model Switcher
////////////////////////////////////////////////////////////////////////////////////////

/*
precache_models()
{

	scripts\mp_patches\custom_teams::tf141_assault_precache();
    scripts\mp_patches\custom_teams::tf141_smg_precache();
    scripts\mp_patches\custom_teams::tf141_lmg_precache();

    scripts\mp_patches\custom_teams::opfor_assault_precache();
    scripts\mp_patches\custom_teams::opfor_smg_precache();
    scripts\mp_patches\custom_teams::opfor_lmg_precache();

    scripts\mp_patches\custom_teams::spetsnaz_assault_precache();
    scripts\mp_patches\custom_teams::spetsnaz_smg_precache();
    scripts\mp_patches\custom_teams::spetsnaz_lmg_precache();

    scripts\mp_patches\custom_teams::rangers_assault_precache();
    scripts\mp_patches\custom_teams::rangers_smg_precache();
    scripts\mp_patches\custom_teams::rangers_lmg_precache();

    scripts\mp_patches\custom_teams::seals_assault_precache();
    scripts\mp_patches\custom_teams::seals_smg_precache();
    scripts\mp_patches\custom_teams::seals_lmg_precache();

    scripts\mp_patches\custom_teams::militia_assault_precache();
    scripts\mp_patches\custom_teams::militia_smg_precache();
    scripts\mp_patches\custom_teams::militia_lmg_precache();

    scripts\mp_patches\custom_teams::allies_ghillie_precache();
    scripts\mp_patches\custom_teams::axis_ghillie_precache();

    scripts\mp_patches\custom_teams::infected_precache();

}
*/

//Switch Viewmodel
viewmodel_switch()
{

	//todo

}


//Switch Player Model
model_switcher( team, weapon )
{

	//todo

}

////////////////////////////////////////////////////////////////////////////////////////
//Miscellaneous Functions
////////////////////////////////////////////////////////////////////////////////////////

//FIX THIS
//Death Barriers
death_barriers()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self.death_barriers = !return_toggle( self.death_barriers );

	    if( level.DeathBarriers == true )
        {

            ents = getEntArray();
		    for ( index = 0; index < ents.size; index++ )
		    {

			    if( isSubStr( ents[index].classname, "trigger_hurt" ) )
			    ents[index].origin = ( 0, 0, 9999999 );

		    }

		    level.DeathBarriers = false;
		    self iPrintln( "^:Death Barriers: ^7[^2Removed^7]" );
		

        }
	    else
	    {

		    ents = getEntArray();
		    for (index = 0; index < ents.size; index++)
		    {

			    if ( isSubStr( ents[index].classname, "trigger_hurt" ) )
			    {

				    // Restore the original position from the stored value
				    if ( isDefined( ents[index].originalOrigin ) )
				    {

					    ents[index].origin = ents[index].originalOrigin;

				    }
				    else
				    {

					    self iPrintln( "Original position not found for entity " + index + ", cannot reset." );

				    }

			    }

		    }

		    level.DeathBarriers = true;
		    self iPrintln( "^:Death Barriers: ^7[^1Reset^7]" );

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}


//Teleporter
teleporter()
{

    self _beginLocationSelection( "", "map_artillery_selector", true, ( level.mapSize / 5.625 ) );
    self.selectingLocation = true;
    self waittill( "confirm_location", location, directionYaw );
    newLocation = PhysicsTrace( location + ( 0, 0, 1000 ), location - ( 0, 0, 1000 ) );
    self SetOrigin( newLocation );
    self SetPlayerAngles( directionYaw );
	self iPrintln( "^:Teleported" );
    self notify( "used" );
    self endLocationSelection();
    self.selectingLocation = undefined;

}


//Thermal Vision Toggle
therm_vis()
{

    self.therm_vis = !return_toggle( self.therm_vis );

    if(level.therm_vis == false)
	{

		self maps\mp\_utility::giveperk( "specialty_thermal", false );
		self iPrintln( "^:Thermal Vision: ^7[^2On^7]" );
		level.therm_vis = true;
		

	}
	else
	{

		self maps\mp\_utility::_unsetperk( "specialty_thermal" );
		self iPrintln( "^:Thermal Vision: ^7[^1Off^7]" );
		level.therm_vis = false;

	}

}


//Disco Vision
DiscoMode()
{

	if( !self.DiscoDisco )
	{

		self.DiscoDisco = true;

	}
	else
	{

		self notify( "endThaFukingDisco" );
		self VisionSetNakedForPlayer( "default",0.5 );
		self.DiscoDisco = false;
		return;

	}
	self endon( "disconnect" );
	self endon( "endThaFukingDisco" );
	visions = "default_night_mp thermal_mp cheat_chaplinnight cobra_sunset3 cliffhanger_heavy armada_water mpnuke_aftermath icbm_sunrise4 missilecam grayscale";
	Vis = strTok( visions, " " );
	self iprintln( "Disco Disco, Good Good" );
	i = 0;
	for(;;)
	{

		//VisionSetNaked( Vis[i], 0.5 );
		self VisionSetNakedForPlayer( Vis[i], 0.5 );
		i++;
		if( i >= Vis.size )i = 0;
		wait 0.5;

	}

}


//Earthquake
Earthquake1()
{

   if( self.access == "Host" || self.access == "Admin" )
    {

        self iPrintln( "^:Earthquake started!" );
        earthquake( 0.6, 10, self.origin, 100000 );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}


//Laser Toggle
LaserToggle()
{

    self.LaserToggle = !return_toggle( self.LaserToggle );

	if( level.LaserToggle == false )
	{

		self laseron( "mp_attachment_lasersight" );
        level.LaserToggle = true;
        self iPrintln( "^:Laser: ^7[^2On^7]" );

	}
	else
	{

		self laseroff();
        level.LaserToggle = false;
        self iPrintln( "^:Laser: ^7[^1Off^7]" );

	}

}


//Disco Sun Toggle
sun_disco()
{

    self.DiscoSun = !return_toggle( self.DiscoSun );

	if( level.DiscoSun == false )
	{

        level.DiscoSun = true;
        self iPrintln( "^:Disco Sun: ^7[^2On^7]" );

		setdvar( "r_filmusetweaks","1" );
    	setdvar( "r_filmTweakenable","1" );
    	setdvar( "r_filmTweakbrightness",".2" );

    	while( level.DiscoSun == true )
    	{

			level.discox=randomFloatRange( 0.0, 2.0 );
        	level.discoy=randomFloatRange( 0.0, 2.0 );
        	level.discoz=randomFloatRange( 0.0, 2.0 );

        	setdvar( "r_filmtweakLighttint", level.discox + " " + level.discoy + " " + level.discoz );
        	wait .15;

    	}

	}
	else
	{
		setdvar( "r_filmusetweaks", "0" );
    	setdvar( "r_filmTweakenable", "0" );
    	setdvar( "r_filmTweakbrightness", "0" );

		setdvar( "r_filmtweakLighttint", "1.1 1.05 0.85" );

        level.DiscoSun = false;
        self iPrintln( "^:Disco Sun: ^7[^1Off^7]" );

	}

}


//Sun Color
sun_color( color, name )
{

    if( level.DiscoSun == true )
    {
        sun_disco();
        if( color != "1.1 1.05 0.85" )
        {

            setdvar( "r_filmusetweaks","1" );
            setdvar( "r_filmTweakenable","1" );
            setdvar( "r_filmTweakbrightness",".2" );
            setdvar( "r_filmtweakLighttint", color );
            self iprintln( "^:Sun color set: " + name );

        }
        else
        {

            setdvar( "r_filmusetweaks", "0" );
    	    setdvar( "r_filmTweakenable", "0" );
    	    setdvar( "r_filmTweakbrightness", "0" );
		    setdvar( "r_filmtweakLighttint", color );
            self iprintln( "^:Sun color set: " + name );

        }

    }
    else
    {

        if( color != "1.1 1.05 0.85" )
        {

            setdvar( "r_filmusetweaks","1" );
            setdvar( "r_filmTweakenable","1" );
            setdvar( "r_filmTweakbrightness",".2" );
            setdvar( "r_filmtweakLighttint", color );
            self iprintln( "^:Sun color set: " + name );

        }
        else
        {

            setdvar( "r_filmusetweaks", "0" );
    	    setdvar( "r_filmTweakenable", "0" );
    	    setdvar( "r_filmTweakbrightness", "0" );
		    setdvar( "r_filmtweakLighttint", color );
            self iprintln( "^:Sun color set: " + name );

        }

    }

}


//Vision Changer
vision_changer( vision )
{

    if( vision != "default" )
    {

        setdvar( "r_filmusetweaks", "0" );
    	setdvar( "r_filmTweakenable", "0" );
    	setdvar( "r_filmTweakbrightness", "0" );
        self VisionSetNakedForPlayer( vision, 0 );
        self iPrintln( "^:Vision Set: " + vision );

    }
    else
    {

        setdvar( "r_filmusetweaks", "0" );
    	setdvar( "r_filmTweakenable", "0" );
    	setdvar( "r_filmTweakbrightness", "0" );
        self VisionSetNakedForPlayer( getdvar( "mapname" ), 0.5 );
        self iPrintln( "^:Vision Set: " + vision );

    }

}


//Spawn Dead Clone
deadclone()
{

    self iprintln("^:Dead Clone Spawned");
    clone = self ClonePlayer( 9999 );
    clone startragdoll( 1 );

}


//Human Centipede
centipede()
{

    self.centipede = !return_toggle( self.centipede );

    if( level.centipede == false )
	{

        level.centipede = true;
        self iPrintln( "^:Human Centipede: ^7[^2On^7]" );
        self endon( "stop_centipede" );
	    self endon( "disconnect" );
	    self endon( "death" );
	    while( 1 )
	    {

		    ent = self ClonePlayer( 9999999 );
		    wait 0.1;
		    ent thread destroyModelOnTime( 3 );

	    }

	}
	else
	{

        self notify( "stop_centipede" );
        level.centipede = false;
        self iPrintln( "^:Human Centipede: ^7[^1Off^7]" );

	}

}


//Matrix Mode
matrix_mode()
{ 

    if( self.access == "Host" || self.access == "Admin" )
    {

        self.matrix_mode = !return_toggle( self.matrix_mode );

        if( level.matrix_mode == false )
	    {

            level.matrix_mode = true;
            self iPrintLn("^:Matrix Mode ^7[^2On^7]");
            self endon( "disconnect" );
	        self endon( "MatrixOff" );
	
	        for(;;)
	        {

		        if( self isFiring() )
		        {

			        setDvar( "timescale", 0.25 );
                    self setclientdvar( "r_blur", 0.7 );
                    self VisionSetNakedForPlayer( "remote_mortar_enhanced", 0.1 );

	            }
	            else
	            {

                    self VisionSetNakedForPlayer( getdvar( "mapname" ), 0.5 );
	    	        setdvar( "timescale", 1 );
	    	        self setclientdvar( "r_blur", 0 );

                }

		        wait 0.01;

	        }

	    }
	    else
	    {

		    self notify( "MatrixOff" );
            level.matrix_mode = false;
            self iPrintLn("^:Matrix Mode ^7[^1Off^7]");

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

////////////////////////////////////////////////////////////////////////////////////////
//Weapon Functions
////////////////////////////////////////////////////////////////////////////////////////

//Give Ammo
give_ammo()
{

	weapon = self getCurrentWeapon();
	offhand = self getCurrentOffhand();

	self setWeaponAmmoStock(weapon, 999);
	self setWeaponAmmoStock(offhand, 999);
	
	self GiveMaxAmmo( weapon );
	self GiveMaxAmmo( offhand );

}


//Infinite Ammo
inf_ammo()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self.inf_ammo = !return_toggle( self.inf_ammo );

        if( level.inf_ammo == false )
	    {

            level.inf_ammo = true;

            if( level.rapid_fire == true )
            {

                self thread rapid_fire();

            }

            self iPrintln( "^:Infinite Ammo: ^7[^2On^7]" );
            while( level.inf_ammo == true )
	        {

		        weapon = self GetCurrentWeapon();

		        self SetWeaponAmmoStock( weapon, weaponmaxammo( weapon ) );
		        self SetWeaponAmmoClip( weapon, weaponClipSize( weapon ) );
		        self SetWeaponAmmoClip( weapon, weaponClipSize( weapon ), "left" );

		        self common_scripts\utility::waittill_any( "weapon_fired" );

	        }

	    }
	    else
	    {

            level.inf_ammo = false;
            self iPrintln( "^:Infinite Ammo: ^7[^1Off^7]" );

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}


//Take Weapon
take_weapon()
{

	weapon = self getCurrentWeapon();

	self takeWeapon( weapon );
	self iprintln( "^:" + weapon + " removed" );

}

take_all_weapons()
{

    self takeAllWeapons();

}


//Reset Weapon
reset_weapon()
{

	weapon = self getCurrentWeapon();
	weaponbase = self getbaseweaponname( weapon );
	newWeapon = weaponbase + "_mp";

	if(newWeapon == weapon)
	{

		self giveWeapon( newWeapon );
		self switchToWeapon( newWeapon );
		self iprintln( "^:Weapon reset" );

	}
	else
	{

		self giveWeapon( newWeapon );
		self takeWeapon( weapon );
		self switchToWeapon( newWeapon );
		self iprintln( "^:Weapon reset" );

	}

}


//Give Weapon
give_weapon( weapon )
{

	self giveWeapon( weapon );
	self switchToWeapon( weapon );
	self iprintln( "^:" + weapon + " added" );

}


//Give Killstreak
give_killstreak( killstreak )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self maps\mp\gametypes\_hardpoints::giveHardpoint( killstreak );
	    self iprintln( "^:Killstreak Given: " + killstreak );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}


//Give Equipment
give_equipment( equipment )
{

	self settacticalweapon( equipment );
	self setweaponammoclip( equipment, 99 );
    self GiveMaxAmmo( equipment );
	self iprintln( "^:Equipment Given: " + equipment );

}

//Give Lethal
give_lethal( lethal )
{

    self setlethalweapon( lethal );
    self setweaponammoclip( lethal, 99 );
    self GiveMaxAmmo( lethal );
    self iprintln( "^:Lethal Given: " + lethal );

}


//rapid fire
rapid_fire()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self.rapid_fire = !return_toggle( self.rapid_fire );

	    if( level.rapid_fire == false )
	    {

            level.rapid_fire = true;

            if( level.inf_ammo == true )
            {

                self thread inf_ammo();

            }

		    self maps\mp\_utility::giveperk( "specialty_fastreload", false );
		    setDvar( "perk_weapReloadMultiplier", "0.0001" );
            self iPrintln("^:Rapid Fire: ^7[^2On^7]");
		    self iPrintln("^:Hold [{+reload}] & [{+attack}]! ");
		    self endon ( "endRapid" );

    	    while(1)
    	    {

        	    self setWeaponAmmoStock( self getCurrentWeapon(), 999 );
        	    wait 0.05;

    	    }

	    }
	    else
	    {

		    self notify ( "endRapid" );
            level.rapid_fire = false;
		    setDvar( "perk_weapReloadMultiplier", "0.5" );
            self iPrintln( "^:Rapid Fire: ^7[^1Off^7]" );

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}


//No Recoil
NoRecoil()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self.NoRecoil = !return_toggle( self.NoRecoil );

        self endon("disconnect");

	    if( level.NoRecoil == false )
	    {

            maps\mp\_utility::setrecoilscale(100, 0);
            level.NoRecoil = true;
            self iPrintln( "^:No Recoil: ^7[^2On^7] ^1(bugged, doesn't turn off)" );

	    }
	    else
	    {

            maps\mp\_utility::setrecoilscale(0, 0);
            level.NoRecoil = false;
            self iPrintln( "^:No Recoil: ^7[^1Off^7] ^1(bugged, doesn't turn off)" );

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}


//No Spread
NoSpread()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self.NoSpread = !return_toggle( self.NoSpread );

        self endon("disconnect");

	    if( level.NoSpread == false )
	    {

            level.NoSpread = true;
            self maps\mp\_utility::giveperk( "specialty_bulletaccuracy", false );
            setdvar( "perk_weapSpreadMultiplier","0.0001" );
            self iPrintln( "^:No Spread: ^7[^2On^7]" );

	    }
	    else
	    {

            level.NoSpread = false;
            setdvar( "perk_weapSpreadMultiplier","0.65" );
            self iPrintln( "^:No Spread: ^7[^1Off^7]" );

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}


//Wallbang All
wallbang_all()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self.wallbang_all = !return_toggle( self.wallbang_all );

        self endon("disconnect");

	    if( level.wallbangs == false )
	    {

		    setdvar( "bg_surfacePenetration", 9999 );
		    setdvar( "perk_bulletPenetrationMultiplier", 30 );
    	    setdvar( "perk_armorPiercing", 9999 );
            self maps\mp\_utility::giveperk( "specialty_armorpiercing", false );
            self maps\mp\_utility::giveperk( "specialty_stopping_power", false );
            self maps\mp\_utility::giveperk( "specialty_bulletdamage", false );
		    self iPrintln( "^:Wallbang All: ^7[^2On^7]" );
		    level.wallbangs = true;

	    }
	    else
	    {

		    setdvar( "bg_surfacePenetration", 0 );
		    setdvar( "perk_bulletPenetrationMultiplier", 2 );
    	    setdvar( "perk_armorPiercing", 40 );
		    self iPrintln( "^:Wallbang All: ^7[^1Off^7]" );
		    level.wallbangs = false;

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}


//Earthquake Rounds
QuakeRounds()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self.QuakeRounds = !return_toggle( self.QuakeRounds );

        self endon("disconnect");

	    if( level.QuakeRounds == false )
	    {

            level.QuakeRounds = true;
            self iPrintln( "^:Earthquake Rounds: ^7[^2On^7]" );

		    self endon( "endQuakeRounds" );
		    for(;;)
		    {

			    self waittill( "weapon_fired" );
			    earthquake( .5, 1, self.origin, 90 );
			    radiusDamage( 150, 300, 100, self );
			    earthquake( 1.5, 1, 90 );

		    }

	    }
	    else
	    {

		    self notify( "endQuakeRounds" );
            level.QuakeRounds = false;
            self iPrintln( "^:Earthquake Rounds: ^7[^1Off^7]" );

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}


//Bullet Ricochet Toggle
bulletricochet() 
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self.bulletricochet = !return_toggle( self.bulletricochet );

        self endon("disconnect");

        if( level.bulletricochet == false )
	    {

            self endon("endRicochet");
            level.bulletricochet = true;
            self iPrintln( "^:Bullet Ricochet: ^7[^2On^7]" );

		    for(;;)
            {

                self waittill( "weapon_fired" ); 
                self thread reflectbullet( 30, self getcurrentweapon() );

            }

	    }
	    else
	    {

		    self notify( "endRicochet" );
            level.bulletricochet = false;
            self iPrintln( "^:Bullet Ricochet: ^7[^1Off^7]" );

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}
 
reflectbullet( times, weapon ) 
{

        incident = anglestoforward( self getplayerangles() ); 
        trace = bullettrace( self geteye(), self geteye() + incident * 100000, 0, self ); 
        reflection = incident - ( 2 * trace[ "normal" ] * vectordot( incident, trace[ "normal" ] ) ); 
        magicbullet( weapon, trace[ "position" ], trace[ "position" ] + ( reflection * 100000 ) ); 
        wait 0.05;
        for( i = 0; i < times - 1; i++ ) 
        {

                trace = bullettrace( trace["position"], trace["position"] + ( reflection * 100000 ), 0, self ); 
                incident = reflection; 
                reflection = incident - ( 2 * trace[ "normal" ] * vectordot( incident, trace[ "normal" ] ) ); 
                magicbullet( weapon, trace[ "position" ], trace[ "position" ] + ( reflection * 100000 ) ); 
                wait 0.05;

        }

}


//Weapon Projectile (Definitely a better way to do this)
weapon_projectile( projectile )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self endon("disconnect");

        if( projectile != "Default" && level.custom_proj == false )
	    {

            self iPrintln( "^:Custom Projectile Set: " + projectile );
            self endon( "disconnect" );
            self endon( "defaultproj" );
            self endon( "newproj" );
            self notify( "newproj2" );
            level.custom_proj = true;
            for(;;)
            {

                self waittill( "weapon_fired" );
                forward = self getTagOrigin("j_head");
		        end = self thread vector_Scal(anglestoforward(self getPlayerAngles()),1000000);
		        location = BulletTrace( forward, end, 0, self )[ "position" ];
                MagicBullet( projectile, self getTagOrigin("tag_eye"), location, self );

            }

	    }
	    else if( projectile != "Default" && level.custom_proj == true )
	    {
        
            self notify( "newproj" );
            self endon( "defaultproj" );
            self endon( "newproj2" );
            self iPrintln( "^:Custom Projectile Set: " + projectile );
            level.custom_proj = false;
            for(;;)
            {

                self waittill( "weapon_fired" );
                forward = self getTagOrigin("j_head");
		        end = self thread vector_Scal(anglestoforward(self getPlayerAngles()),1000000);
		        location = BulletTrace( forward, end, 0, self )[ "position" ];
                MagicBullet( projectile, self getTagOrigin("tag_eye"), location, self );

            }

	    }
        else
        {

            self notify( "defaultproj" );
            self iPrintln( "^:Custom Projectile: ^7[^1Off^7]" );

        }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}


//Explosive Rounds
ExplosiveRounds()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self.ExplosiveRounds = !return_toggle( self.ExplosiveRounds );

        self endon("disconnect");

	    if( level.ExplosiveRounds == false )
	    {

            self endon( "ExplosiveRoundsEnd" );
            level.ExplosiveRounds = true;
            self iPrintln( "^:Explosive Rounds: ^7[^2On^7]" );

            for(;;)
            {
        
                self waittill ( "weapon_fired" );
                forward = self getTagOrigin( "j_head" );
                end = self thread vector_scal( anglestoforward ( self getPlayerAngles() ), 1000000 );
                SPLOSIONlocation = BulletTrace( forward, end, 0, self )[ "position" ];
                self playsound( "h1_wpn_rpg_exp_default" );
                playfx( level._effect[ "vfx/explosion/frag_grenade_default" ], SPLOSIONlocation );
                RadiusDamage( SPLOSIONlocation, 180, 180, 180, self );

            }

	    }
	    else
	    {

            level.ExplosiveRounds = false;
            self notify( "ExplosiveRoundsEnd" );
            self iPrintln( "^:Explosive Rounds: ^7[^1Off^7]" );

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}


//Shotgun Rounds
ShotgunRounds()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self.ShotgunRounds = !return_toggle( self.ShotgunRounds );

        self endon("disconnect");

	    if( level.ShotgunRounds == false )
	    {

		    self endon("ShotgunRoundsEnd");
            level.ShotgunRounds = true;
            self iPrintln( "^:Shotgun Rounds: ^7[^2On^7]" );

            for(;;)
            {

                self waittill( "weapon_fired" );
                MagicBullet( "h2_spas12_mp", self getEye(), self traceBullet(), self );
                MagicBullet( "h2_spas12_mp", self getEye(), self traceBullet(), self );
                MagicBullet( "h2_spas12_mp", self getEye(), self traceBullet(), self );

            }

	    }
	    else
	    {

            self notify("ShotgunRoundsEnd");
            level.ShotgunRounds = false;
            self iPrintln( "^:Shotgun Rounds: ^7[^1Off^7]" );

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}


//Weapon Reticle
weapon_reticle()
{

	//todo

}

////////////////////////////////////////////////////////////////////////////////////////
//Attachments
////////////////////////////////////////////////////////////////////////////////////////

give_attachment( attachment )
{

	weapon = self getCurrentWeapon();
	weaponbase = self getbaseweaponname( weapon );
	newWeapon = weaponbase + "_mp_" + attachment;
	self giveWeapon( newWeapon );
	self takeWeapon( weapon );
	self switchToWeapon( newWeapon );
	self iprintln( "^:" + newWeapon + " added" );

}

attach_combo()
{

	if(level.Attach1 == "" && level.Attach2 == "")
	{

		weapon = self getCurrentWeapon();
		weaponbase = self getbaseweaponname( weapon );
		newWeapon = weaponbase + "_mp";

		if( newWeapon == weapon )
		{

			self giveWeapon( newWeapon );
			self switchToWeapon( newWeapon );
			self iprintln( newWeapon + " added" );

		}
		else
		{

			self giveWeapon( newWeapon );
			self takeWeapon( weapon );
			self switchToWeapon( newWeapon );
			self iprintln( newWeapon + " added" );

		}

	}
	else if( level.Attach1 == "" && level.Attach2 != "" )
	{

		weapon = self getCurrentWeapon();
		weaponbase = self getbaseweaponname( weapon );
		newWeapon = weaponbase + "_mp_" + level.Attach2;

		if( newWeapon == weapon )
		{

			self giveWeapon( newWeapon );
			self switchToWeapon( newWeapon );
			self iprintln( newWeapon + " added" );

		}
		else
		{

			self giveWeapon( newWeapon );
			self takeWeapon( weapon );
			self switchToWeapon( newWeapon );
			self iprintln( newWeapon + " added" );

		}

	}
	else if( level.Attach1 != "" && level.Attach2 == "" )
	{

		weapon = self getCurrentWeapon();
		weaponbase = self getbaseweaponname( weapon );
		newWeapon = weaponbase + "_mp_" + level.Attach1;

		if( newWeapon == weapon )
		{

			self giveWeapon( newWeapon );
			self switchToWeapon( newWeapon );
			self iprintln( newWeapon + " added" );

		}
		else
		{

			self giveWeapon( newWeapon );
			self takeWeapon( weapon );
			self switchToWeapon( newWeapon );
			self iprintln( newWeapon + " added" );

		}

	}
	else if( level.Attach1 != "" && level.Attach2 != "" )
	{

		weapon = self getCurrentWeapon();
		weaponbase = self getbaseweaponname( weapon );
		newWeapon = weaponbase + "_mp_" + level.Attach1 + "_" + level.Attach2;

		if( newWeapon == weapon )
		{

			self giveWeapon( newWeapon );
			self switchToWeapon( newWeapon );
			self iprintln( newWeapon + " added" );

		}
		else
		{

			self giveWeapon( newWeapon );
			self takeWeapon( weapon );
			self switchToWeapon( newWeapon );
			self iprintln( "^:" + newWeapon + " added" );

		}
	
	}

}

set_attach1( attachment1 )
{

	level.Attach1 = ( attachment1 );
	self iprintln( "^:Attachment 1 set: " + attachment1 );

}

set_attach2( attachment2 )
{

	level.Attach2 = ( attachment2 );
	self iprintln( "^:Attachment 2 set: " + attachment2 );

}

////////////////////////////////////////////////////////////////////////////////////////
//Switch Camo
////////////////////////////////////////////////////////////////////////////////////////

switch_camo( camo )
{

	weapon = self getCurrentWeapon();
	weaponbase = self getbaseweaponname( weapon );

	if(level.Attach1 == "" && level.Attach2 == "")
	{

		newWeapon = weaponbase + "_mp_" + camo;
		self giveWeapon( newWeapon );
		self takeWeapon( weapon );
		self switchToWeapon( newWeapon );
		self iprintln( "^:Camo Set: " + camo );

	}
	else if(level.Attach1 == "" && level.Attach2 != "")
	{

		newWeapon = weaponbase + "_mp_" + level.Attach2 + "_" + camo;
		self giveWeapon( newWeapon );
		self takeWeapon( weapon );
		self switchToWeapon( newWeapon );
		self iprintln( "^:Camo Set: " + camo );

	}
	else if(level.Attach1 != "" && level.Attach2 == "")
	{

		newWeapon = weaponbase + "_mp_" + level.Attach1 + "_" + camo;
		self giveWeapon( newWeapon );
		self takeWeapon( weapon );
		self switchToWeapon( newWeapon );
		self iprintln( "^:Camo Set: " + camo );

	}
	else if(level.Attach1 != "" && level.Attach2 != "")
	{

		newWeapon = weaponbase + "_mp_" + level.Attach1 + "_" + level.Attach2 + "_" + camo;
		self giveWeapon( newWeapon );
		self takeWeapon( weapon );
		self switchToWeapon( newWeapon );
		self iprintln( "^:Camo Set: " + camo );

	}

}



////////////////////////////////////////////////////////////////////////////////////////
//Scripted Weapons
////////////////////////////////////////////////////////////////////////////////////////

//Mustang and Sally
mustang_sally() 
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self endon( "death" );
        self iPrintln( "^:Mustang and Sally added!" );
	    self giveWeapon( "h2_colt45_mp_akimbo_xmagmwr_camo036" );
	    self switchToWeapon( "h2_colt45_mp_akimbo_xmagmwr_camo036" );
	    for(;;)
	    {

		    self waittill( "weapon_fired" );
		    if( self getCurrentWeapon() == "h2_colt45_mp_akimbo_xmagmwr_camo036" )
		    {

                forward = self getTagOrigin( "tag_eye" );
                end = self thread vector_scal( anglestoforward( self getPlayerAngles()), 1000000 );
                location = BulletTrace( forward, end, 0, self )[ "position" ];
                MagicBullet( "h2_m79_mp", forward, location, self );

		    }

		    wait 0.001;

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}


//Death Machine 1
Dmac()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self endon( "disconnect" );
        self iprintlnBold( "^1Death Machine Ready." );
        self attach( "weapon_minigun", "tag_weapon_left", false );
        self giveWeapon( "defaultweapon_mp" );
        self switchToWeapon( "defaultweapon_mp" );
        self.bullets = 998;
        self.notshown = false;
        self.ammoDeathMachine = spawnstruct();
        self.ammoDeathMachine = self createFontString( "default", 2.0 );
        self.ammoDeathMachine setPoint( "TOPRIGHT", "TOPRIGHT", -20, 40 );
        for (;;) 
        {

            if ( self AttackButtonPressed() && self getCurrentWeapon() == "defaultweapon_mp" ) 
            {

                self.notshown = false;
                self allowADS( false );
                self.bullets--;
                self.ammoDeathMachine setValue( self.bullets );
                self.ammoDeathMachine.color = ( 0, 1, 0 );
                tagorigin = self getTagOrigin( "tag_weapon_left" );
                firing = xoxd();
                x = randomIntRange( -50, 50 );
                y = randomIntRange( -50, 50 );
                z = randomIntRange( -50, 50 );
                MagicBullet( "ac130_25mm_mp", tagorigin, firing + ( x, y, z ), self );
                self setWeaponAmmoClip( "defaultweapon_mp", 100, "left" );
                self setWeaponAmmoClip( "defaultweapon_mp", 100, "right" );

            } 
            else 
            {

                if ( self.notshown == false ) 
                {

                    self.ammoDeathMachine setText(" ");
                    self.notshown = true;

                }

                self allowADS( true );

            }
            if ( self.bullets == 0 ) 
            {
                self takeWeapon( "defaultweapon_mp" );
                self.ammoDeathMachine destroy();
                self allowADS( true );
                break;
            }
            if ( !isAlive( self ) ) 
            {
                self.ammoDeathMachine destroy();
                self allowADS( true );
                break;
            }

            wait 0.07;

        }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}


//Teleport Gun
TeleportGun()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self endon( "death" );
        self iPrintln( "^:Teleport Gun added!" );
	    self giveWeapon( "h2_m40a3_mp_ogscope_xmagmwr_camo025" );
	    self switchToWeapon( "h2_m40a3_mp_ogscope_xmagmwr_camo025" );
	    for(;;)
	    {

		    self waittill( "weapon_fired" );
		    if( self getCurrentWeapon() == "h2_m40a3_mp_ogscope_xmagmwr_camo025" )
		    {

                vec2 = anglestoforward( self getPlayerAngles() );
			    e1nd = ( vec2[ 0 ] * 200000, vec2[ 1 ] * 200000, vec2[ 2 ] * 200000 );
			    BulletLocation = BulletTrace( self gettagorigin( "tag_eye" ), self gettagorigin( "tag_eye" ) + e1nd, 0, self )[ "position" ];
                self SetOrigin( BulletLocation );

		    }

		    wait 0.001;

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}


//Care Package Gun
Care_Gun()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self endon( "death" );
	    self iPrintln("^:Care Package gun added!");
	    self giveWeapon( "h2_m40a3_mp_silencerlmg_xmagmwr_camo033" );
	    self SwitchToWeapon( "h2_m40a3_mp_silencerlmg_xmagmwr_camo033" );
	    for(;;)
	    {

		    self waittill( "weapon_fired" );
		    if( self getCurrentWeapon()=="h2_m40a3_mp_silencerlmg_xmagmwr_camo033" )
		    {
			    dropCrate = maps\mp\h2_killstreaks\_airdrop::createAirDropCrate( self.owner, "airdrop_marker_mp", maps\mp\h2_killstreaks\_airdrop::getCrateTypeForDropType("airdrop_marker_mp"), self geteye() + anglestoforward( self getplayerangles() ) * 70 );
			    dropCrate.angles = self getplayerangles();
			    dropCrate PhysicsLaunchServer( ( 0, 0, 0 ), anglestoforward( self getplayerangles() ) * 1000 );
			    dropCrate thread maps\mp\h2_killstreaks\_airdrop::physicsWaiter( "airdrop_marker_mp", maps\mp\h2_killstreaks\_airdrop::getCrateTypeForDropType( "airdrop_marker_mp" ) );
		    }

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}


//Nuke AT4
nukeAT4()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self endon ( "disconnect" );
        self endon ( "death" );
        self iPrintln( "^:Nuke AT4 added" );
        self giveWeapon( "at4_mp" );
        self switchToWeapon( "at4_mp" );
        for(;;)
        {

            self waittill ( "weapon_fired" );
            if ( self getCurrentWeapon() == "at4_mp" )
            {

                if ( level.teambased ) thread teamPlayerCardSplash( "used_nuke", self, self.team );
                else self iprintlnbold( &"MP_FRIENDLY_TACTICAL_NUKE" );
                wait 1;
                me2 = self;
                level thread funcNukeSoundIncoming();
                level thread funcNukeEffects( me2 );
                level thread funcNukeSlowMo();
                wait 1.5;
                foreach( player in level.players )
                {

                    if ( player.name != me2.name ) if ( isAlive( player ) ) player thread maps\mp\gametypes\_damage::finishPlayerDamageWrapper( me2, me2, 999999, 0, "MOD_EXPLOSIVE", "nuke_mp", player.origin, player.origin, "none", 0, 0 );

                }
                wait .1;
                level notify ( "done_nuke2" );
                self suicide();

            }

        }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

funcNukeSlowMo()
{

    level endon ( "done_nuke2" );
    setSlowMotion( 1.0, 0.25, 0.5 );

}

funcNukeEffects( me2 )
{

    level endon ( "done_nuke2" );
    foreach( player in level.players )
    {

        player thread FixSlowMo(player);
        playerForward = anglestoforward( player.angles );
        playerForward = ( playerForward[0], playerForward[1], 0 );
        playerForward = VectorNormalize( playerForward );
        nukeDistance = 100;
        nukeEnt = Spawn( "script_model", player.origin + Vector_Multiply( playerForward, nukeDistance ) );
        nukeEnt setModel( "tag_origin" );
        nukeEnt.angles = ( 0, ( player.angles[1] + 180), 90 );
        nukeEnt thread funcNukeEffect( player );
        player.nuked = true;

    }

}

FixSlowMo( player )
{

    player endon("disconnect");
    player waittill("death");
    setSlowMotion( 0.25, 1, 2.0 );

}
funcNukeEffect( player )
{

    player endon( "death" );
    waitframe();
    PlayFXOnTagForClients( level._effect[ "nuke_flash" ], self, "tag_origin", player );

}
funcNukeSoundIncoming()
{

    level endon ( "done_nuke2" );
    foreach( player in level.players )
    {

        player playlocalsound( "nuke_incoming" );
        player playlocalsound( "nuke_explosion" );
        player playlocalsound( "nuke_wave" );

    }

}


//Mounted Turret
mounted_turret()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        mounted_turret = spawnTurret( "misc_turret", self.origin, "pavelow_minigun_mp" );
        mounted_turret setModel( "weapon_minigun" );
        mounted_turret.owner = self.owner;
        mounted_turret.team = self.team;
        mounted_turret SetBottomArc( 360 );
        mounted_turret SetTopArc( 360 );
        mounted_turret SetLeftArc( 360 );
        mounted_turret SetRightArc( 360 );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}


//Nova Gas
NovaGas()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self endon( "disconnect" );
	    cur = self getCurrentWeapon();
	    wait 0.1;
	    self giveweapon( "h1_smokegrenade_mp" );
	    self SwitchToWeapon( "h1_smokegrenade_mp" );
	    self waittill( "grenade_fire",grenade );
	    if( self getCurrentWeapon() == "h1_smokegrenade_mp" )
	    {

		    nova=spawn( "script_model", grenade.origin );
		    nova setModel( "wpn_h1_grenade_smoke_proj" );
		    nova Linkto( grenade );
		    wait 1;
		    self switchToWeapon( cur );
		    for( i=0; i <= 10; i++ )
		    {

			    RadiusDamage(nova.origin,300,100,50,self);
			    wait 1;

		    }

		    nova delete();

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}


//Grappling Gun (By StonedYoda)
Grappling_Gun() 
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self endon( "death" );
        self iPrintln( "^:Grappling Gun added!" );
	    self giveWeapon( "h2_usp_mp_silencersmg_xmagmwr_camo027" );
	    self switchToWeapon( "h2_usp_mp_silencersmg_xmagmwr_camo027" );
	    for(;;)
	    {

		    self waittill( "weapon_fired" );
		    if( self getCurrentWeapon() == "h2_usp_mp_silencersmg_xmagmwr_camo027" )
		    {

                endLocSY = traceBullet();
                self.grappler = spawn( "script_model", self.origin );
                self playerlinkto( self.grappler, undefined );
                self.grappler moveTo( endLocSY, 1 );
                wait 1.02;
                self unlink();
                self.grappler delete();

		    }

		    wait 0.01;

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

////////////////////////////////////////////////////////////////////////////////////////
//Scripted Killstreaks
////////////////////////////////////////////////////////////////////////////////////////

//Suicide Plane
Suicide_Plane()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self endon( "disconnect" );
	    self endon( "death" );

	    Location = locationSelector();

	    self iPrintln( "^:Suicide Plane Inbound!" );

	    SuicidePlane = spawn( "script_model", self.origin + ( 24000, 15000, 25000 ) );
	    SuicidePlane setModel( "vehicle_ac130_low_mp" );
	    Angles = vectorToAngles( Location - ( self.origin + ( 8000, 5000, 10000 ) ) );
	    SuicidePlane.angles = Angles;
	    SuicidePlane moveto( Location, 3.5 );

	    SuicidePlane playsound( "veh_b2_close_loop" );

	    playFxOnTag( level.chopper_fx[ "damage" ][ "light_smoke" ], SuicidePlane, "tag_origin" );
	    wait 3.6;
	    playFX(level.chopper_fx["explode"]["large"], SuicidePlane.origin);
	    playFX(level.chopper_fx["explode"]["large"], SuicidePlane.origin+( 400, 0, 0 ));
	    playFX(level.chopper_fx["explode"]["large"], SuicidePlane.origin+( 0, 400, 0 ));
	    playFX(level.chopper_fx["explode"]["large"], SuicidePlane.origin+( 400, 400, 0 ));
	    playFX(level.chopper_fx["explode"]["large"], SuicidePlane.origin+( 0, 0, 400 ));
	    playFX(level.chopper_fx["explode"]["large"], SuicidePlane.origin-( 400, 0, 0 ));
	    playFX(level.chopper_fx["explode"]["large"], SuicidePlane.origin-( 0, 400, 0 ));
	    playFX(level.chopper_fx["explode"]["large"], SuicidePlane.origin-( 400, 400, 0 ));
	    playFX(level.chopper_fx["explode"]["large"], SuicidePlane.origin+( 0, 0, 800 ));
	    playFX(level.chopper_fx["explode"]["large"], SuicidePlane.origin+( 200, 0, 0 ));
	    playFX(level.chopper_fx["explode"]["large"], SuicidePlane.origin+( 0, 200, 0 ));
	    playFX(level.chopper_fx["explode"]["large"], SuicidePlane.origin+( 200, 200, 0 ));
	    playFX(level.chopper_fx["explode"]["large"], SuicidePlane.origin+( 0, 0, 200 ));
	    playFX(level.chopper_fx["explode"]["large"], SuicidePlane.origin-( 200, 0, 0 ));
	    playFX(level.chopper_fx["explode"]["large"], SuicidePlane.origin-( 0, 200, 0 ));
	    playFX(level.chopper_fx["explode"]["large"], SuicidePlane.origin-( 200, 200, 0 ));
	    playFX(level.chopper_fx["explode"]["large"], SuicidePlane.origin+( 0, 0, 200 ));
        playFX( level._effect[ "vfx/explosion/mp_gametype_bomb" ], SuicidePlane.origin + ( 0, 0, 0 ) );
	    SuicidePlane playsound( level.heli_sound[ "crash" ] );
        SuicidePlane playsound( "nuke_explosion" );
	    self RadiusDamage( SuicidePlane.origin, 4000, 4000, 100, self );

	    SuicidePlane delete();
	    Earthquake( 0.4, 4, SuicidePlane.origin, 800 );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}


//Rocket Barrage (Automatic Rockets by StonedYoda)
Rocket_Barrage()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        level.killed_stoners = 0;
        self S( "^:Rocket Barrage ^2Launched" );
        level.mapCenter = maps\mp\gametypes\_spawnlogic::findBoxCenter( level.spawnMins, level.spawnMaxs );
        foreach( player in level.players )
        {

            if( isAlive( player ) && player != hostPlayer() )
            {

                level.killed_stoners += 1;
                MagicBullet( "remotemissile_projectile_mp", level.mapCenter + ( 0, 0, 4000 ), player getTagOrigin( "j_spineupper" ), self );

            }

        }

        if( level.killed_stoners > 0 )
            self S( "Rocket Barrage Targeted ^1" + level.killed_stoners + "^7 enemies!" );

        if( level.killed_stoners <= 0 )
            self S( "^1Error^7: No enemies found!" );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}


//Plane Collision
plane_collision()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self endon("disconnect");
        self endon("death");
        self endon("PilotsCrashed");
        ElectricHaze = spawn("script_model",self.origin+(18000,0,2400));
        ElectricHaze2 = spawn("script_model",self.origin+(-18000,0,2400));
        ElectricHaze setModel("vehicle_ac130_low_mp");
        ElectricHaze2 setModel("vehicle_ac130_low_mp");
        ElectricHaze MoveTo(self.origin+(0,0,2400),5);
        ElectricHaze2 MoveTo(self.origin+(0,0,2400),5);
        ElectricHaze.angles=(0,180,0);
        ElectricHaze2.angles=(0,0,0);
        playFxOnTag( level.chopper_fx[ "damage" ][ "light_smoke" ], ElectricHaze, "tag_origin" );
        playFxOnTag( level.chopper_fx[ "damage" ][ "light_smoke" ], ElectricHaze2, "tag_origin" );
        wait 5;
        PlayFX(level._effect[ "aerial_explosion_large" ],ElectricHaze.origin);
	    playFX(level.chopper_fx["explode"]["large"], ElectricHaze.origin);
	    playFX(level.chopper_fx["explode"]["large"], ElectricHaze.origin+( 400, 0, 0 ));
	    playFX(level.chopper_fx["explode"]["large"], ElectricHaze.origin+( 0, 400, 0 ));
	    playFX(level.chopper_fx["explode"]["large"], ElectricHaze.origin+( 400, 400, 0 ));
	    playFX(level.chopper_fx["explode"]["large"], ElectricHaze.origin+( 0, 0, 400 ));
	    playFX(level.chopper_fx["explode"]["large"], ElectricHaze.origin-( 400, 0, 0 ));
	    playFX(level.chopper_fx["explode"]["large"], ElectricHaze.origin-( 0, 400, 0 ));
	    playFX(level.chopper_fx["explode"]["large"], ElectricHaze.origin-( 400, 400, 0 ));
	    playFX(level.chopper_fx["explode"]["large"], ElectricHaze.origin+( 0, 0, 800 ));
	    playFX(level.chopper_fx["explode"]["large"], ElectricHaze.origin+( 200, 0, 0 ));
	    playFX(level.chopper_fx["explode"]["large"], ElectricHaze.origin+( 0, 200, 0 ));
	    playFX(level.chopper_fx["explode"]["large"], ElectricHaze.origin+( 200, 200, 0 ));
	    playFX(level.chopper_fx["explode"]["large"], ElectricHaze.origin+( 0, 0, 200 ));
	    playFX(level.chopper_fx["explode"]["large"], ElectricHaze.origin-( 200, 0, 0 ));
	    playFX(level.chopper_fx["explode"]["large"], ElectricHaze.origin-( 0, 200, 0 ));
	    playFX(level.chopper_fx["explode"]["large"], ElectricHaze.origin-( 200, 200, 0 ));
	    playFX(level.chopper_fx["explode"]["large"], ElectricHaze.origin+( 0, 0, 200 ));
	    ElectricHaze playsound( level.heli_sound[ "crash" ] );
        ElectricHaze playsound( "nuke_explosion" );
        _visionsetnaked( "coup_sunblind", 0.1 );
	    PlayFX(level._effect[ "nuke_flash" ]);
	    wait ( 0.1 );
	    _visionsetnaked( "coup_sunblind", 0 );
	    _visionsetnaked( "", 3.0 );
        self thread PilotCrashFX();
        ElectricHaze delete();
        ElectricHaze2 delete();

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

PilotCrashFX()
{

    self endon( "disconnect" );
    self endon( "death" );
    earthquake( 0.6, 4, self.origin, 100000 );
    foreach( player in level.players )
    {

        player playlocalsound( "nuke_explosion" );
        player playlocalsound( "nuke_wave" );

    }

}


//Jetpack Toggle
Jetpack()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self.Jetpack = !return_toggle( self.Jetpack );

	    if( level.Jetpack == false )
	    {

            level.Jetpack = true;

            self endon( "death" );
            self endon( "jetpack_off" );

            self.fuel = 200;

            self iPrintln( "^:Jetpack: ^7[^2On^7]" );

	    	self attach( "projectile_hellfire_missile", "tag_stowed_back" );
            for( i=0 ;; i++ )
            {

                if( self usebuttonpressed() && self.fuel > 0 )
                {

                    self playsound( "boost_jump_plr_mp" );
                    playFX( level._effect[ "fire_smoke_trail_l" ], self getTagOrigin( "J_Ankle_RI" ) );
                    playFx( level._effect[ "fire_smoke_trail_l" ], self getTagOrigin( "J_Ankle_LE" ) );
                    earthquake( .15, .2, self gettagorigin( "j_spine4" ), 50 );
                    self.fuel--;
                    if( self getvelocity() [2] < 300 ) 
                        self setvelocity( self getvelocity() + ( 0, 0, 60 ) );

                }

                if( self.fuel < 200 && !self usebuttonpressed() ) self.fuel++;
                wait .05;

            }

	    }
	    else
	    {

		    self notify( "jetpack_off" );
            level.Jetpack = false;
            self iPrintln( "^:Jetpack: ^7[^1Off^7]" );

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}


//Mega Airdrop 1
MegaAirdropRemade()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self iPrintln( "^:Mega Airdrop Inbound!" );

        planeHalfDistance = 24000;
        planeFlySpeed     = 3500;
        yaw               = vectorToYaw( self.origin );
        direction         = ( 0, yaw, 0 );
        flyHeight         = self maps\mp\h2_killstreaks\_airdrop::getFlyHeightOffset( self.origin );
        pathStart         = self.origin + vector_multiply( AnglesToForward( direction ), -1 * planeHalfDistance );
        pathStart         = pathStart * ( 1, 1, 0 ) + ( 0, 0, flyHeight );
        pathEnd           = self.origin + vector_multiply( AnglesToForward( direction ), planeHalfDistance );
        pathEnd           = pathEnd * ( 1, 1, 0 ) + ( 0, 0, flyHeight );
        d                 = length( pathStart - pathEnd );
        flyTime           = ( d / planeFlySpeed );
        c130              = maps\mp\h2_killstreaks\_airdrop::c130Setup( self, pathStart, pathEnd );
        c130.dropType     = "airdrop_marker_mp";
        c130 PlayLoopSound( "veh_ac130_dist_loop" );
        c130.angles = direction;
        forward     = AnglesToForward( direction );
        c130 MoveTo( pathEnd, flyTime, 0, 0 );
        minDist    = Distance2D( c130.origin, self.origin );
        boomPlayed = false;

        for(;;)
        {

            dist = Distance2D( c130.origin, self.origin );
            if( dist < minDist )
                minDist = dist;
            else if( dist > minDist )
                break;

            if( dist < 256 )
                break;
            else if( dist < 768 )
            {

                Earthquake( 0.15, 1.5, self.origin, 1500 );
                if( !boomPlayed )
                {

                    c130 PlaySound( "veh_ac130_sonic_boom" );
                    boomPlayed = true;

                }

            }

            wait .05;

        }

        for( a=0; a<15; a++ )
        {

            c130 notify( "drop_crate" );
            c130 thread maps\mp\h2_killstreaks\_airdrop::dropTheCrate( self.origin, "airdrop_marker_mp", flyHeight, false, undefined, pathStart );
            wait .025;

        }

        wait 7;
        c130 delete();

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}


//Mega Airdrop 2
MegaAirdrop()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self thread C( "^:Mega Airdrop Incoming...", 5, ( 0, 1, 1 ) );
        wait 5;
        self thread m();

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

m()
{

    self endon( "death" );
    self endon( "disconnect" );
    thread teamPlayerCardSplash( "used_airdrop_mega", self );
    o = self;
    sn = level.heli_start_nodes[ randomInt( level.heli_start_nodes.size ) ];
    hO = sn.origin;
    hA = sn.angles;
    lb = spawnHelicopter( o, hO, hA, "cobra_mp", "vehicle_ac130_low_mp" );
    if ( !isDefined( lb ) ) return;
    lb maps\mp\_helicopter::addToHeliList();
    lb.zOffset = ( 0, 0, lb getTagOrigin( "tag_origin" )[2] - lb getTagOrigin( "tag_ground" )[ 2 ] );
    lb.team = o.team;
    lb.attacker = undefined;
    lb.lifeId = 0;
    lb.currentstate = "ok";
    lN = level.heli_loop_nodes[ randomInt( level.heli_loop_nodes.size ) ];
    lb maps\mp\_helicopter::heli_fly_simple_path( sn );
    lb thread DCP( lb );
    lb thread maps\mp\_helicopter::heli_fly_loop_path( lN );
    lb thread lu( 20 );

}

DCP(lb)
{

    self endon("leaving");
    for (;;)
    {

        w( 0.1 );
        dC = maps\mp\h2_killstreaks\_airdrop::createAirDropCrate( self.owner, "airdrop_marker_mp", maps\mp\h2_killstreaks\_airdrop::getCrateTypeForDropType("airdrop_marker_mp"), lb.origin );
        dC.angles = lb.angles;
        dC PhysicsLaunchServer( ( 0, 0, 0 ), anglestoforward( lb.angles ) * 1 );
        dC thread maps\mp\h2_killstreaks\_airdrop::physicsWaiter( "airdrop_marker_mp", maps\mp\h2_killstreaks\_airdrop::getCrateTypeForDropType( "airdrop_marker_mp" ) );
        w( 0.1 );

    }

}

lu(T)
{

    self endon( "death" );
    self endon( "helicopter_done" );
    maps\mp\gametypes\_hostmigration::waitLongDurationWithHostMigrationPause( T );
    self thread ae();

}

ae()
{

    self notify( "leaving" );
    lN = level.heli_leave_nodes[ randomInt( level.heli_leave_nodes.size ) ];
    self maps\mp\_helicopter::heli_reset();
    self Vehicle_SetSpeed( 100, 45 );
    self setvehgoalpos( lN.origin, 1 );
    self waittillmatch( "goal" );
    self notify( "death" );
    w( .05 );
    self delete();

}

C(l, m, c)
{

    self endon( "std" );
    P = createServerFontString( "hudbig", 1.2 );
    P setPoint( "CENTER", "CENTER", 0, -40 );
    P.sort = 1001;
    P.color = ( c );
    P iPrintlnBold( l );
    P.foreground = false;
    P1 = createServerFontString( "hudbig", 1.4 );
    P1 setPoint( "CENTER", "CENTER", 0, 0 );
    P1.sort = 1001;
    P1.color = ( c );
    P1.foreground = false;
    P1 setTimer( m );
    self thread K( m, P, P1 );
    P1 maps\mp\gametypes\_hud::fontPulseInit();
    while ( 1 )
    {

        self playSound( "ui_mp_nukebomb_timer" );
        w( 1 );

    }

}

K(m, a, b)
{

    wait( m );
    self notify( "std" );
    a destroy();
    b destroy();

}

w( V )
{

    wait( V );

}


//Super AC-130
SuperAC130()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self iPrintln( "^:Super AC-130 Inbound!" );

        owner = self;
        startNode = level.heli_start_nodes[ randomInt( level.heli_start_nodes.size ) ];
        heliOrigin = startnode.origin;
        heliAngles = startnode.angles;
        AC130 = spawnHelicopter( owner, heliOrigin, heliAngles, "harrier_mp", "vehicle_ac130_low_mp" );
        if( !isDefined( AC130 ) )return;
        AC130 playLoopSound( "veh_b2_dist_loop" );
        AC130 maps\mp\_helicopter::addToHeliList();
        AC130.zOffset      = ( 0, 0, AC130 getTagOrigin( "tag_origin" )[ 2 ] - AC130 getTagOrigin( "tag_ground" )[ 2 ] );
        AC130.team         = owner.team;
        AC130.attacker     = undefined;
        AC130.lifeId       = 0;
        AC130.currentstate = "ok";
        AC130 thread maps\mp\_helicopter::heli_leave_on_disconnect( owner );
        AC130 thread maps\mp\_helicopter::heli_leave_on_changeTeams( owner );
        AC130 thread maps\mp\_helicopter::heli_leave_on_gameended( owner );
        AC130 endon( "helicopter_done" );
        AC130 endon( "crashing" );
        AC130 endon( "leaving" );
        AC130 endon( "death" );
        attackAreas = getEntArray( "heli_attack_area", "targetname" );
        loopNode = level.heli_loop_nodes[ randomInt( level.heli_loop_nodes.size ) ];
        AC130 maps\mp\_helicopter::heli_fly_simple_path( startNode );
        AC130 thread leave_on_timeou( 100 );
        AC130 thread maps\mp\_helicopter::heli_fly_loop_path( loopNode );
        AC130 thread DropDaBomb( owner );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}
DropDaBomb( owner )
{
    self endon( "death" );
    self endon( "helicopter_done" );
    level endon( "game_ended" );
    self endon( "crashing" );
    self endon( "leaving" );
    waittime=5;
    for(;;)
    {
        wait( waittime );
        AimedPlayer = undefined;
        foreach( player in level.players )
        {
            if( ( player == owner ) || ( !isAlive( player ) ) || ( level.teamBased && owner.pers[ "team" ] == player.pers[ "team" ] ) || ( !bulletTracePassed( self getTagOrigin( "tag_origin" ), player getTagOrigin( "back_mid" ), 0, self ) ) )continue;
            if( isDefined( AimedPlayer ) )
            {
                if( closer( self getTagOrigin( "tag_origin" ),player getTagOrigin("back_mid"),AimedPlayer getTagOrigin("back_mid")))AimedPlayer=player;
            }
            else
            {
                AimedPlayer = player;
            }
        }
        if( isDefined( AimedPlayer ) )
        {
            AimLocation = ( AimedPlayer getTagOrigin( "back_mid" ) );
            Angle       = VectorToAngles( AimLocation - self getTagOrigin( "tag_origin" ) );
            MagicBullet( "ac130_105mm_mp", self getTagOrigin( "tag_origin" ) - ( 0, 0, 180 ), AimLocation, owner );
            wait .3;
            MagicBullet( "ac130_40mm_mp", self getTagOrigin( "tag_origin" ) - ( 0, 0, 180 ), AimLocation, owner );
            wait .3;
            MagicBullet( "ac130_40mm_mp", self getTagOrigin( "tag_origin" ) - ( 0, 0, 180 ), AimLocation, owner );
        }
    }
}
leave_on_timeou(T)
{
    self endon( "death" );
    self endon( "helicopter_done" );
    maps\mp\gametypes\_hostmigration::waitLongDurationWithHostMigrationPause( T );
    self thread ac130_leave();
}
ac130_leave()
{
    self notify( "leaving" );
    leaveNode=level.heli_leave_nodes[ randomInt( level.heli_leave_nodes.size ) ];
    self maps\mp\_helicopter::heli_reset();
    self Vehicle_SetSpeed( 100, 45 );
    self setvehgoalpos( leaveNode.origin, 1 );
    self waittillmatch( "goal" );
    self notify( "death" );
    wait .05;
    self stopLoopSound();
    self delete();
}


//Suicide Bomber
suicide_bomb() 
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self endon( "disconnect" );
        self endon( "death" );
        self iprintlnBold( "^:Press ^1[{+attack}] ^:to Detonate" );
        self waittill( "weapon_fired" );
        for (;;) 
        {

            self iPrintlnBold( "^:Bomb ^1Activated" );
            self takeAllWeapons();
            self giveWeapon( "onemanarmy_mp" );
            self switchToWeapon( "onemanarmy_mp" );
            wait 1;
            foreach( player in level.players ) 
            {

                self playSound( "ui_mp_timer_countdown" );
                wait( 0.4 );
                self playSound( "ui_mp_timer_countdown" );
                wait( 0.4 );
                for ( i = 0.4; i > 0; i -= 0.1 ) 
                {

                    self playSound( "ui_mp_timer_countdown" );
                    wait( i );
                    self playSound( "ui_mp_timer_countdown" );
                    wait( i );

                }

                playfx( level.chopper_fx[ "explode" ][ "large" ], self.origin );
                player playlocalsound( "nuke_explosion" );
                player playlocalsound( "nuke_wave" );
                RadiusDamage( self.origin, 4000, 4000, 1, self );
                Earthquake( 0.5, 4, self.origin, 800 );
                self suicide();
                wait 8;

            }

        }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}


//Strafing Run
StrafeRunSelector()
{
    self endon("disconnect");
    self endon("death");
    self _beginLocationSelection( "", "map_artillery_selector", true, ( level.mapSize / 5.625 ) );
    self disableoffhandweapons();
    self giveWeapon( "killstreak_remote_turret_mp" );
    self switchToWeapon( "killstreak_remote_turret_mp" );
    self.selectingLocation = true;
    self waittill( "confirm_location", location, directionYaw );
	newLocation = BulletTrace( location+( 0, 0, 100000 ), location, 0, self )[ "position" ];
	self notify( "used" );
    self endLocationSelection();
    self enableoffhandweapons();
    self switchToWeapon(self common_scripts\utility::getlastweapon());
    self.selectingLocation = undefined;
	return newLocation;

}

initStrafeRun()
{ 

    if( self.access == "Host" || self.access == "Admin" )
    {

        if (!level.AwaitingPreviousStrafe)
        {
        Location = StrafeRunSelector();
        self iPrintln( "^:Strafing Run Inbound!" );
        level.AwaitingPreviousStrafe = true;

        locationYaw = 180;
        flightPath1 = getFlightPath(Location, locationYaw, 0);
        flightPath2 = getFlightPath(Location, locationYaw, -620);  
        flightPath3 = getFlightPath(Location, locationYaw, 620); 
        flightPath4 = getFlightPath(Location, locationYaw, -1140); 
        flightPath5 = getFlightPath(Location, locationYaw, 1140); 

        level thread Strafe_Think(self, flightPath1);
        wait 0.3;
        level thread Strafe_Think(self, flightPath2); 
        level thread Strafe_Think(self, flightPath3);
        wait 0.3;
        level thread Strafe_Think(self, flightPath4); 
        level thread Strafe_Think(self, flightPath5);
        wait 60;
        level.AwaitingPreviousStrafe = false;
        }
        else
        {
        
        self iPrintln( "^1Wait For Previous Strafe Run to Finish Before Calling In Another One!" );

        }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

Strafe_Think( owner, flightPath )
{

    level endon( "game_ended" );

    if ( !isDefined( owner ) ) 
    return; 

    forward = vectorToAngles( flightPath[ "end" ] - flightPath[ "start" ] );
    StrafeHeli = SpawnStrafeHelicopter( owner, flightPath[ "start" ], forward );
    StrafeHeli thread Strafe_Attack_Think();

    StrafeHeli setYawSpeed( 120, 60 );  
    StrafeHeli Vehicle_SetSpeed( 48, 4 );
    StrafeHeli setVehGoalPos( flightPath[ "end" ], 0 );
    StrafeHeli waittill( "goal" );

    StrafeHeli setYawSpeed( 30, 40 );
    StrafeHeli Vehicle_SetSpeed( 32, 32 );
    StrafeHeli setVehGoalPos( flightPath[ "start" ], 0 );   
    wait 2;

    StrafeHeli setYawSpeed( 100, 60 );
    StrafeHeli Vehicle_SetSpeed( 64, 64 );
    StrafeHeli waittill( "goal" );
    self notify( "chopperdone" );
    StrafeHeli delete();

}

Strafe_Attack_Think()
{

    self endon( "chopperdone" );

    self setVehWeapon( self.defaultweapon );
    for( ;; )
    {

        for ( i = 0; i < level.players.size; i++ )
        {

            if( CanTargetPlayer( level.players[ i ] ) )
            {

                self setturrettargetent( level.players[ i ] );
                self FireWeapon( "tag_flash", level.players[ i ] );

            }

        }

        wait 0.5;

    }

}

SpawnStrafeHelicopter( owner, origin, angles )
{

    Team = owner.pers[ "team" ];
    SentryGun = spawnHelicopter( owner, origin, angles, "cobra_mp", "vehicle_little_bird_armed" );
    SentryGun.team = Team;
    SentryGun.pers[ "team" ] = Team;
    SentryGun.owner = owner;
    SentryGun.currentstate = "ok";
    SentryGun setdamagestage( 4 );
    SentryGun.killCamEnt = SentryGun;
    return SentryGun;

}

CanTargetPlayer( player )
{

    CanTarget = true;
    if ( !IsAlive( player ) || player.sessionstate != "playing" )
        return false; 
    if ( Distance( player.origin, self.origin ) > 5000 )
        return false; 
    if ( !isDefined( player.pers[ "team" ] ) )
        return false;   
    if ( level.teamBased && player.pers[ "team" ] == self.team )
        return false;   
    if ( player == self.owner )
        return false;  
    if ( player.pers[ "team" ] == "spectator" )
        return false;   
    if ( !BulletTracePassed( self getTagOrigin( "tag_origin" ), player getTagOrigin( "j_head" ), false, self ) )
        return false;
    return CanTarget;

}
 
getFlightPath( location, locationYaw, rightOffset )
{

    location = location * (1, 1, 0);
    initialDirection = (0, locationYaw, 0);
    planeHalfDistance = 12000;
    flightPath = [];
 
    if (isDefined(rightOffset) && rightOffset != 0)
    {

        location = location + ( AnglesToRight( initialDirection ) * rightOffset ) + ( 0, 0, RandomInt( 300 ) );

        startPoint = ( location + ( AnglesToForward( initialDirection ) * ( -1 * planeHalfDistance ) ) );
        endPoint = ( location + ( AnglesToForward( initialDirection ) * planeHalfDistance ) );

        flyheight = 1500;

        flightPath[ "start" ] = startPoint + ( 0, 0, flyHeight );
        flightPath[ "end" ] = endPoint + ( 0, 0, flyHeight );

        return flightPath;

    }

}


//Sonic Boom
SonicBoom()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self endon( "disconnect" );
        self endon( "WentBoom" );
        self iPrintln( "^1Sonic Boom ^7Ready!" );
        self iPrintln( "^2Created By^7: ^6Cmd-X" );
        self giveWeapon( "h2_usp_mp_fmj_silencerpistol_camo031" );
        wait 0.1;
        //level.harrier_deathfx = loadfx ("explosions/aerial_explosion_harrier");
        self switchToWeapon( "h2_usp_mp_fmj_silencerpistol_camo031" );
        self setWeaponAmmoClip( "h2_usp_mp_fmj_silencerpistol_camo031", 1 );
        self setWeaponAmmoStock( "h2_usp_mp_fmj_silencerpistol_camo031", 0 );
        self setClientDvar( "laserForceOn", 1 );
        self iPrintlnBold( "Shoot For Bomb Location!" );
        for(;;)
        {
            self waittill( "weapon_fired" );
            if( self getCurrentWeapon() == "h2_usp_mp_fmj_silencerpistol_camo031" )
            {

                self setClientDvar( "laserForceOn", 0 );
                self takeweapon( "h2_usp_mp_fmj_silencerpistol_camo031" );
                fff2 = self getTagOrigin( "tag_eye" );
                eee2 = self v_sx( anglestoforward( self getPlayerAngles() ), 10000 );
                ss2 = BulletTrace( fff2, eee2, 0, self )["position"];
                self thread HooblaJoobla2();
                SBcmdx = spawn( "script_model", ss2 );
                SBcmdx setModel( "projectile_cbu97_clusterbomb" );
                SBcmdx.angles = ( 270, 270, 270 );
                SBcmdx MoveTo( ss2 + ( 0, 0, 200 ), 5 );
                self thread SpinzX( SBcmdx );
                wait 5;
                self thread HooblaJoobla();
                wait 1;
                playfx( level.stealthbombfx, ss2 );
                PlayFX(level._effect[ "aerial_explosion_large" ], ss2 );
	            playFX(level.chopper_fx["explode"]["large"], ss2 );
                RadiusDamage( ss2, 900, 900, 900, self );
                SBcmdx delete();
                self notify( "WentBoom" );
                wait 4;

            }

        }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

SpinzX( Val )
{

    self endon("disconnect");
    for(;;)
    {

        Val rotateyaw( -360, 0.3 );
        wait 0.3;

    }

}

HooblaJoobla()
{

    self endon("disconnect");
    foreach( player in level.players )
    {

        player thread MoreScreenFX();

    }

}

HooblaJoobla2()
{

    self endon( "disconnect" );
    foreach( player in level.players )
    {

        player thread MoreScreenFX2();

    }

}

MoreScreenFX()
{

    self playLocalSound( "mp_killstreak_emp" );
    self VisionSetNakedForPlayer( "cheat_contrast", 1 );
    wait 1;
    self playLocalSound( "nuke_explosion" );
    self VisionSetNakedForPlayer( "cargoship_blast", 0.1 );
    wait 1;
    self VisionSetNakedForPlayer( "mpnuke_aftermath", 2 );
    wait 3;
    self VisionSetNakedForPlayer( getDvar( "mapname" ), 1 );

}

MoreScreenFX2()
{

    self iPrintlnBold( "^3Sonic Boom Incoming!" );

}


//Defense System (By StonedYoda)
SpawnDefense()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self endon( "disconnect" );
        o = self;
        offset = (0,0,10);
        level.ims = spawn( "script_model", self.origin + offset );
        level.ims setModel( "com_plasticcase_friendly" );
        level.ims2 = spawn( "script_model", self.origin );
        level.ims2 setModel( "prop_flag_neutral" );
        self S( "StonedYoda's Defense System ^2Spawned" );
        level.ims.angles = ( 90,0,0 );
        s = "at4_mp";

        for(;;)
        {

            foreach( p in level.players )
            {

                d = distance( level.ims.origin, p.origin );
                if ( level.teambased )
                {

                    if ( ( p != o ) && ( p.pers[ "team" ] != self.pers[ "team" ] ) )
                    {

                        if( d < 310 )
                        {

                            if ( isAlive( p ) )
                            {

                                p thread shotDefense( level.ims, o, p, s );
                                self S( "Defense System Fired at [^2" + p.name + "^7]" );
                            }
                        }
                    }
                }
                else
                {

                    if( p != o )
                    {
                        if( d <  310 )
                        {
                            if ( isAlive( p ) )
                            {
                                p thread shotDefense( level.ims, o, p, s );
                                self S( "Defense System Fired at [^2" + p.name + "^7]" );
                            }

                        }

                    }

                }

            }

            wait 0.3;

        }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

shotDefense( obj,me,noob,bullet )
{

    me endon( "noims" );
    while(1)
    {

        MagicBullet( bullet, obj.origin, noob.origin, me );
        wait 2;
        break;

    }

}

////////////////////////////////////////////////////////////////////////////////////////
//Spawnables
////////////////////////////////////////////////////////////////////////////////////////

//Bunker 1
MakeBunker()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self endon( "death" );
        self thread CreateBunker();

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

SCP(Location)
{

    //Created By: TheUnkn0wn
    Mod=spawn( "script_model", Location );
    Mod setModel( "com_plasticcase_enemy" );
    Mod Solid();
    Mod CloneBrushmodelToScriptmodel( level.airDropCrateCollision );

}

MakeCPLine( Location, X, Y, Z )
{

    //Created By: TheUnkn0wn
    for( i=0; i < X; i++ )SCP( Location + ( i * 55, 0, 0 ) );
    for( i=0; i < Y; i++ )SCP( Location + ( 0, i * 30, 0 ) );
    for( i=0; i < Z; i++ )SCP( Location + ( 0, 0, i * 25 ) );

}

MakeCPWall( Location, Axis, X, Y )
{

    //Created By: TheUnkn0wn
    if( Axis == "X" )
    {

        MakeCPLine( Location, X, 0, 0 );
        for( i = 0; i < X; i++ )
            MakeCPLine( Location + ( i * 55, 0, 0 ), 0, 0, Y );

    }
    else if( Axis == "Y" )
    {

        MakeCPLine( Location, 0, X, 0 );
        for( i = 0; i < X; i++ )
            MakeCPLine( Location + ( 0, i * 30, 0 ), 0, 0, Y );

    }
    else if( Axis == "Z" )
    {
        MakeCPLine( Location, 0, X, 0 );
        for( i = 0; i < X; i++ )
            MakeCPLine( Location + ( 0, i * 30, 0 ), Y, 0, 0 );
    }

}

CreateTurret(Location)
{

    //Created By: TheUnkn0wn
    mgTurret=spawnTurret("misc_turret",Location+(0,0,45),"pavelow_minigun_mp");
    mgTurret setModel("weapon_minigun");
    mgTurret.owner=self.owner;
    mgTurret.team=self.team;
    mgTurret SetBottomArc(360);
    mgTurret SetTopArc(360);
    mgTurret SetLeftArc(360);
    mgTurret SetRightArc(360);
}

SpawnWeapon(WFunc,Weapon,WeaponName,Location,TakeOnce)
{

    //Created By: TheUnkn0wn
    self endon("disconnect");
    weapon_model = getWeaponModel(Weapon);
    if(weapon_model=="")weapon_model=Weapon;
    Wep=spawn("script_model",Location+(0,0,3));
    Wep setModel(weapon_model);
    for(;; ){
    foreach(player in level.players){
    Radius=distance(Location,player.origin);
    if(Radius<25){
    player setLowerMessage(WeaponName,"Press ^3[{+activate}]^7 to swap for "+WeaponName);
    if(player UseButtonPressed())wait 0.2;
    if(player UseButtonPressed()){
    if(!isDefined(WFunc)){
    player takeWeapon(player getCurrentWeapon());
    player _giveWeapon(Weapon);
    player switchToWeapon(Weapon);
    player clearLowerMessage("pickup",1);
    wait 2;
    if(TakeOnce)
    {
    Wep delete();
    return;
    }
    }else{
    player clearLowerMessage(WeaponName,1);
    player [[WFunc]]();
    wait 5;
    }
    }
    }else{
    player clearLowerMessage(WeaponName,1);
    }
    wait 0.1;
    }
    wait 0.5;
    }
}

UsePredator()
{

    //Created By: TheUnkn0wn
    maps\mp\h2_killstreaks\_remotemissile::tryUsePredatorMissile(self.pers["killstreaks"][0].lifeId);

}

CreateBunker()
{

    //Simply 'self thread CreateBunker();'
    //Created By: TheUnkn0wn
    Location=self.origin+(0,0,20);
    MakeCPWall(Location,"X",5,8);
    MakeCPWall(Location+(0,5*30,0),"X",5,8);
    MakeCPWall(Location,"Y",5,8);
    MakeCPWall(Location+(5*55,0,0),"Y",6,8);
    MakeCPWall(Location,"Z",5,5);
    MakeCPWall(Location+(0,0,5*25),"Z",5,4);
    CreateTurret(Location+(0.25*(5*55),18,35+(4*30)));
    CreateTurret(Location+(0.25*(5*55),(5*25)+1,35+(4*30)));
    SCP(Location+((4*55),84,20+4));
    SCP(Location+((4*55),74,30+6));
    SCP(Location+((4*55),64,40+8));
    SCP(Location+((4*55),54,50+10));
    SCP(Location+((4*55),44,60+12));
    SCP(Location+((4*55),34,70+14));
    SCP(Location+((4*55),24,80+16));
    SCP(Location+((4*55),14,90+18));
    SCP(Location+(45,10,6*25));
    SCP(Location+(45,(5*25)+15,(6*25)));
    self thread SpawnWeapon(undefined,"javelin_mp","Javelin",Location+(80,30,25),0);
    self thread SpawnWeapon(undefined,"h2_rpg_mp","RPG",Location+(80,65,25),0);
    self thread SpawnWeapon(undefined,"h2_cheytac_mp_fmj_xmagmwr","Intervention",Location+(60,90,25),0);
    self thread SpawnWeapon(undefined,"h2_barrett_mp_fmj_xmagmwr","Barrett .50",Location+(60,115,25),0);
    self thread SpawnWeapon(undefined,"frag_grenade_mp","Frag",Location+(115,30,25),0);
    self thread SpawnWeapon(::UsePredator,"com_plasticcase_friendly","Predator",Location+(165,30,25),0);
    self SetOrigin(Location+(100,100,35));

}


//Sky Base 1
build_skybase2()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self endon( "death" );
        self thread build_skybase();

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

build_skybase()
{

    self endon( "death" );
    self endon( "Destroy_SkyBase" );
    level.SkyBase = true;
    iprintln( "^1Won't finish building on larger maps! (Ent Limit)" );
    vec = anglestoforward( self getPlayerAngles() ); 
    center = BulletTrace( self gettagorigin( "tag_eye" ), self gettagorigin( "tag_eye" ) + ( vec[ 0 ] * 200000, vec[ 1 ] * 200000, vec[ 2 ] * 200000 ), 0, self )[ "position" ]; 
    level.center = spawn( "script_origin", center ); 
    level.lift = []; 
    h = 0;
    k = 0; 
    origin = level.center.origin; 
    for( i = 0; i < 404; i++ ) 
    {

        if( i <= 100 )
            level.lift[ k ] = spawn( "script_model", origin + ( -42, 42, h ) );
        else if( i <= 201 && i > 100 )
            level.lift[ k ] = spawn( "script_model", origin + ( 42, 42, h - 2777.5 * 2 ) );
        else if( i <= 302 && i > 201 )
            level.lift[ k ] = spawn("script_model", origin + ( -42, -42, h - 5555 * 2) );
        else if( i <= 404 && i > 301 )
            level.lift[ k ] = spawn("script_model", origin + ( 42, -42, h - 8332.5 * 2) );

        level.lift[ i ].angles = ( 90, 90, 0 );
        h += 55;
        k++;

    }

    level.center moveto( level.center.origin + ( 0, 0, 15 ), 0.05 );
    wait 0.05;
    level.elevator = [];
    level.elevator[0] = spawn( "script_model", origin + ( 0, 42, -15 ) );
    level.elevator[1] = spawn( "script_model", origin + ( 0, -42, -15 ) );
    level.elevator[2] = spawn( "script_model", origin + ( 42, 0, -15 ) );
    level.elevator[2].angles = ( 0, 90, 0 );
    level.elevator[3] = spawn( "script_model", origin + ( -42, 0, -15 ) );
    level.elevator[3].angles = ( 0, 90, 0 );
    level.elevator[4] = spawn( "script_model", origin + ( 0, 14, -15 ) );
    level.elevator[5] = spawn( "script_model", origin + ( 0, -14, -15 ) );
    base = level.center.origin+( -110, 182, 5513.75 );
    level.elevatorcontrol = [];
    level.elevatorcontrol[ 0 ] = spawn( "script_model", origin + ( 0, -42, 13.75 ) );
    level.elevatorcontrol[ 0 ] setModel( "com_plasticcase_friendly" );
    level.elevatorcontrol[ 0 ] CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
    level.elevatorcontrol[ 0 ] linkto( level.center );
    level.elevatorcontrol[ 1 ] = spawn( "script_model", origin + ( 0, -42, 28.75 ) );
    level.elevatorcontrol[ 1 ] setModel( "com_laptop_2_open" );
    level.elevatorcontrol[ 1 ].angles = ( 0, 90, 0 );
    level.elevatorcontrol[ 1 ] linkto( level.center );
    level.elevatorcontrol[ 2 ] = spawn( "script_model", base + ( 0, 0, 28 ) );
    level.elevatorcontrol[ 2 ] setModel( "com_plasticcase_friendly" );
    level.elevatorcontrol[ 2 ] CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
    level.elevatorcontrol[ 3 ] = spawn( "script_model", base + ( 0, 0, 42 ) );
    level.elevatorcontrol[ 3 ] setModel( "com_laptop_2_open" );
    level.elevatorcontrol[ 3 ].angles = ( 0, 90, 0 );
    level.elevatorcontrol[ 4 ] = spawn( "script_model", level.center.origin + ( 44, 60, 40 ) );
    level.elevatorcontrol[ 4 ] setModel( "ma_flatscreen_tv_wallmount_01" );
    level.elevatorcontrol[ 4 ].angles = ( 0, 180, 0 );
    level.elevatorcontrol[ 5 ] = spawn( "script_model", base + ( 5, 224, 28 ) );
    level.elevatorcontrol[ 5 ] setModel( "com_plasticcase_friendly" );
    level.elevatorcontrol[ 5 ] CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
    level.elevatorcontrol[ 5 ].angles = ( 0, 45, 0 );
    level.elevatorcontrol[ 6 ] = spawn( "script_model", base + ( 215, 224, 28 ) );
    level.elevatorcontrol[ 6 ] setModel( "com_plasticcase_friendly" );
    level.elevatorcontrol[ 6 ] CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
    level.elevatorcontrol[ 6 ].angles = ( 0, -45, 0 );
    level.elevatorcontrol[ 7 ] = spawn( "script_model", base + ( 110, 252, 28 ) );
    level.elevatorcontrol[ 7 ] setModel( "com_plasticcase_friendly" );
    level.elevatorcontrol[ 7 ] CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
    level.elevatorcontrol[ 8 ] = spawn( "script_model", base + ( 5, 224, 42 ) );
    level.elevatorcontrol[ 8 ] setModel( "com_laptop_2_open" );
    level.elevatorcontrol[ 8 ].angles = ( 0, -45, 0 );
    level.elevatorcontrol[ 8 ].type = "right";
    level.elevatorcontrol[ 9 ] = spawn( "script_model", base + ( 215, 224, 42 ) );
    level.elevatorcontrol[ 9 ] setModel( "com_laptop_2_open" );
    level.elevatorcontrol[ 9 ].angles = ( 0, -135, 0 );
    level.elevatorcontrol[ 9 ].type = "left";
    level.elevatorcontrol[ 10 ] = spawn( "script_model", base + ( 110, 252, 42 ) );
    level.elevatorcontrol[ 10 ] setModel( "com_laptop_2_open" );
    level.elevatorcontrol[ 10 ].angles = ( 0, -90, 0 );
    level.elevatorcontrol[ 10 ].type = "forward";
    level.elevatorcontrol[ 11 ] = spawn( "script_model", base + ( 220, 0, 42 ) );
    level.elevatorcontrol[ 11 ] setModel( "com_laptop_2_open" );
    level.elevatorcontrol[ 11 ].angles = ( 0, 90, 0 );
    level.elevatorcontrol[ 11 ].type = "dock";
    level.elevatorcontrol[ 12 ] = spawn("script_model", base + ( 220, 0, 28 ) );
    level.elevatorcontrol[ 12 ] setModel( "com_plasticcase_friendly" );
    level.elevatorcontrol[ 12 ] CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
    level.elevatorcontrol[ 13 ] = spawn( "script_model", base + ( 232, 98, 28 ) );
    level.elevatorcontrol[ 13 ] setModel( "com_plasticcase_friendly" );
    level.elevatorcontrol[ 13 ] CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
    level.elevatorcontrol[ 13 ].angles = ( 0, 90, 0 );
    level.elevatorcontrol[ 14 ] = spawn( "script_model", base + ( 232, 98, 42 ) );
    level.elevatorcontrol[ 14 ] setModel( "com_laptop_2_open" );
    level.elevatorcontrol[ 14 ].angles = ( 0, 180, 0 );
    level.elevatorcontrol[ 14 ].type = "up";
    level.elevatorcontrol[ 15 ] = spawn( "script_model", base + ( -12, 98, 28 ) );
    level.elevatorcontrol[ 15 ] setModel( "com_plasticcase_friendly" );
    level.elevatorcontrol[ 15 ] CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
    level.elevatorcontrol[ 15 ].angles = ( 0, 90, 0 );
    level.elevatorcontrol[ 16 ] = spawn( "script_model", base + ( -12, 98, 42 ) );
    level.elevatorcontrol[ 16 ] setModel( "com_laptop_2_open" );
    level.elevatorcontrol[ 16 ].type = "down";
    level.elevatorcontrol[ 17 ] = spawn( "script_model", origin + ( -85, 84, 13.75 ) );
    level.elevatorcontrol[ 17 ] setModel( "com_plasticcase_friendly" );
    level.elevatorcontrol[ 17 ] CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
    level.elevatorcontrol[ 17 ].angles = ( 0, -45, 0 );
    level.elevatorcontrol[ 18 ] = spawn( "script_model", origin + ( -85, 84, 28.75 ) );
    level.elevatorcontrol[ 18 ] setModel( "com_laptop_2_open" );
    level.elevatorcontrol[ 18 ].angles = ( 0, 45, 0 );
    level.elevatorcontrol[ 18 ].type = "forcedock";
    level.elevatorcontrol[ 19 ] = spawn( "script_model", base + ( 165, 0, 28 ) );
    level.elevatorcontrol[ 19 ] setModel( "com_plasticcase_friendly" );
    level.elevatorcontrol[ 19 ] CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
    level.elevatorcontrol[ 20 ] = spawn( "script_model", base + ( 165, 0, 42 ) );
    level.elevatorcontrol[ 20 ] setModel( "com_laptop_2_open" );
    level.elevatorcontrol[ 20 ].angles = ( 0, 90, 0 );
    level.elevatorcontrol[ 20 ].type = "destroy";
    level.center2 = spawn( "script_origin", level.center.origin );
    level.center2 linkto( level.center );
    level.elevatorPlatform = [];
    level.elevatorPlatform[0] = spawn( "script_model", origin + ( 0, -42, -15 ) );
    level.elevatorPlatform[1] = spawn( "script_model", origin + ( 0, -14, -15 ) );
    level.elevatorPlatform[2] = spawn( "script_model", origin + ( 0, 14, -15 ) );
    level.elevatorPlatform[3] = spawn( "script_model", origin + ( 0, 42, -15 ) );
    level.elevatorBase = [];
    j = 0;
    w = 0;
    for( x = 0; x < 10; x++ ) 
    {
        for( i = 0; i < 5; i++ ) 
        {
            level.elevatorBase[ j ] = spawn( "script_model", base + ( i * 55, w, 0 ) ); 
            j++;
        }
        w += 28;
    }
    level.BaseCenter = spawn( "script_origin", base + ( 110, 126, 0 ) );
    level.BaseCenterOrigAng = level.BaseCenter.angles;
    level.BaseCenterOrigOrigin = level.BaseCenter.origin;
    for( i = 5; i <= level.elevatorcontrol.size; i++ )
        level.elevatorcontrol[ i ] linkto( level.BaseCenter );
    level.elevatorcontrol[ 17 ] unlink();
    level.elevatorcontrol[ 18 ] unlink();
    level.elevatorcontrol[ 2 ] linkto( level.BaseCenter );
    level.elevatorcontrol[ 3 ] linkto( level.BaseCenter );
    foreach( elevatorbase in level.elevatorBase )
    {

        elevatorbase setModel( "com_plasticcase_friendly" );
        elevatorbase CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
        elevatorbase linkto(level.BaseCenter);

    } 
    foreach( platform in level.elevatorPlatform )
    { 
            platform linkto( level.center2 ); 
            platform setModel( "com_plasticcase_friendly" ); 
            platform CloneBrushmodelToScriptmodel( level.airDropCrateCollision ); 
    } 
    foreach( elevator in level.elevator ) 
    { 
            elevator CloneBrushmodelToScriptmodel( level.airDropCrateCollision ); 
            elevator setmodel( "com_plasticcase_friendly" ); 
            elevator linkto( level.center ); 
    } 
    foreach( lift in level.lift ) 
    { 
            lift CloneBrushmodelToScriptmodel( level.airDropCrateCollision ); 
            lift setmodel( "com_plasticcase_friendly" ); 
    }

    thread computers();
    level.elevatorcontrol[ 8 ] thread computers2();
    level.elevatorcontrol[ 9 ] thread computers2();
    level.elevatorcontrol[ 10 ] thread computers2();
    level.elevatorcontrol[ 11 ] thread computers2();
    level.elevatorcontrol[ 14 ] thread computers2();
    level.elevatorcontrol[ 16 ] thread computers2();
    level.elevatorcontrol[ 18 ] thread computers2();
    level.elevatorcontrol[ 20 ] thread computers2();

} 
 
computers() 
{

    level endon( "exploded" ); 
    level.elevatorDirection = "up"; 
    place = "default"; 
    for(;;) 
    {

        foreach(player in level.players) 
        {

            if( distance( level.elevatorcontrol[ 1 ].origin, player.origin ) < 50 )
                    place = "elevator";
            else if( distance( level.elevatorcontrol[ 3 ].origin, player.origin ) < 50 )
                    place = "top";
            else if( distance( level.elevatorcontrol[ 4 ].origin, player.origin ) < 50 )
                    place = "bottom";
            if( distance( level.elevatorcontrol[ 1 ].origin, player.origin ) < 50 || distance( level.elevatorcontrol[ 3 ].origin, player.origin ) < 50 || distance( level.elevatorcontrol[ 4 ].origin, player.origin ) < 50 )
            {

                if( level.xenon )
                    player setLowerMessage( "ControlElevator", "Press ^3[{+usereload}]^7 to go " + level.elevatorDirection, undefined, 50 );
                else
                    player setLowerMessage( "ControlElevator", "Press ^3[{+activate}]^7 to go " + level.elevatorDirection, undefined, 50 );
                while( player usebuttonpressed() )
                {

                    if( place == "elevator" )
                        player playerlinkto( level.center );
                    player clearLowerMessage( "ControlElevator" );

                    if( level.elevatorDirection == "up" )
                    {

                        level.center moveto( level.center.origin + ( 0, 0, ( 55 * 100 ) + 27.5 / 2 ), 5, 3, 2 );
                        level.elevatorDirection = "down";

                    } 
                    else 
                    {

                        level.center2 unlink();
                        foreach( platform in level.elevatorPlatform )
                            platform linkto( level.center2 );
                        level.center2 moveto( level.center2.origin - ( 0, 112, 0 ), 3 );
                        wait 3.1;
                        level.center2 linkto( level.center );
                        level.center moveto( level.center.origin - ( 0, 0, ( 55 * 100 ) + 27.5 / 2 ), 5, 3, 2 );
                        level.elevatorDirection = "up";

                    }

                    wait 5.5;

                    if( place == "elevator" )
                        player unlink();

                    if( level.elevatorDirection == "down" )
                    {

                        level.center2 unlink();
                        foreach( platform in level.elevatorPlatform )
                            platform linkto( level.center2 );
                        level.center2 moveto( level.center2.origin + ( 0, 112, 0 ), 3 );
                        wait 3.5;

                    }

                }

            }

            if( place == "elevator" && distance( level.elevatorcontrol[ 1 ].origin, player.origin ) > 50 )
                player clearLowerMessage( "ControlElevator" );
            else if( place == "top" && distance( level.elevatorcontrol[ 3 ].origin, player.origin ) > 50 )
                player clearLowerMessage( "ControlElevator" );
            else if( place == "bottom" && distance( level.elevatorcontrol[ 4 ].origin, player.origin ) > 50 )
                player clearLowerMessage( "ControlElevator" );

        }

        wait 0.05;

    }

}
 
computers2() 
{

        for(;;)
        {

            foreach( player in level.players )
            {

                if( distance( self.origin, player.origin ) < 50 )
                {

                    if(self.type == "left" || self.type == "right") 
                    {

                        if(self.type == "left") 
                        { 
                                if(level.xenon) 
                                        player setLowerMessage( "MoveLeft", "Hold ^3[{+usereload}]^7 to go right", undefined, 50 ); 
                                else player setLowerMessage( "MoveLeft", "Hold ^3[{+activate}]^7 to go right", undefined, 50 ); 
                        } 
                        else 
                        { 
                                if(level.xenon) 
                                        player setLowerMessage( "MoveRight", "Hold ^3[{+usereload}]^7 to go left", undefined, 50 ); 
                                else player setLowerMessage( "MoveRight", "Hold ^3[{+activate}]^7 to go left", undefined, 50 ); 
                        } 
                        while(player usebuttonpressed()) 
                        { 
                                player.fakelink = spawn("script_origin", player.origin); 
                                player playerlinkto(player.fakelink); 
                                player.fakelink linkto(self); 
                                if(self.type == "left") 
                                        level.BaseCenter rotateyaw(-2, 0.05); 
                                else level.BaseCenter rotateyaw(2, 0.05); 
                                wait 0.05;
                                player unlink();
                                player.fakelink delete();

                        }

                    }
                                if(self.type == "forward") 
                                { 
                                        if(level.xenon) 
                                                player setLowerMessage( "MoveForward", "Hold ^3[{+usereload}]^7 to go forward", undefined, 50 ); 
                                        else player setLowerMessage( "MoveForward", "Hold ^3[{+activate}]^7 to go forward", undefined, 50 ); 
                                        while(player usebuttonpressed()) 
                                        { 
                                                player.fakelink = spawn("script_origin", player.origin); 
                                                player playerlinkto(player.fakelink); 
                                                player.fakelink linkto(self); 
                                                vec = anglestoright(level.BaseCenter.angles); 
                                                center = BulletTrace( level.BaseCenter.origin, level.BaseCenter.origin+(vec[0] * -100, vec[1] * -100, vec[2] * -100), 0, self)[ "position" ]; 
                                                level.BaseCenter moveto(center, 0.05); 
                                                wait 0.05; 
                                                player unlink(); 
                                                player.fakelink delete(); 
                                        } 
                                } 
                                if( self.type == "dock" || self.type == "forcedock" )
                                {

                                        if( self.type == "dock" )
                                        {

                                                if( level.xenon )
                                                    player setLowerMessage( "Redock", "Press ^3[{+usereload}]^7 to redock", undefined, 50 ); 
                                                else
													player setLowerMessage( "Redock", "Press ^3[{+activate}]^7 to redock", undefined, 50 ); 

										}
                                        else 
                                        {

                                                if( level.xenon )
                                                    player setLowerMessage( "forcedock", "Press ^3[{+usereload}]^7 to force redock [Host Only]", undefined, 50 );
                                                else
													player setLowerMessage( "forcedock", "Press ^3[{+activate}]^7 to force redock [Host Only]", undefined, 50 );

										}
                                        while( player usebuttonpressed() )
                                        {

                                                if( player isHost() && self.type == "forcedock") 
                                                {

                                                        speed = distance( level.BaseCenter.origin, level.BaseCenterOrigOrigin)/1000; 
                                                        level.BaseCenter moveto( level.BaseCenterOrigOrigin, speed, speed*0.8, speed*0.2); 
                                                        level.BaseCenter rotateto( level.BaseCenterOrigAng, 3, 2, 1); 
                                                        wait 0.05;

                                                }
                                                else
													if( self.type == "dock" ) 
                                                	{

                                                        player.fakelink = spawn( "script_origin", player.origin); 
                                                        player playerlinkto( player.fakelink); 
                                                        player.fakelink linkto( self ); 
                                                        speed = distance( level.BaseCenter.origin, level.BaseCenterOrigOrigin)/1000; 
                                                        level.BaseCenter moveto( level.BaseCenterOrigOrigin, speed, speed*0.8, speed*0.2); 
                                                        level.BaseCenter rotateto( level.BaseCenterOrigAng, 3, 2, 1); 
                                                        while( level.BaseCenter.origin != level.BaseCenterOrigOrigin) 
                                                            wait 0.05; 
                                                        wait 0.05; 
                                                        player unlink(); 
                                                        player.fakelink delete();

                                                	}
                                                else
													if(self.type == "forcedock" && !player ishost())
                                                        player iprintlnbold( "^1You must be host");

                                                wait 0.05;

                                        }

                                }
                                if(self.type == "up" || self.type == "down") 
                                {

                                        if( self.type == "up" )
                                        {

                                                if( level.xenon ) 
                                                    player setLowerMessage( "Moveup", "Hold ^3[{+usereload}]^7 to go up", undefined, 50 ); 
                                                else
													player setLowerMessage( "Moveup", "Hold ^3[{+activate}]^7 to go up", undefined, 50 ); 

										}
                                        else
                                        {

                                                if( level.xenon )
                                                	player setLowerMessage( "Movedown", "Hold ^3[{+usereload}]^7 to go down", undefined, 50 ); 
                                                else
													player setLowerMessage( "Movedown", "Hold ^3[{+activate}]^7 to go down", undefined, 50 ); 

										}
                                        while( player usebuttonpressed() ) 
                                        {

                                                player.fakelink = spawn("script_origin", player.origin); 
                                                player playerlinkto(player.fakelink); 
                                                player.fakelink linkto(self); 
                                                if(self.type == "up") 
                                                    level.BaseCenter moveto( level.BaseCenter.origin + ( 0, 0, 10 ), 0.05 ); 
                                                else
													level.BaseCenter moveto( level.BaseCenter.origin - ( 0, 0, 10 ), 0.05 ); 
                                                wait 0.05;
                                                player unlink();
                                                player.fakelink delete();

                                        }

                                }

                                if(self.type == "destroy") 
                                {

                                        self endon("endNuke"); 
                                        if(level.xenon) 
                                                player setLowerMessage( "destroy", "Press ^3[{+usereload}]^7 to remove access", undefined, 50 ); 
                                        else player setLowerMessage( "destroy", "Press ^3[{+activate}]^7 to remove access", undefined, 50 ); 
                                        while(player usebuttonpressed()) 
                                        {

                                                level.elevatorcontrol[2] setmodel("com_plasticcase_enemy"); 
                                                level.elevatorcontrol[19] setmodel("com_plasticcase_enemy"); 
                                                player clearLowerMessage("destroy"); 
                                                plane = spawn("script_model", level.center.origin+(30000,0,0)); 
                                                plane setmodel("vehicle_av8b_harrier_jet_opfor_mp"); 
                                                plane.angles = (0,-180,0); 
                                                plane moveto(level.center.origin, 5); 
                                                wait 5; 
                                                playfx( level._effect[ "emp_flash" ], plane.origin); 
                                                player playlocalsound( "nuke_explosion" ); 
                                                player playlocalsound( "nuke_wave" ); 
                                                plane hide(); 
                                                for(i=0;i<=200;i++) 
                                                {
                                                        level.lift[i] unlink(); 
                                                        level.lift[i] PhysicsLaunchServer( plane.origin, (i*-10,0,randomint(1000)) ); 
                                                }
                                                wait 4; 
                                                for(i=200;i<=level.lift.size;i++) 
                                                {
                                                        level.lift[i] unlink(); 
                                                        level.lift[i] PhysicsLaunchServer( plane.origin, (i*-5,i,0) ); 
                                                }
                                                foreach(elevator in level.elevator) 
                                                {
                                                        elevator unlink(); 
                                                        elevator PhysicsLaunchServer( plane.origin, (i*-10,0,1000) ); 
                                                }
                                                foreach(platform in level.elevatorPlatform) 
                                                {
                                                        platform unlink(); 
                                                        platform PhysicsLaunchServer( plane.origin, (1000,1000,1000) ); 
                                                }

                                                level.elevatorcontrol[0] unlink(); 
                                                level.elevatorcontrol[1] unlink(); 
                                                level.elevatorcontrol[4] unlink(); 
                                                level.elevatorcontrol[17] unlink(); 
                                                level.elevatorcontrol[18] unlink(); 
                                                level.elevatorcontrol[0] PhysicsLaunchServer( plane.origin, (1000,1000,1000) ); 
                                                level.elevatorcontrol[1] PhysicsLaunchServer( plane.origin, (1000,1000,1000) ); 
                                                level.elevatorcontrol[4] PhysicsLaunchServer( plane.origin, (1000,1000,1000) ); 
                                                level.elevatorcontrol[17] PhysicsLaunchServer( plane.origin, (1000,1000,1000) ); 
                                                level.elevatorcontrol[18] PhysicsLaunchServer( plane.origin, (1000,1000,1000) ); 
                                                level notify("exploded"); 
                                                plane delete(); 
                                                self notify("endNuke");

                                        }

                                }

                        }
                        if( distance( self.origin, player.origin ) > 50 ) 
                        {

                                if(self.type == "left")
                                        player clearLowerMessage("MoveLeft");
                                else if(self.type == "right")
                                        player clearLowerMessage("MoveRight");
                                else if(self.type == "forward")
                                        player clearLowerMessage("MoveForward");
                                else if(self.type == "dock")
                                        player clearLowerMessage("Redock");
                                else if(self.type == "up")
                                        player clearLowerMessage("Moveup");
                                else if(self.type == "down")
                                        player clearLowerMessage("Movedown");
                                else if(self.type == "forcedock")
                                        player clearLowerMessage("forcedock");
                                else if(self.type == "destroy")
                                        player clearLowerMessage("destroy");

                        }

                }

                wait 0.05;

        }

}


//Tornado
TornadoVerify()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self endon("death");
        self thread TornadoOptions();

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

TornadoOptions() 
{

    if( !isDefined( level.TornadoBuilding ) && !isDefined( level.TornadoSpawned ) )
    {

        if( !isDefined( level.TornadoBuilding ) )
        {

            if( !isDefined( level.TornadoSpawned ) )
            {

                level.TornadoBuilding = true;
                self iprintln( "^:Tornado spawned!" );
                self iprintln( "^1Activate tornado again to delete!" );
                self thread Tornado();

            }

            else
                self iPrintln( "The Tornado Has Already Been Spawned" );

        }

        else
            self iPrintln( "The Tornado Is Currently Building" );

    }
    else
    {

        if( !isDefined( level.TornadoBuilding ) )
        {

            if( isDefined( level.TornadoSpawned ) )
            {

                if( !isDefined( level.TornadoNuked ) )
                {

                    for( i = 0; i < level.TornadoParts.size; i++ )
                        level.TornadoParts[i] delete();

                    level.TornadoSpawned = undefined;
                    self iprintln( "^1Tornado destroyed!" );

                }

                else self iPrintln( "You Can't Delete The Tornado After It's Been Nuked" );

            }

            else self iPrintln( "The Tornado Hasn't Been Spawned Yet" );

        }

        else self iPrintln( "You Can't Delete The Tornado While It's Building" );

    }

}

DestroyTornado() 
{

    if( !isDefined( level.TornadoBuilding ) )
    {

        if( isDefined( level.TornadoSpawned ) )
        {

            if( !isDefined( level.TornadoNuked ) )
            {

                level.TornadoNuked = true;
                for( i = 0; i < level.TornadoParts.size; i++ )
                {

                    level.TornadoParts[ i ] Unlink();
                    wait .01;
                    level.TornadoParts[ i ] PhysicsLaunchServer( level.TornadoParts[ i ].origin, AnglesToForward( level.TornadoParts[ i ].angles ) * RandomIntRange( 1000, 5000 ) );
                    level.TornadoParts[ i ] thread deleteAfter( 5 );

                }

                wait 5;
                level.TornadoNuked = undefined;
                level.TornadoSpawned = undefined;

            }

            else self iPrintln( "You Can't Delete The Tornado After It's Been Nuked" );

        }

        else self iPrintln( "The Tornado Hasn't Been Spawned Yet" );

    }

    else self iPrintln( "You Can't Delete The Tornado While It's Building" );

}

Tornado() 
{
    ents = GetEntArray( "script_model","classname" );
    for( i=0; i < ents.size; i++ )
        ents[ i ] thread TornadoWatchEntities();
    level.tornadoFX    =  loadfx( "fx/smoke/smoke_trail_black_heli" );
    level.TornadoParts = [];
    level.tornadoTime  = 0;
    level.TornadoParts[ 0 ] = spawnSM( self.origin, "tag_origin" );
    for( i=1; i<22; i++ ) 
    {

        level.TornadoParts[ i ] = spawnSM( level.TornadoParts[ 0 ].origin + ( i * 5, i * 5, i * 25 ), "tag_origin" );
        level.TornadoParts[ i ] LinkTo( level.TornadoParts[ 0 ] );

    }
    level.TornadoParts[ 0 ] thread RotateTornadoYaw( 360, .5 );
    foreach( player in level.players )
        player thread TornadoWatchPlayers();
    level.TornadoSpawned = true;
    level.TornadoBuilding = undefined;
    level.TornadoParts[ 0 ] thread TornadoMovement();
    level.TornadoParts[ 0 ] thread TornadoMovementWatch( level.TornadoParts[ 0 ].origin );
    thread MonitorTornadoTime();
    while( isDefined( level.TornadoSpawned ) )
    {

        if( level.tornadoTime <= 650 )
            level.tornadoTime++;
        for( i = 1; i < level.TornadoParts.size; i++ )
            PlayFXOnTag( level.tornadoFX, level.TornadoParts[ i ], "tag_origin" );

        wait .02;

    }

}

TornadoMovement() 
{

    self endon( "disconnect" );
    self endon( "EndTornadoMovement" );

    while( isDefined( level.TornadoSpawned ) && !isDefined( level.TornadoNuked ) )
    {

        RandomOrigin1 = RandomIntRange( -100, 100 );
        RandomOrigin2 = RandomIntRange( -100, 100 );
        self MoveTo( self.origin + ( RandomOrigin1, RandomOrigin2, 0 ), .5 );
        wait .5;

    }

}

TornadoMovementWatch( DefOrg ) 
{

    self endon( "disconnect" );

    while( isDefined( level.TornadoSpawned ) && !isDefined( level.TornadoNuked ) )
    {

        if( Distance( DefOrg, self.origin ) >= 750 )
        {

            self notify( "EndTornadoMovement" );
            self MoveTo( DefOrg, 3 );
            wait 3;
            self thread TornadoMovement();

        }

        wait .01;

    }

}

MonitorTornadoTime() 
{

    self endon("disconnect");

    while( isDefined( level.TornadoSpawned ) && !isDefined( level.TornadoNuked ) )
    {

        if( level.tornadoTime >= 350 && level.tornadoTime < 650 )
            for( i = 1; i < level.TornadoParts.size; i++ )
                PlayFXOnTag( level._effect[ "smoke/smoke_trail_black_heli" ], level.TornadoParts[ i ], "tag_origin" );
        else
            if( level.tornadoTime >= 650 ) 
            {

                level.tornadoFX = loadfx( "fx/smoke/smoke_trail_black_heli" );
                break;

            }

        wait .03;

    }

}

TornadoWatchPlayers()
{

    self endon("disconnect");

    wait 1;
    while( isDefined( level.TornadoSpawned ) && !isDefined( level.TornadoNuked ) )
    {

        if( Distance( level.TornadoParts[ 0 ].origin, self.origin ) <= 175 && !isDefined( level.TornadoIgnorePlayers ) )
        {

            for( i = 1; i < level.TornadoParts.size; i++ )
            {

                self PlayerLinkTo( level.TornadoParts[ i ], "tag_origin" );
                wait .05;

            }

            self Unlink();
            self SetVelocity( ( 450, 450, 850 ) );

        }

        wait .01;

    }

}

TornadoWatchEntities()
{

    self endon( "disconnect" );

    wait 1;

    while( isDefined( level.TornadoSpawned ) && !isDefined( level.TornadoNuked ) )
    {

        if( Distance( level.TornadoParts[ 0 ].origin, self.origin ) <= 175 && !isDefined( level.TornadoIgnoreEntities ) )
        {

            for( i = 1; i < level.TornadoParts.size; i++ )
            {

                self.origin = level.TornadoParts[ i ].origin;
                wait .05;

            }

            linker = spawnSM( self.origin,"tag_origin" );
            self LinkTo( linker );
            linker PhysicsLaunchServer( linker.origin, AnglesToForward( self.angles ) * 15000 );
            wait 9;
            linker delete();

        }

        wait .01;

    }

}

RotateTornadoYaw( inc, time )
{

    self endon( "disconnect" );

    while( isDefined( self ) && !isDefined( level.TornadoNuked ) )
    {

        self RotateYaw( inc, time );
        wait time;

    }

}


//Artillery Cannon
artillery_verify()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self endon("death");
        self thread artillery();

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

artillery()
{

    center = spawn( "script_origin", bullettrace( self gettagorigin( "j_head" ), self gettagorigin( "j_head" ) + anglestoforward( self getplayerangles() ) * 20000000, 0, self )[ "position" ] );
    org = center.origin;
    level.artillery = [];
    level.artillery[0] = cbox( org + ( 41.25, 0, 0 ));
    level.artillery[1] = cbox( org + ( 96.25, 0, 0 ));
    level.artillery[2] = cbox( org + ( -41.25, 0, 0 ));
    level.artillery[3] = cbox( org + ( -96.25, 0, 0 ));
    level.artillery[4] = cbox( org + ( 0, 41.25, 0 ));
    level.artillery[5] = cbox( org + ( 0, 96.25, 0 ));
    level.artillery[6] = cbox( org + ( 0, -41.25, 0 ));
    level.artillery[7] = cbox( org + ( 0, -96.25, 0 ));
    level.swivel = [];
    level.swivel[0] = cbox( org - ( 0, 0, 14 ) );
    level.swivel[0].angles = ( 90, 0, 0 );
    level.swivel[1] = cbox( org + ( 0, 0, 28 ) );
    level.swivel[2] = cbox( org + ( 41.25, 0, 69 ) );
    level.swivel[2].angles = ( 90, 0, 0 );
    level.swivel[3] = cbox( org + ( -41.25, 0, 69 ) );
    level.swivel[3].angles = ( -90, 0, 0 );
    level.swivel[4] = cbox( org + ( -41.25, 0, 29 ) );
    level.swivel[4].angles = ( 0, 90, 0);
    level.swivel[5] = cbox( org + ( 41.25, 0, 29 ) );
    level.swivel[5].angles = ( 0, -90, 0 );
    level.swivel[6] = cbox( org + ( -41.25, 0, 110 ) );
    level.swivel[6].angles = ( 0, 90, 0 );
    level.swivel[7] = cbox( org + ( 41.25, 0, 110 ) );
    level.swivel[7].angles = ( 0, -90, 0 );
    level.barrel = [];

    for( i=0; i <= 6; i++ )
    {
        level.barrel[i] = cbox( org + ( 0, i * 55 - 110, 110 ) );
        level.barrel[i].angles = ( 0, 90, 0 );
    }

    level.barrel[7] = cbox( org + ( 0, 0, 109.99 ) );

    for( i=4; i <= 7; i++ )
        level.artillery[i].angles = ( 0, 90, 0 );
        level.gunpos = spawn( "script_origin", org + ( 0, 245, 110 ) );
        level.gunpos.angles = ( 0, 90, 0 );
        level.pitch = spawn( "script_origin", org + ( 0, 0, 110 ) );

    foreach( barrel in level.barrel )
        barrel linkto( level.pitch );
        level.gunpos linkto( level.pitch );
        level.turn = spawn( "script_origin", org );

    foreach( swivel in level.swivel )
        swivel linkto( level.turn );

    level.turn linkto( level.pitch );
    level.computer = cbox( org + ( -165, -165, 14 ) );
    level.computer.angles = ( 0, -45, 0 );
    level.pc = spawn( "script_model", level.computer.origin + ( 0, 0, 14 ) );
    level.pc setModel( "com_laptop_2_open" );
    level.pc.angles = ( 0, -135, 0 );
    level.pctrig = spawn( "trigger_radius", level.computer.origin, 0, 70, 70 );
    level.pctrig thread managepc();

}

cbox( location )
{

    box = spawn( "script_model", location );
    box setModel( "com_plasticcase_enemy" );
    box CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
    return box;

}

managepc()
{

    player = "fsf";
    use = "[{+activate}]";
    for(;;)
    {

        player clearlowermessage( "artillery" );
        pressed = 0;
        self waittill( "trigger", player );
        player setlowermessage( "artillery", "Push ^3[{+frag}]^7 or ^3[{+smoke}]^7 to change pitch\nPush ^3"+use+"^7 or ^3[{+melee}]^7 to turn\n Push ^3[{+attack}]^7 or ^3[{+speed_throw}]^7 to ^1FIRE" );
        if( !pressed )
        while( player fragbuttonpressed() )
        {

            pressed = 1;
            level.turn unlink();
            if( level.pitch.angles[2] <= 37.5 )
            level.pitch rotateto( level.pitch.angles + ( 0, 0, 2 ), 0.2 );
            wait 0.2;

        }
        if( !pressed )
        while( player secondaryoffhandbuttonpressed() )
        {

            pressed = 1;
            level.turn unlink();
            if( level.pitch.angles[2] >= -22 )
            level.pitch rotateto( level.pitch.angles - ( 0, 0, 2 ), 0.2 );
            wait 0.2;

        }
        if( !pressed )
        while( player meleebuttonpressed() )
        {

            pressed = 1;
            level.pitch rotateto( level.pitch.angles - ( 0, 2, 0 ), 0.2 );
            wait 0.2;

        }
        if( !pressed )
        while( player usebuttonpressed() )
        {

            pressed = 1;
            level.pitch rotateto( level.pitch.angles + ( 0, 2, 0 ), 0.2 );
            wait 0.2;

        }
        if( !pressed )
        while( player attackbuttonpressed() )
        {

            pressed = 1;
            magicbullet( "m79_mp", level.gunpos.origin, level.gunpos.origin + anglestoforward( level.gunpos.angles ) * 10000 );
            wait 0.5;

        }
        if( !pressed )
        while( player adsbuttonpressed() )
        {

            pressed = 1;
            magicbullet( "ac130_105mm_mp", level.gunpos.origin, level.gunpos.origin + anglestoforward( level.gunpos.angles ) * 10000 );
            earthquake( 0.5, 0.75, level.turn.origin, 800 );
            player playSound( "exp_airstrike_bomb" );
            playfx(level.chopper_fx["explode"]["medium"], level.gunpos.origin);
            for( i=0; i <= 6; i++ )
            {

                level.barrel[i] unlink();
                level.barrel[i] moveto( level.barrel[i].origin - anglestoforward( level.barrel[i].angles ) * 50, 0.05 );

            }

            wait 0.1;
            for( i=0; i <= 6; i++ )
            level.barrel[i] moveto( level.barrel[i].origin - anglestoforward( level.barrel[i].angles) * - 50, 0.5, 0.4, 0.1 );
            wait 2;

        }

        foreach( swivel in level.swivel )
        swivel linkto( level.turn );
        level.turn linkto( level.pitch );
        foreach( barrel in level.barrel )
        barrel linkto( level.pitch );
        wait 0.05;

    }

}


//Spawn Trampoline
trampoline()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self iprintln( "Press ^2[{+attack}]^7 to Spawn a Trampoline" );
        self endon( "disconnect");
        self waittill( "weapon_fired");
        start = self gettagorigin( "tag_eye" );
        end = anglestoforward( self getPlayerAngles() ) * 1000000;
        spawnPosition = BulletTrace( start, end, true, self )[ "position" ];
        level.tramp = spawn( "script_model", spawnPosition );
        level.tramp setModel( "com_plasticcase_enemy" );
        for(;;)
        {

            if( distance( self.origin, level.tramp.origin ) <= 100)
                self setVelocity( self getVelocity() + ( 0, 0, 400 ) );
            wait .1;

        }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

////////////////////////////////////////////////////////////////////////////////////////
//Testing
////////////////////////////////////////////////////////////////////////////////////////

//Destroy Ferris Wheel
destroyFerris()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        if( isDefined( level.Ferris_Wheel ) )
        {

            level.ferrisTrig delete();
            level.FerrisAttach delete();
            level.FerrisLink delete();

            self thread Array_Physics( level.FerrisLegs );
            self thread Array_Physics( level.FerrisSeats );
            self thread Array_Physics( level.Ferris );

            level.Ferris_Wheel = undefined;
            level notify( "Destroy_Ferris" );

        }
        else

            self iprintln( "Ferris Wheel Has Not Been Spawned." );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

//Ferris Wheel
verifyFerris()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self thread Spawn_Ferriswheel();

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

Spawn_Ferriswheel()
{

    level endon("Destroy_Ferris");
    level.ferrisOrg = self.origin;
    level.speed = 0;
 
    level.FerrisLegs = [];
    level.FerrisSeats = [];
    level.Ferris = [];
    level.Ferris_Wheel = true;

    level.FerrisAttach = modelSpawner(level.ferrisOrg + (0,0,420), "tag_origin");
    level.FerrisLink = modelSpawner(level.ferrisOrg + (0,0,60), "tag_origin");
    for(a=0;a<2;a++) for(e=0;e<30;e++)
        level.Ferris[level.Ferris.size] = modelSpawner(level.ferrisOrg + (-50+a*100,0,420) + (0,sin(e*12)*330, cos(e*12)*330), "com_plasticcase_friendly", (0,0,e*-12),.1);
    for(a=0;a<2;a++) for(b=0;b<5;b++) for(e=0;e<15;e++)
        level.Ferris[level.Ferris.size] = modelSpawner(level.ferrisOrg + (-50+a*100,0,420) + (0,sin(e*24)*40+b*65, cos(e*24)*40+b*65), "com_plasticcase_friendly", (0,0,(e*-24)-90),.1);
    for(e=0;e<15;e++)
        level.FerrisSeats[level.FerrisSeats.size] = modelSpawner(level.ferrisOrg + (0,0,420) + (0,sin(e*24)*330, cos(e*24)*330), "com_plasticcase_enemy",(e*24,90,0),.1);
    for(e=0;e<3;e++)
        level.FerrisLegs[level.FerrisLegs.size] = modelSpawner(level.ferrisOrg + (82-e*82,0,420),"com_plasticcase_friendly",(0,90,0),.1);
    for(e=0;e<2;e++) for(a=0;a<8;a++)
        level.FerrisLegs[level.FerrisLegs.size] = modelSpawner(level.ferrisOrg + (-100+e*200,-220,0) + (0,a*28,a*60),"com_plasticcase_friendly",(0,0,65),.1);
    for(e=0;e<2;e++) for(a=0;a<8;a++)
        level.FerrisLegs[level.FerrisLegs.size] = modelSpawner(level.ferrisOrg + (-100+e*200,220,0) + (0,a*-28,a*60),"com_plasticcase_friendly",(0,0,-65),.1);
 
    foreach(model in level.Ferris)
        model linkTo(level.FerrisAttach);
    foreach(model in level.FerrisSeats)
        model linkTo(level.FerrisAttach);
    
    iprintln("^:Press [{+activate}] on red crate to ride");
    iprintln("^:Press [{+frag}] to exit ride");

    level.FerrisAttach thread ferrisRotate(1);
    level.FerrisLink checkRidersFerris(level.FerrisSeats);
}

ferrisRotate(speed)
{
    self thread doFerrisRotate(speed);
}

resetFerrisSpeed()
{
    level.speed = 0;
    self thread doFerrisRotate(1);
}

doFerrisRotate(speed)
{
    level endon("Destroy_Ferris");
    level.speed += speed;
    if(level.speed >= 15)
        level.speed = 15;
    if(level.speed <= -15)
        level.speed = -15;
    while(true)
    {
        for(a=0;a<360;a+=level.speed)
        {
            self rotateTo((0,self.angles[1],a),.2);
            wait .05;
        }
        for(a=360;a<0;a-=level.speed)
        {
            self rotateTo((0,self.angles[1],a),.2);
            wait .05;
        }
        wait .05;
    }
}

checkRidersFerris(Array)
{
    level endon("Destroy_Ferris");
    level.ferrisTrig = spawnTrig(self.origin,250,40,"HINT_NOICON","Press &&1 to Enter / Exit The Ferris Wheel!");
    while(isDefined(self))
    {
        level.ferrisTrig waittill("trigger",i);
        if(!isDefined(i.riding) && isPlayer(i) && i useButtonPressed())
        {
            Closest = getClosest(i.origin,Array);
            Seat = modelSpawner(Closest.origin-anglesToRight(self.angles)*22,"script_origin",(0,90,0));
            Seat thread seatAngleFix(Closest);
            if(!isDefined(Closest.FerrisOccupied))
            {
                i setStance("crouch");
                i.ridingFerris = true;
                i PlayerLinkToDelta(Seat);
                i thread playerExitFerry(Closest,Seat);
                Closest.FerrisOccupied = true;
            }
        }
    }
}

seatAngleFix(seat)
{
    while(true)
    {
        for(a=0;a<360;a+=level.speed)
        {
            self.angles = (0,90,0);
            self MoveTo(seat.origin+(0,0,10),.1);
            wait .05;
        }
        wait .05;
    }
}

playerExitFerry(Seat,tag)
{
    while(isDefined(level.Ferris_Wheel))
    {
        if(self fragButtonPressed()) break;
        wait .05;
    }
    tag unLink();
    tag delete();
    self.ridingFerris = undefined;
    Seat.FerrisOccupied = undefined;
    self unlink();
}



//Destroy Centrox
destroyCentrox()
{
    
    if( self.access == "Host" || self.access == "Admin" )
    {

        if( isDefined( level.Centrox_Ride ) )
        {

            level.Movements delete();

            self thread Array_Physics( level.Centrox );
            self thread Array_Physics( level.Seats );
            self thread Array_Physics( level.Center );

            level.Centrox_Ride = undefined;
            level notify("Stop_Centrox");

        }
        else

            self iprintln( "Centrox Has Not Been Spawned." );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

//Centrox Ride
Centrox_Verify()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self thread Spawn_Centrox();

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

Spawn_Centrox()
{

    level endon("Stop_Centrox");

    level.Centrox = [];
    level.Seats = [];
    level.Center = [];
    level.Centrox_Ride = true;

    level.Movements = modelSpawner(self.origin + (40,0,20), "tag_origin");
    time = .1;
    for(e = 0; e < 2; e++)
        for(i = 0; i < 6; i++)
            level.Center[level.Center.size] = modelSpawner(level.Movements.origin + (cos(i*60)*20,sin(i*60)*20, e*70), "com_plasticcase_friendly", (0,(i*60)+90,90), time);//Center
    for(i = 0; i < 15; i++)
        level.Centrox[level.Centrox.size] = modelSpawner(level.Movements.origin + (cos(i*24)*70,sin(i*24)*70, -20), "com_plasticcase_friendly", (0,(i*24)+90,0), time);//floor inner
    for(i = 0; i < 25; i++)
        level.Centrox[level.Centrox.size] = modelSpawner(level.Movements.origin + (cos(i*14.4)*140,sin(i*14.4)*140, -20), "com_plasticcase_friendly", (0,(i*14.4)+90,0), time);//floor outer
    for(i = 0; i < 30; i++)
        level.Centrox[level.Centrox.size] = modelSpawner(level.Movements.origin + (cos(i*12)*185,sin(i*12)*185, 30), "com_plasticcase_friendly", (0,(i*12)+90,90), time);//Wall
    for(i = 0; i < 10; i++)
        level.Centrox[level.Centrox.size] = modelSpawner(level.Movements.origin + (cos(i*36)*178,sin(i*36)*178, 30), "com_plasticcase_enemy", (0,(i*36)+90,90), time);//Seats Visual
    for(i = 0; i < 10; i++)
        level.Seats[level.Seats.size] = modelSpawner(level.Movements.origin + (0,0,-40) + (cos(i*36)*165,sin(i*36)*165, 30), "com_plasticcase_enemy", (0,(i*36)+180,0));//Seats
 
    level.Centrox[68] MoveTo(level.Centrox[67].origin, .3);//Doors Open
    level.Centrox[69] MoveTo(level.Centrox[40].origin, .3);//Doors Open
    
    iprintln("Press [{+activate}] on a red crate to ride!");
    iprintln("Takes a few seconds to start once seated!");

    level.Movements thread monitorPlayersCentrox(level.Seats);
 
    wait 5;
    level.Movements thread Monitor_Centrox();
    level.Movements thread Spin_Centrox();
}

Monitor_Centrox()
{
    level endon("Stop_Centrox");
    while(isDefined(self))
    {
        wait 10;
        level.RideActive = true;
        level.Centrox[68] MoveTo(level.Centrox[67].origin+(13,40,0), .3);
        level.Centrox[69] MoveTo(level.Centrox[40].origin+(-13,-40,0), .3);
        wait 3;
        foreach(model in level.Centrox)
            model LinkTo(level.Movements);
        foreach(model in level.Seats)
            model LinkTo(level.Movements);
   
        for(Ext = 0; Ext < 22; Ext += 2)
        {
            self MoveTo((self.origin[0],self.origin[1],self.origin[2]+Ext),.7);
            wait .6;
        }
        wait 8;
        for(e = 0; e < 2; e++)
        {
            for(Ext = 0; Ext < 40; Ext++)
            {
                self RotateRoll(Ext*0.1, .7);
                wait .1;
            }
            wait 5;
        }
        wait 8;
        for(e = 0; e < 2; e++)
        {
            for(Ext = 0; Ext < 40; Ext++)
            {
                self RotateRoll(0-Ext*0.1, .7);
                wait .1;
            }
            wait 8;
        }
        level.RideActive = undefined;
        for(Ext = 0; Ext < 22; Ext += 2)
        {
            self MoveTo((self.origin[0],self.origin[1],self.origin[2]-Ext),.7);
            wait .6;
        }
        foreach(model in level.Seats)
            model unlink();
        foreach(model in level.Centrox)
            model Unlink();
        wait .3;
        level.Centrox[68] MoveTo(level.Centrox[67].origin, .3);
        level.Centrox[69] MoveTo(level.Centrox[40].origin, .3);
        foreach(rider in level.players)
            rider unlink();
        for(e = 0; e < 10; e++)
            level.seatTaken[e] = undefined;
        wait .05;
    }
}

Spin_Centrox()
{
    level endon("Stop_Centrox");
    Speed = 0;
    for(;;)
    {
        while(isDefined(self) && isDefined(level.RideActive))
        {
            self RotateYaw(Speed*0.4, .9);
            Speed++;
            wait .1;
        }
        Speed = 0;
        wait .05;
    }
}

monitorPlayersCentrox(Array)
{
    level endon("Stop_Centrox");
    level.CentroxTrig = spawnTrig(self.origin,250,40,"HINT_NOICON","Press &&1 to Enter / Exit The Centrox!");
    while(isDefined(self))
    {
        level.CentroxTrig waittill("trigger",i);
        if(i useButtonPressed() && !i.riding)
        {
            closest = getClosest(i.origin,Array);
            if(!closest.occupied)
            {
                i setStance("stand");
                i.ridingCentox = true;
                i PlayerLinkToAbsolute(closest);
                i thread playerExitCentrox(closest);
                closest.CentroxOccupied = true;
            }
        }
    }
}

playerExitCentrox(seat)
{
    level endon("Stop_Centrox");
    self endon("death");
    self endon("disconnect");
    wait 1.5;
    while(isDefined(seat))
    {
        if(self useButtonPressed() && !isDefined(level.RideActive))
            break;
        wait .05;
    }
    seat.CentroxOccupied = undefined;
    self setStance("stand");
    self unlink();
    wait 1.5;
    self.ridingCentox = undefined;
}

//Twister Ride
Twister_Verify()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self thread buildTwister();

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

buildTwister() 
{

    level.skyBaseIsBuilding = true;
    pos = self.origin + ( 0, 0, 15 );
    level.TwistSeatsAttach = [];
    level.TwistSeats = [];
    level.CenterLink = spawnSM(pos, "tag_origin");
    level.CenterLink skyBaseArray(true);
    model = "com_plasticcase_friendly";
    time = .01;
    level.bog = [];
    for(a=0;a<11;a++)for(b=0;b<6;b++)level.bog[level.bog.size] = spawnSM(pos + (0, 0, a * 27), model, (0, b * 51.43, 0), time);
    for(a=0;a<4;a++)for(b=0;b<2;b++)for(c=0;c<3;c++)level.bog[level.bog.size] = spawnSM(pos + (sin(a * 90) * (c * 57 + 50), cos(a * 90) * (c * 57 + 50), 125), model, (0, 90 + a * 90 + b * 180, 0), time);
    for(a=0;a<4;a++)for(b=0;b<2;b++)for(c=0;c<3;c++)level.bog[level.bog.size] = spawnSM(pos + (sin(a * 90 + 45) * (c * 57 + 50), cos(a * 90 + 45) * (c * 57 + 50), 270), model, (0, 45 + a * 90 + b * 180, 0), time);
    array_thread(level.bog, ::twisterArray, level.CenterLink);
    level.rows = [];
    for(a=0;a<4;a++)level.rows[level.rows.size] = spawnSM(pos + (sin(a * 90) * (3 * 57 + 35), cos(a * 90) * (3 * 57 + 35), 111), model, (90, 90 + a * 90, 0), time);
    for(a=0;a<4;a++)level.rows[level.rows.size] = spawnSM(pos + (sin(a * 90 + 45) * (3 * 57 + 35), cos(a * 90 + 45) * (3 * 57 + 35), 256), model, (90, 45 + a * 90, 0), time);
    array_thread(level.rows, ::skyBaseArray, true);
    level.ss = [];
    for(a=0;a<4;a++)for(b=0;b<3;b+=2)level.ss[level.ss.size] = spawnSM(level.rows[a].origin + (0, cos(b * 90) * (35), -50), model, (17 + b * 163, 90, 0), time);
    for(a=0;a<4;a++)for(b=1;b<4;b+=2)level.ss[level.ss.size] = spawnSM(level.rows[a].origin + (sin(b * 90) * (35), 0, -50), model, (343 + (b - 1) * -163, 180, 0), time);
    num = 0;
    count = 0;
    for(a=0;a<level.ss.size;a++)
    {
        level.ss[a] thread twisterArray(level.rows[num]);
        if(count == 1) 
        {
            num++;
            count = -1;
        }
        if(num > 3)num = 0;
        count++;
    }
    level.ss = [];
    for(a=0;a<4;a++)for(b=0;b<3;b+=2)level.ss[level.ss.size] = spawnSM(level.rows[a + 4].origin + (sin(b * 90 + 45) * (35), cos(b * 90 + 45) * (35), -50), model, (17 + b * 163, 45, 0), time);
    for(a=0;a<4;a++)for(b=1;b<4;b+=2)level.ss[level.ss.size] = spawnSM(level.rows[a + 4].origin + (sin(b * 90 + 45) * (35), cos(b * 90 + 45) * (35), -50), model, (343 + (b - 1) * -163, 135, 0), time);
    num = 4;
    count = 0;
    for(a=0;a<level.ss.size;a++)
    {
        level.ss[a] thread twisterArray(level.rows[num]);
        if(count == 1)
        {
            num++;
            count = -1;
        }
        if(num>7)num = 4;
        count++;
    }
    for(a=0;a<4;a++)
    {
        for(b=0;b<8;b++)
        {
            level.TwistSeats[a] = spawnSM(level.rows[a].origin + (sin(b * 45) * (77), cos(b * 45) * (77), -58), model, (0, 315 * b, 0), time);
            level.TwistSeatsAttach[level.TwistSeatsAttach.size] = spawnSM(level.TwistSeats[a].origin + (sin(b * 90) * (22), cos(b * 90) * (22), 0), "tag_origin", undefined, time);
            level.TwistSeats[a] thread twisterArray(level.rows[a]);
            level.TwistSeatsAttach[level.TwistSeatsAttach.size - 1] thread twisterArray(level.rows[a], true);
        }
    }
    for(a=0;a<4;a++)
    {
        for(b=0;b<8;b++)
        {
            level.TwistSeats[a+4] = spawnSM(level.rows[a + 4].origin + (sin(b * 45) * (77), cos(b * 45) * (77), -58), model, (0, 315 * b, 0), time);
            level.TwistSeatsAttach[level.TwistSeatsAttach.size] = spawnSM(level.TwistSeats[a + 4].origin + (sin(b * 90 + 45) * (22), cos(b * 90 + 45) * (22), 0), "tag_origin", undefined, time);
            level.TwistSeats[a+4] thread twisterArray(level.rows[a + 4]);
            level.TwistSeatsAttach[level.TwistSeatsAttach.size - 1] thread twisterArray(level.rows[a + 4], true);
        }
    }
    level.top = spawnSM(pos + (0, 0, 280), "test_sphere_silver", undefined, time);
    level.tag = spawnSM(level.top.origin, "tag_origin", undefined, time);
    level.top skyBaseArray(true);
    level.tag skyBaseArray(true);
    level.top thread twisterArray(level.CenterLink);
    level.TwistSeatsAttach thread checkTwister(pos, level.TwistSeatsAttach);
    for(a=0;a<4;a++)
    {
        level.rows[a] thread orbiting(pos, a * 90, 111);
        level.rows[a + 4] thread orbiting(pos, a * 90 + 45, 256);
        level.rows[a] thread RotateEntYaw(-360, 3);
        level.rows[a + 4] thread RotateEntYaw(-360, 3);
    }
    level.CenterLink thread RotateEntYaw(360, 4);
    level.notifyIcon = textMarker(undefined, level.top.origin, "The Twister", false, "RAIN");
    level.notifyIcon setTargetEnt(level.tag);
    wait .05;
    level.skyBaseIsBuilding = undefined;
}

twisterArray(link, bool) 
{
    self skyBaseArray(bool);
    self linkTo(link);
}

checkTwister(area, Seat) 
{
    level endon("SKYBASE_FAIL");
    triger = spawnTrigger(area, 80, 80, "HINT_NOICON", "");
    triger skyBaseArray(true);
    
    while (true) 
    {
        triger waittill("trigger", i);
        if(!isDefined(i.riding) && isPlayer(i) && isDefined(i.SpawnableTrig))i.SpawnableTrig destroy();
        if(!isDefined(i.riding) && isPlayer(i)) 
        {
            row = randomIntRange(0, 64);
            if (!isDefined(Seat[row].Occupied)) 
            {
                i allowSprint(false);
                i setStance("crouch");
                i.riding = true;
                i PlayerLinkTo(Seat[row]);
                i.SpawnableTrig = i TriggerText("Press [{+frag}] to Exit The Twister");
                Seat[row].Occupied = true;
                i thread playerExitTwist(Seat[row],i);
            }
        }
        wait .01;
    }
}

playerExitTwist(Seat,player) 
{
    level endon("SKYBASE_FAIL");
    while (isDefined(Seat)) 
    {
        if (self fragButtonPressed()) break;
        wait .05;
    }
    if(isDefined(player.SpawnableTrig))player.SpawnableTrig destroy();
    self allowSprint(true);
    self.riding = undefined;
    Seat.Occupied = undefined;
    self unlink();
    self setStance("stand");
}

orbiting(pos, int, z) 
{
    level endon("SKYBASE_FAIL");
    
    while(true)
    {
        for(a=int-4.5;a<370;a-=9) 
        {
            loc = (pos + (sin(a) * 200, cos(a) * 200, z));
            self moveTo(loc, .1);
            wait .09;
        }
        wait .01;
    }
}



//Roller Coaster
Coaster_Verify()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self thread rollerCoaster();

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}
rollerCoaster()
{
    if( !isDefined( level.coaster ) && !isDefined( level.bigSpawn ) )
    {
        level.bigSpawn = true;
        level.coaster = true;
        iprintln("^1Won't finish building on larger maps! (ent limit)");
        iprintln("^1Activate roller coaster again to delete!");
        hostPlayer() thread buildCoaster();
    }
    if (isDefined(level.coaster) && isDefined(level.bigSpawn))
    {
        if(isDefined(level.skyBaseIsBuilding))return;
        level notify("SKYBASE_DELETED");
        level notify("SKYBASE_FAIL");
        self iprintln( "^1Roller Coaster destroyed!" );
        level thread deleteSkyBase();
        level thread deleteIcon();
        for(a=0;a<getPlayers().size;a++)
        {
            player = getPlayers()[a];
            if(isDefined(player.riding))
            {
                if(isDefined(player.SpawnableTrig))player.SpawnableTrig destroy();
                player unLink();
                player allowSprint(true);
                player.riding = undefined;
            }
        }
        level.coaster = undefined;
        level.bigSpawn = undefined;
    }
}

buildCoaster()
{

    level endon("Coaster_End");

    level.skyBaseIsBuilding = true;
    level.Roller_Coaster = true;
    
    model = "test_sphere_silver";

    self iPrintln("^:Press [{+activate}] on the platform to ride");
    self iPrintln("^:Press [{+frag}] to exit");
    
    level.org = self.origin;
    level.rail = [];
    level.floor = [];
    level.seat = [];
    
    //DONE
    for(a=0;a<4;a++)level.rail[level.rail.size] = spawnSM(level.org+(-50,22-(a*44),15),model,(0,90,0),.01);
    for(a=0;a<17;a++)level.rail[level.rail.size] = spawnSM(level.rail[3].origin+(0,sin(184+(a*4))*625,cos(184+(a*4))*625+624), model,(4+(a*4),90,0),.01);
    for(a=1;a<35;a++)level.rail[level.rail.size] = spawnSM(level.rail[20].origin+(0,sin(338)*(a*44),cos(338)*(a*44)),model,(68,90,0),.01);
    for(a=0;a<17;a++)level.rail[level.rail.size] = spawnSM(level.rail[54].origin+(0,sin(64-(a*4))*625-579,cos(64-(a*4))*625-235),"test_sphere_silver",(level.rail[level.rail.size-1].angles[0]-4,90,0),.01);
    //CURRENT
    for(a=0;a<109;a++)level.rail[level.rail.size] = spawnSM(level.rail[70].origin+(sin(90+(a*5))*491-491,cos(90+(a*5))*491-87,cos(90-(a*1))*(a*2)+1.5),model,(level.rail[level.rail.size-1].angles[0]+.035,90-(a*5),0),.01);
    
    
    //NOT DONE
    for(a=0;a<10;a++)level.rail[level.rail.size] = spawnSM(level.rail[180].origin+(sin(0)*(a*44),cos(0)*(a*44)+44,0),model,(90,90,0),.01);
    for(a=0;a<17;a++)level.rail[level.rail.size] = spawnSM(level.rail[190].origin+(0,sin(4+(a*4))*625,cos(4+a*4)*625-625),model,(86-(a*4),90,0),.01);
    for(a=0;a<25;a++)level.rail[level.rail.size] = spawnSM(level.rail[207].origin+(0,sin(158)*(a*44)+16,cos(158)*(a*44)-40),model,(22,90,0),.01);
    for(a=0;a<17;a++)level.rail[level.rail.size] = spawnSM(level.rail[232].origin+(0,sin(244-(a*4))*625+580,cos(244-(a*4))*625+236),model,(26+(a*4),90,0),.01);
    for(a=0;a<91;a++)level.rail[level.rail.size] = spawnSM(level.rail[249].origin+(sin(180-(a*1))*(a*1),sin(180-(a*4))*625+44,cos(180-(a*4))*625+625),model,(90+(a*4),-.5-(a*.001),0),.01);
    for(a=0;a<15;a++)level.rail[level.rail.size] = spawnSM(level.rail[340].origin+(sin(1)*(a*44),cos(1)*(a*44)+44,0),model,(90,90,0),.01);
    for(a=0;a<38;a++)level.rail[level.rail.size] = spawnSM(level.rail[355].origin+(sin(270+(a*5))*491+491,cos(270+(a*5))*491+44,0),model,(90,-1-(a*5),0), .01);
    for(a=0;a<5;a++)level.rail[level.rail.size] = spawnSM(level.rail[393].origin+(-3*(a+1),sin(184+(a*4))*621,cos(184+(a*4))*621+621),model,(266-(a*4),-4,0),.01);
    
    for(a=0;a<level.rail.size;a++)level.rail[a] skyBaseArray();
    level.attacher = spawnSM(level.rail[0].origin, "test_sphere_redchrome");
    level.attacher skyBaseArray();
    for(a=0;a<4;a++)level.floor[level.floor.size] = spawnSM(level.org + (-50, 70 - a * 24, 35), "com_plasticcase_enemy", (0, 0, 180), .01);
    for(a=0;a<2;a++)level.floor[level.floor.size] = spawnSM(level.rail[0].origin + (45 - a * 90, 0, 20), "com_plasticcase_enemy", (0, 90 + a * 180, 90), .01);
    for(a=0;a<2;a++)level.floor[level.floor.size] = spawnSM(level.floor[3].origin + (0, sin(20) * (a * 24) - 24, cos(20) * (a * 24)), "com_plasticcase_enemy", (0, 0, 70), .01);
    for(a=0;a<2;a++)level.floor[level.floor.size] = spawnSM(level.floor[3].origin + (0, -3, 5), "com_plasticcase_enemy", (90 + a * 180, 0, 0), .01);
    level.back = spawnSM(level.floor[0].origin, "com_plasticcase_enemy", (0, 180, 180), .01);
    level.back skyBaseArray();
    for(a=0;a<level.floor.size;a++)level.floor[a] thread twisterArray(level.attacher);
    for(a=0;a<2;a++)
    {
        level.seat[a] = spawnSM(level.org + (-39 - a * 22, 18, 39), "script_origin", (0, 270, 0));
        level.seat[a] twisterArray(level.attacher);
    }
    level endon("SKYBASE_FAIL");
    level thread cartWatch(level.seat, level.attacher);
    wait .05;
    level.skyBaseIsBuilding = undefined;
    level waittill("Roller_Coaster_Countdown");
    level rollerCountDown(level.seat);
    level.back rotateTo((0, 180, 90), .5);
    wait .5;
    level.back linkTo(level.attacher);
    while(true)
    {
        for(a=1;a<4;a++)
        {
            level.attacher moveTo(level.rail[a].origin, .25);
            earthquake(.1, 1, level.rail[a].origin, 150);
            wait .2;
        }
        for(a=4;a<21;a++)
        {
            level.attacher moveTo(level.rail[a].origin, .25);
            level.attacher rotateTo((0, 0, -4 - (a - 4) * 4), .25);
            earthquake(.15, .5, level.rail[a].origin, 100);
            wait .2;
        }
        for(a=21;a<55;a++)
        {
            level.attacher moveTo(level.rail[a].origin, .25);
            earthquake(.15, .5, level.rail[a].origin, 100);
            wait .2;
        }
        if(!isDefined(level.attacher.mode))
        {
            level.attacher.mode = true;
            for(a=250;a<295;a++)
            {
                level.attacher moveTo(level.rail[a].origin, .08);
                level.attacher rotateTo((0 + (a - 249) * 8, -180, 0), .08);
                if(a>252 && a<=272)level.attacher rotateTo((0 + (a - 250) * 8.21, -180, 0 + (a - 253) * 4), .08);
                if(a>272)level.attacher rotateTo((180, -180, 76 + (a - 273) * 4.727), .08);
                earthquake(.2, 1, level.rail[a].origin, 150);
                wait .05;
            }
            for(a=295;a<341;a++)
            {
                level.attacher moveTo(level.rail[a].origin, .08);
                level.attacher rotateTo((180 - (a - 294) * 8, -180, 180), .08);
                if(a>297 && a<=317)level.attacher rotateTo((180 - (a - 295) * 8.21, -180, 180 - (a - 298) * 4), .08);
                if(a>317)level.attacher rotateTo((0, -180, 104 - (a - 318) * 4.727), .08);
                earthquake(.2, 1, level.rail[a].origin, 150);
                wait .05;
            }
        }
        else
        {
            level.attacher.mode = undefined;
            for(a=250;a<341;a++)
            {
                level.attacher moveTo(level.rail[a].origin, .08);
                level.attacher rotateTo((0, -180.5 - (a - 250) * .001, 0 - (a - 250) * 4), .08);
                earthquake(.15, 1, level.rail[a].origin, 150);
                wait .05;
            }
        }
        for(a=341;a<356;a++)
        {
            level.attacher moveTo(level.rail[a].origin, .08);
            level.attacher rotateTo((0, -180, 0), .08);
            earthquake(.2, .5, level.rail[a].origin, 100);
            wait .05;
        }
        for(a=356;a<394;a++)
        {
            level.attacher moveTo(level.rail[a].origin, .08);
            level.attacher rotateTo((0, -181 - (a - 356) * 5, 0), .08);
            earthquake(.15, 1, level.rail[a].origin, 150);
            wait .05;
        }
        for(a=394;a<399;a++)
        {
            level.attacher moveTo(level.rail[a].origin, .08);
            level.attacher rotateTo((0, -4, -4 - (a - 394) * 4), .08);
            earthquake(.15, 1, level.rail[a].origin, 150);
            wait .05;
        }
        level.attacher rotateTo((0, 0, 0), 1);
        for(a=0;a<19;a++)
        {
            level.attacher moveTo(level.rail[398].origin + (-4.3 * (a + 1), sin(-16.5 - a * 3.3) * 775 + 145, cos(-16.5 - a * 3.3) * 775 - 735), .11);
            wait .06;
        }
        wait .05;
        level.attacher notify("Catch_A_Ride");
        earthquake(.8, 1.5, level.rail[0].origin, 200);
        wait .05;
    }
}

cartWatch(seat, tag) 
{
    level endon("SKYBASE_FAIL");
    level endon("Roller_Coaster_Started");

    trig = spawnTrigger(tag.origin, 150, 150);
    trig skyBaseArray(true);
    level thread coasterWaitForStart(trig, "Please Wait Until The Roller Coaster Passes to Catch a Ride!", seat, tag);
    
    while(true)
    {
        for(a=0;a<getPlayers().size;a++)
        {
            if(Distance(tag.origin, getPlayers()[a].origin) <= 150)
            {
                if(!getPlayers()[a].riding && isPlayer(getPlayers()[a]) && !isDefined(getPlayers()[a].SpawnableTrig))getPlayers()[a].SpawnableTrig = getPlayers()[a] setLowerMessage("Press [{+activate}] to Ride The Roller Coaster");
                if (!getPlayers()[a].riding && isPlayer(getPlayers()[a]) && getPlayers()[a] useButtonPressed()) 
                {
                    X = randomInt(seat.size);
                    if(isDefined(getPlayers()[a].SpawnableTrig))getPlayers()[a].SpawnableTrig SetSafeText1("Press [{+frag}] to Exit");
                    getPlayers()[a].riding = true;
                    getPlayers()[a] playerLinkToAbsolute(seat[X]);
                    getPlayers()[a] setStance("stand");
                    getPlayers()[a] thread playerExitCoaster(getPlayers()[a].riding,getPlayers()[a]);
                    level notify("Roller_Coaster_Countdown");
                }
            }
            else if(!getPlayers()[a].riding && isPlayer(getPlayers()[a]) && isDefined(getPlayers()[a].SpawnableTrig) && Distance(tag.origin, getPlayers()[a].origin) > 150)getPlayers()[a].SpawnableTrig destroy();
        }
        wait .05;
    }
}

coasterWaitForStart(trig, text, seat, tag)
{
    level endon("SKYBASE_FAIL");
    level waittill("Roller_Coaster_Countdown");
    
    wait 10;
    level thread CoasterStartWatch(trig,text);
    if(isDefined(tag)) trig thread startNewRoller(seat, tag);
}

CoasterStartWatch(trig,text)
{
    level endon("SKYBASE_FAIL");
    
    while(1)
    {
        for(a=0;a<getPlayers().size;a++)
        {
            if(Distance(trig.origin, getPlayers()[a].origin) <= 150 && isPlayer(getPlayers()[a]) && !getPlayers()[a].riding)
            {
                if(isDefined(getPlayers()[a].SpawnableTrig))getPlayers()[a].SpawnableTrig SetSafeText2(text);
                else getPlayers()[a].SpawnableTrig = getPlayers()[a] TriggerText(text);
            }
            else if(isDefined(getPlayers()[a].SpawnableTrig) && !getPlayers()[a].riding)getPlayers()[a].SpawnableTrig destroy();
        }
        wait .05;
    }
}

playerExitCoaster(arg,player) 
{
    level endon("SKYBASE_FAIL");
    while(isDefined(arg))
    {
        if(self fragButtonPressed())break;
        wait .05;
    }
    if(isDefined(player.SpawnableTrig))player.SpawnableTrig destroy();
    self.riding = undefined;
    self unlink();
    self setStance("stand");
}

rollerCountDown(seat) 
{
    level endon("SKYBASE_FAIL");
    for(a=3;a>0;a--)
    {
        earthquake(.5, 1, seat[0].origin - (11, 0, 0), 100);
        wait 1;
    }
    level notify("Roller_Coaster_Started");
}

startNewRoller(seat, attacher)
{
    level endon("SKYBASE_FAIL");
    
    while(true)
    {
        attacher waittill("Catch_A_Ride");
        self thread watchForPickup(seat);
        wait 1.5;
        level notify("Roller_Coaster_Pickup_Over");
    }
}

watchForPickup(seat) 
{
    level endon("SKYBASE_FAIL");
    level endon("Roller_Coaster_Pickup_Over");
    
    while(1)
    {
        for(a=0;a<getPlayers().size;a++)
        {
            if(Distance(self.origin, getPlayers()[a].origin) <= 150 && !getPlayers()[a].riding && isPlayer(getPlayers()[a]))
            {
                X = randomInt(seat.size);
                getPlayers()[a].riding = true;
                getPlayers()[a] playerLinkToAbsolute(seat[X]);
                getPlayers()[a] setStance("stand");
                getPlayers()[a] thread playerExitCoaster(getPlayers()[a].riding);
                if(isDefined(getPlayers()[a].SpawnableTrig))getPlayers()[a].SpawnableTrig SetSafeText2("Press [{+frag}] to Exit");
            }
        }
        wait .01;
    }
}



/*
BuildWeaponTest()
{

    base_name = maps\mp\_utility::getbaseweaponname( "h1_junsnp" );
    new_weapon = maps\mp\gametypes\_class::buildweaponname( "h1_junsnp" );
    maps\mp\_utility::_giveweapon( new_weapon );
    self switchtoweapon( new_weapon );

}

BuildWeaponCamoTest()
{
    weapon = self getcurrentweapon();
    new_weapon = maps\mp\gametypes\_class::buildweaponnamecamo( maps\mp\gametypes\_class::buildweaponname( maps\mp\_utility::getbaseweaponname( weapon ) ), <index> );
}

BuildWeaponCamoAttachmentTest()
{
    weapon = self getcurrentweapon();
    new_weapon = maps\mp\gametypes\_class::buildweaponnamecamo( maps\mp\gametypes\_class::buildweaponname( maps\mp\_utility::getbaseweaponname( weapon ), get_attachment( weapon ) ), <index> );

    get_attachment( weapon = self getcurrentweapon() )
    {
        att = getweaponattachments( weapon );
        for( i = 0; i < att.size; i++ )
            return ( att.size <= 1 ) ? att[ 0 ] : ( att[ 0 ] + "_" + att[ 1 ] );
    }
}
*/

give_player_weapon( selected, weapon )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        selected giveWeapon( weapon );
	    selected switchToWeapon( weapon );
	    self iprintln( "^:" + weapon + " ^2given to: " + "^7" + selected.name );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

give_player_killstreak( selected, killstreak )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        selected maps\mp\gametypes\_hardpoints::giveHardpoint( killstreak );
	    self iprintln( "^:" + killstreak + " ^2given to: " + "^7" + selected.name );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

give_player_perks( selected )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        selected maps\mp\_utility::giveperk( "specialty_longersprint", false );
	    selected maps\mp\_utility::giveperk( "specialty_fastmantle", false );
	    selected maps\mp\_utility::giveperk( "specialty_fastreload", false );
	    selected maps\mp\_utility::giveperk( "specialty_quickdraw", false );
	    selected maps\mp\_utility::giveperk( "specialty_scavenger", false );
	    selected maps\mp\_utility::giveperk( "specialty_extraammo", false );
	    selected maps\mp\_utility::giveperk( "specialty_bling", false );
	    selected maps\mp\_utility::giveperk( "specialty_secondarybling", false );
	    selected maps\mp\_utility::giveperk( "specialty_onemanarmy", false );
	    selected maps\mp\_utility::giveperk( "specialty_omaquickchange", false );
	    selected maps\mp\_utility::giveperk( "specialty_bulletdamage", false );
	    selected maps\mp\_utility::giveperk( "specialty_armorpiercing", false );
	    selected maps\mp\_utility::giveperk( "specialty_lightweight", false );
	    selected maps\mp\_utility::giveperk( "specialty_fastsprintrecovery", false );
	    selected maps\mp\_utility::giveperk( "specialty_hardline", false );
	    selected maps\mp\_utility::giveperk( "specialty_rollover", false );
	    selected maps\mp\_utility::giveperk( "specialty_radarimmune", false );
	    selected maps\mp\_utility::giveperk( "specialty_spygame", false );
	    selected maps\mp\_utility::giveperk( "specialty_explosivedamage", false );
	    selected maps\mp\_utility::giveperk( "specialty_dangerclose", false );
	    selected maps\mp\_utility::giveperk( "specialty_extendedmelee", false );
	    selected maps\mp\_utility::giveperk( "specialty_falldamage", false );
	    selected maps\mp\_utility::giveperk( "specialty_bulletaccuracy", false );
	    selected maps\mp\_utility::giveperk( "specialty_holdbreath", false );
	    selected maps\mp\_utility::giveperk( "specialty_localjammer", false );
	    selected maps\mp\_utility::giveperk( "specialty_delaymine", false );
	    selected maps\mp\_utility::giveperk( "specialty_heartbreaker", false );
	    selected maps\mp\_utility::giveperk( "specialty_quieter", false );
	    selected maps\mp\_utility::giveperk( "specialty_detectexplosive", false );
	    selected maps\mp\_utility::giveperk( "specialty_selectivehearing", false );
	    selected maps\mp\_utility::giveperk( "specialty_pistoldeath", false );
	    selected maps\mp\_utility::giveperk( "specialty_laststandoffhand", false );
	    selected maps\mp\_utility::giveperk( "specialty_combathigh", false );
	    selected maps\mp\_utility::giveperk( "specialty_shield", false );
	    selected maps\mp\_utility::giveperk( "specialty_feigndeath", false );
	    selected maps\mp\_utility::giveperk( "specialty_shellshock", false );
	    selected maps\mp\_utility::giveperk( "specialty_blackbox", false );
	    selected maps\mp\_utility::giveperk( "specialty_steelnerves", false );
	    selected maps\mp\_utility::giveperk( "specialty_saboteur", false );
	    selected maps\mp\_utility::giveperk( "specialty_endgame", false );
	    selected maps\mp\_utility::giveperk( "specialty_rearview", false );
	    selected maps\mp\_utility::giveperk( "specialty_primarydeath", false );
	    selected maps\mp\_utility::giveperk( "specialty_hardjack", false );
	    selected maps\mp\_utility::giveperk( "specialty_extraspecialduration", false );
	    selected maps\mp\_utility::giveperk( "specialty_stun_resistance", false );
	    selected maps\mp\_utility::giveperk( "specialty_double_load", false );
	    selected maps\mp\_utility::giveperk( "specialty_regenspeed", false );
	    selected maps\mp\_utility::giveperk( "specialty_autospot", false );
	    selected maps\mp\_utility::giveperk( "specialty_twoprimaries", false );
	    selected maps\mp\_utility::giveperk( "specialty_overkillpro", false );
	    selected maps\mp\_utility::giveperk( "specialty_anytwo", false );
	    selected maps\mp\_utility::giveperk( "specialty_fasterlockon", false );
	    selected maps\mp\_utility::giveperk( "specialty_paint", false );
	    selected maps\mp\_utility::giveperk( "specialty_paint_pro", false );
	    selected maps\mp\_utility::giveperk( "specialty_silentkill", false );
	    selected maps\mp\_utility::giveperk( "specialty_crouchmovement", false );
	    selected maps\mp\_utility::giveperk( "specialty_personaluav", false );
	    selected maps\mp\_utility::giveperk( "specialty_unwrapper", false );
	    selected maps\mp\_utility::giveperk( "specialty_class_blindeye", false );
	    selected maps\mp\_utility::giveperk( "specialty_class_lowprofile", false );
	    selected maps\mp\_utility::giveperk( "specialty_class_coldblooded", false );
	    selected maps\mp\_utility::giveperk( "specialty_class_hardwired", false );
	    selected maps\mp\_utility::giveperk( "specialty_class_scavenger", false );
	    selected maps\mp\_utility::giveperk( "specialty_class_hoarder", false );
	    selected maps\mp\_utility::giveperk( "specialty_class_gungho", false );
	    selected maps\mp\_utility::giveperk( "specialty_class_steadyhands", false );
	    selected maps\mp\_utility::giveperk( "specialty_class_hardline", false );
	    selected maps\mp\_utility::giveperk( "specialty_class_peripherals", false );
	    selected maps\mp\_utility::giveperk( "specialty_class_quickdraw", false );
	    selected maps\mp\_utility::giveperk( "specialty_class_lightweight", false );
	    selected maps\mp\_utility::giveperk( "specialty_class_toughness", false );
	    selected maps\mp\_utility::giveperk( "specialty_class_engineer", false );
	    selected maps\mp\_utility::giveperk( "specialty_class_dangerclose", false );
	    selected maps\mp\_utility::giveperk( "specialty_horde_weaponsfree", false );
	    selected maps\mp\_utility::giveperk( "specialty_horde_dualprimary", false );
	    selected maps\mp\_utility::giveperk( "specialty_marksman", false );
	    selected maps\mp\_utility::giveperk( "specialty_sharp_focus", false );
	    selected maps\mp\_utility::giveperk( "specialty_moredamage", false );
	    selected maps\mp\_utility::giveperk( "specialty_copycat", false );
	    selected maps\mp\_utility::giveperk( "specialty_finalstand", false );
	    selected maps\mp\_utility::giveperk( "specialty_juiced", false );
	    selected maps\mp\_utility::giveperk( "specialty_light_armor", false );
	    selected maps\mp\_utility::giveperk( "specialty_stopping_power", false );
	    selected maps\mp\_utility::giveperk( "specialty_uav", false );
        selected iPrintln( "^:All Perks Given" );
	    self iPrintln( "^:All Perks Given To: " + "^7" + selected.name );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

remove_player_perks( selected )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        selected maps\mp\_utility::_unsetperk( "specialty_longersprint" );
	    selected maps\mp\_utility::_unsetperk( "specialty_fastmantle" );
	    selected maps\mp\_utility::_unsetperk( "specialty_fastreload" );
	    selected maps\mp\_utility::_unsetperk( "specialty_quickdraw" );
	    selected maps\mp\_utility::_unsetperk( "specialty_scavenger" );
	    selected maps\mp\_utility::_unsetperk( "specialty_extraammo" );
	    selected maps\mp\_utility::_unsetperk( "specialty_bling" );
	    selected maps\mp\_utility::_unsetperk( "specialty_secondarybling" );
	    selected maps\mp\_utility::_unsetperk( "specialty_onemanarmy" );
	    selected maps\mp\_utility::_unsetperk( "specialty_omaquickchange" );
	    selected maps\mp\_utility::_unsetperk( "specialty_bulletdamage" );
	    selected maps\mp\_utility::_unsetperk( "specialty_armorpiercing" );
	    selected maps\mp\_utility::_unsetperk( "specialty_lightweight" );
	    selected maps\mp\_utility::_unsetperk( "specialty_fastsprintrecovery" );
	    selected maps\mp\_utility::_unsetperk( "specialty_hardline" );
	    selected maps\mp\_utility::_unsetperk( "specialty_rollover" );
	    selected maps\mp\_utility::_unsetperk( "specialty_radarimmune" );
	    selected maps\mp\_utility::_unsetperk( "specialty_spygame" );
	    selected maps\mp\_utility::_unsetperk( "specialty_explosivedamage" );
	    selected maps\mp\_utility::_unsetperk( "specialty_dangerclose" );
	    selected maps\mp\_utility::_unsetperk( "specialty_extendedmelee" );
	    selected maps\mp\_utility::_unsetperk( "specialty_falldamage" );
	    selected maps\mp\_utility::_unsetperk( "specialty_bulletaccuracy" );
	    selected maps\mp\_utility::_unsetperk( "specialty_holdbreath" );
	    selected maps\mp\_utility::_unsetperk( "specialty_localjammer" );
	    selected maps\mp\_utility::_unsetperk( "specialty_delaymine" );
	    selected maps\mp\_utility::_unsetperk( "specialty_heartbreaker" );
	    selected maps\mp\_utility::_unsetperk( "specialty_quieter" );
	    selected maps\mp\_utility::_unsetperk( "specialty_detectexplosive" );
	    selected maps\mp\_utility::_unsetperk( "specialty_selectivehearing" );
	    selected maps\mp\_utility::_unsetperk( "specialty_pistoldeath" );
	    selected maps\mp\_utility::_unsetperk( "specialty_laststandoffhand" );
	    selected maps\mp\_utility::_unsetperk( "specialty_combathigh" );
	    selected maps\mp\_utility::_unsetperk( "specialty_shield" );
	    selected maps\mp\_utility::_unsetperk( "specialty_feigndeath" );
	    selected maps\mp\_utility::_unsetperk( "specialty_shellshock" );
	    selected maps\mp\_utility::_unsetperk( "specialty_blackbox" );
	    selected maps\mp\_utility::_unsetperk( "specialty_steelnerves" );
	    selected maps\mp\_utility::_unsetperk( "specialty_saboteur" );
	    selected maps\mp\_utility::_unsetperk( "specialty_endgame" );
	    selected maps\mp\_utility::_unsetperk( "specialty_rearview" );
	    selected maps\mp\_utility::_unsetperk( "specialty_primarydeath" );
	    selected maps\mp\_utility::_unsetperk( "specialty_hardjack" );
	    selected maps\mp\_utility::_unsetperk( "specialty_extraspecialduration" );
	    selected maps\mp\_utility::_unsetperk( "specialty_stun_resistance" );
	    selected maps\mp\_utility::_unsetperk( "specialty_double_load" );
	    selected maps\mp\_utility::_unsetperk( "specialty_regenspeed" );
	    selected maps\mp\_utility::_unsetperk( "specialty_autospot" );
	    selected maps\mp\_utility::_unsetperk( "specialty_twoprimaries" );
	    selected maps\mp\_utility::_unsetperk( "specialty_overkillpro" );
	    selected maps\mp\_utility::_unsetperk( "specialty_anytwo" );
	    selected maps\mp\_utility::_unsetperk( "specialty_fasterlockon" );
	    selected maps\mp\_utility::_unsetperk( "specialty_paint" );
	    selected maps\mp\_utility::_unsetperk( "specialty_paint_pro" );
	    selected maps\mp\_utility::_unsetperk( "specialty_silentkill" );
	    selected maps\mp\_utility::_unsetperk( "specialty_crouchmovement" );
	    selected maps\mp\_utility::_unsetperk( "specialty_personaluav" );
	    selected maps\mp\_utility::_unsetperk( "specialty_unwrapper" );
	    selected maps\mp\_utility::_unsetperk( "specialty_class_blindeye" );
	    selected maps\mp\_utility::_unsetperk( "specialty_class_lowprofile" );
	    selected maps\mp\_utility::_unsetperk( "specialty_class_coldblooded" );
	    selected maps\mp\_utility::_unsetperk( "specialty_class_hardwired" );
	    selected maps\mp\_utility::_unsetperk( "specialty_class_scavenger" );
	    selected maps\mp\_utility::_unsetperk( "specialty_class_hoarder" );
	    selected maps\mp\_utility::_unsetperk( "specialty_class_gungho" );
	    selected maps\mp\_utility::_unsetperk( "specialty_class_steadyhands" );
	    selected maps\mp\_utility::_unsetperk( "specialty_class_hardline" );
	    selected maps\mp\_utility::_unsetperk( "specialty_class_peripherals" );
	    selected maps\mp\_utility::_unsetperk( "specialty_class_quickdraw" );
	    selected maps\mp\_utility::_unsetperk( "specialty_class_lightweight" );
	    selected maps\mp\_utility::_unsetperk( "specialty_class_toughness" );
	    selected maps\mp\_utility::_unsetperk( "specialty_class_engineer" );
	    selected maps\mp\_utility::_unsetperk( "specialty_class_dangerclose" );
	    selected maps\mp\_utility::_unsetperk( "specialty_horde_weaponsfree" );
	    selected maps\mp\_utility::_unsetperk( "specialty_horde_dualprimary" );
	    selected maps\mp\_utility::_unsetperk( "specialty_marksman" );
	    selected maps\mp\_utility::_unsetperk( "specialty_sharp_focus" );
	    selected maps\mp\_utility::_unsetperk( "specialty_moredamage" );
	    selected maps\mp\_utility::_unsetperk( "specialty_copycat" );
	    selected maps\mp\_utility::_unsetperk( "specialty_finalstand" );
	    selected maps\mp\_utility::_unsetperk( "specialty_juiced" );
	    selected maps\mp\_utility::_unsetperk( "specialty_light_armor" );
	    selected maps\mp\_utility::_unsetperk( "specialty_stopping_power" );
	    selected maps\mp\_utility::_unsetperk( "specialty_uav" );
	    self iPrintln( "^:All Perks Removed For: " + "^7" + selected.name );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

remove_player_weapons( selected )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        selected takeAllWeapons();

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

freeze_player( selected )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        selected freezeControls( true );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

unfreeze_player( selected )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        selected freezeControls( false );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

teleport_player_self( selected )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        selected setOrigin( self.origin );
        self iprintln( "^:Teleported: " + "^7" + selected.name );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

teleport_player_crosshair( selected )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        // Get the crosshair trace to determine where the player is looking
        forwardTrace = self getEye() + ( anglestoforward( self getPlayerAngles() ) * 1000000 );
        traceResult = bulletTrace( self getEye(), forwardTrace, false, self );

        // Get the hit position
        teleportPosition = traceResult[ "position" ];

        selected setOrigin( teleportPosition );
        self iprintln( "^:Teleported: " + "^7" + selected.name );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

space_player( selected )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        x = randomIntRange( -75, 75 );
        y = randomIntRange( -75, 75 );
        z = 45;
        space_location = ( 0 + x, 0 + y, 170000 + z );
        space_angle = ( 0, 176, 0 );
        selected setOrigin( space_location );
        selected setPlayerAngles( space_angle );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

warn_player( selected )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        selected iprintlnBold( "^1Stop That" );
        selected iprintln( "^1Stop That" );
        selected PlayLocalSound( "h2_nuke_timer" );
        self iprintln( selected.name + " was ^2Warned^7." );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

kill_player( selected )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        selected suicide();

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

kick_player( selected )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        kick ( selected );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

admin_access( selected )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        if( selected.access != "Host" )
        {

            selected.has_menu = true;
            selected.has_access = true;
            selected.access = "Admin";
            selected iprintln( "^:Current Access: " + selected.access );
            self iprintln( "^:Admin Given To: " + "^7" + selected.name );

        }
        else
        {

            self iprintln( "^1Can't Change Host Access!" );

        }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

menu_access( selected )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        if( selected.access != "Host" )
        {

            selected set_menu( "M203" );
            selected set_title( self get_menu() );
            selected.has_menu = true;
            selected.has_access = true;
            selected.access = "Access";
            selected iprintln( "^:Current Access: " + selected.access );
            self iprintln( "^:Access Given For: " + "^7" + selected.name );

        }
        else
        {

            self iprintln( "^1Can't Change Host Access!" );

        }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

remove_access( selected )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        if( selected.access != "Host" )
        {

            selected set_menu( "" );
            selected.has_menu = false;
            selected.has_access = false;
            selected.access = undefined;
            selected close_menu();
            selected iprintln( "^1Menu Access Revoked" );
            self iprintln( "^1Menu Access Revoked For: "+ "^7" + selected.name );

        }
        else
        {

            self iprintln( "^1Can't Change Host Access!" );

        }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

print_guid()
{

    self iprintln( "^:GUID: ^7" + self.guid );

}

print_player_guid( selected )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self iprintln( "^:GUID: ^7" + selected.guid );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

teleport_to_player( selected )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self SetOrigin( selected.origin );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

tempban_iw4madmin( selected )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        iPrintLn( selected.name + " Was ^1Temp Banned^7." );
        executeCommand( "say !tempban " + selected.name );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

ban_iw4madmin( selected )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        iPrintLn( selected.name + " Was ^1Banned^7." );
        executeCommand( "say !ban " + selected.name );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

warn_iw4madmin( selected )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        iPrintLn( selected.name + " Was ^3Warned^7." );
        executeCommand( "say !warn " + selected.name );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

print_iw4madmin( command )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        executeCommand( "say !" + command );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

warnclear_iw4madmin( selected )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self iPrintLn( "^:Warnings ^2Cleared ^:For: " + "^7" + selected.name );
        executeCommand( "say !warnclear " + selected.name );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

quit_iw4madmin( )
{

    if( self.access == "Host" )
    {

        self iPrintLn( "^:IW4M Admin Quitting!" );
        executeCommand( "say !quit" );

    }
    else
    {

        self iprintln( "^1Host Only!" );

    }

}

resetac_iw4madmin( )
{

    if( self.access == "Host" )
    {

        self iPrintLn( "^:IW4M Admin Anti Cheat Resetting!" );
        executeCommand( "say !resetanticheat" );

    }
    else
    {

        self iprintln( "^1Host Only!" );

    }

}

maprotate_iw4madmin( )
{

    if( self.access == "Host" )
    {

        self iPrintLn( "^:IW4M Admin Rotating Map!" );
        executeCommand( "say !maprotate" );

    }
    else
    {

        self iprintln( "^1Host Only!" );

    }

}

fastrestart_iw4madmin( )
{

    if( self.access == "Host" )
    {

        self iPrintLn( "^:IW4M Admin Fast Restarting!" );
        executeCommand( "say !fastrestart" );

    }
    else
    {

        self iprintln( "^1Host Only!" );

    }

}

restart_iw4madmin( )
{

    if( self.access == "Host" )
    {

        self iPrintLn( "^:IW4M Admin Restarting!" );
        executeCommand( "say !restart" );

    }
    else
    {

        self iprintln( "^1Host Only!" );

    }

}

//Kill Aura
kill_aura()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self.kill_aura = !return_toggle( self.kill_aura );

	    if( level.kill_aura == false )
	    {

            level.kill_aura = true;
            level.kill_aura2 = true;
            self iPrintln( "^:Kill Aura: ^7[^2On^7]" );
            while( isdefined( level.kill_aura2 ) ) {
                foreach( player in level.players )
                    if( isalive( player ) && player != self && distance( self.origin, player.origin ) <= 225 )
                        player suicide();

            wait .05;
            }
        
        }
	    else
	    {

            level.kill_aura2 = undefined;
            level.kill_aura = false;
            self iPrintln( "^:Kill Aura: ^7[^1Off^7]" );

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

//Change XP Multiplier
xp_multi( multi )
{
    
    if( self.access == "Host" || self.access == "Admin" )
    {

        setdvar("scr_xpscale", multi );
        self iprintln("^:XP Multiplier Set: " + multi + "x" );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

//Toggle Allow Changing Teams
allow_team_change()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self.allow_team_change = !return_toggle( self.allow_team_change );

	    if( level.allow_team_change == false )
	    {

            self setclientomnvar( "ui_disable_team_change", 0 );
            level.allow_team_change = true;
            self iPrintln( "^:Allow Team Change: ^7[^2On^7]" );

	    }
	    else
	    {

	    	self setclientomnvar( "ui_disable_team_change", 1 );
            level.allow_team_change = false;
            self iPrintln( "^:Allow Team Change: ^7[^1Off^7]" );

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

//Toggle Constant UAV
constant_uav_toggle()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self.constant_uav_toggle = !return_toggle( self.constant_uav_toggle );

	    if( level.constant_uav_toggle == false )
	    {

            setdynamicdvar( "scr_game_forceuav", 1 );
            setdynamicdvar( "bg_compassShowEnemies", 1 );
            level.constant_uav_toggle = true;
            self iPrintln( "^:Constant UAV: ^7[^2On^7]" );

	    }
	    else
	    {

	    	setdynamicdvar( "scr_game_forceuav", 0 );
            setdynamicdvar( "bg_compassShowEnemies", 0 );
            level.constant_uav_toggle = false;
            self iPrintln( "^:Constant UAV: ^7[^1Off^7]" );

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

//Toggle Bounces
bounce_toggle()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self.bounce_toggle = !return_toggle( self.bounce_toggle );

	    if( level.bounce_toggle == false )
	    {

            setdynamicdvar( "pm_bouncing", 1 );
            setdynamicdvar( "pm_bouncingAllAngles", 1 );
            level.bounce_toggle = true;
            self iPrintln( "^:Bounces: ^7[^2On^7]" );

	    }
	    else
	    {

            setdynamicdvar( "pm_bouncing", 0 );
            setdynamicdvar( "pm_bouncingAllAngles", 0 );
            level.bounce_toggle = false;
            self iPrintln( "^:Bounces: ^7[^1Off^7]" );

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

//Toggle Collision
collision_toggle()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self.collision_toggle = !return_toggle( self.collision_toggle );

	    if( level.collision_toggle == false )
	    {

            setdvar("g_playerCollision", 0);
            setdvar("g_playerEjection", 0);
            level.collision_toggle = true;
            self iPrintln( "^:No Player Collision: ^7[^2On^7]" );

	    }
	    else
	    {

            setdvar("g_playerCollision", 1);
            setdvar("g_playerEjection", 1);
            level.collision_toggle = false;
            self iPrintln( "^:No Player Collision: ^7[^1Off^7]" );

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

//Switch Teams
switch_teams()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self setclientomnvar( "ui_options_menu", 1 );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

//Set Score Limit
set_team_max( max_score )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        setdynamicdvar( "scr_" + level.gametype + "_scoreLimit", max_score );
        self iprintln("^:Score Limit Set: " + max_score );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

//Set Time Limit
set_time_limit( time_limit )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        setdynamicdvar("scr_" + level.gametype + "_timeLimit", time_limit);
        self iprintln("^:Time Limit Set: " + time_limit );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

//Teleport All to Crosshair
teleport_all_crosshair()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self iprintln( "^:Teleported All to Crosshair" );

        foreach( p in level.players )
        {

            if( isalive( p ) && p != self )
            {

                p SetOrigin( BulletTrace( self getTagOrigin("tag_eye"), vector_multiply(anglestoforward(self getPlayerAngles()), 1000000), 0, self )[ "position" ]);

            }

        }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

//Change Map
change_map( selected_map )
{

    if( self.access == "Host" )
    {

        map_lower = tolower( selected_map );
        say("^:Map Changing: " + "^2" + selected_map);
        wait 1;
        executeCommand("map mp_"+ map_lower);
        wait 300; // Temporary fix. We need to change the method for option in Structure to take an array.

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

change_map_cr( selected_map )
{

    if( self.access == "Host" )
    {

        map_lower = tolower( selected_map );
        say("^:Map Changing: " + "^2" + selected_map);
        wait 1;
        executeCommand("map "+ map_lower);
        wait 300; // Temporary fix. We need to change the method for option in Structure to take an array.

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

//Infinite Equipment
infinite_equipment()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self.infinite_equipment = !return_toggle( self.infinite_equipment );

	    if( level.infinite_equipment == false )
	    {

            level.infinite_equipment2 = true;
            level.infinite_equipment = true;
            self iPrintln( "^:Infinite Equipment: ^7[^2On^7]" );

            while( isdefined( level.infinite_equipment2 ) )
            {

                foreach( weapon in self getweaponslistall() )
                {

                    if( is_offhand( weapon ) && self getweaponammoclip( weapon ) != get_offhand_reserve( weapon ) )
                        self setweaponammoclip( weapon, get_offhand_reserve( weapon ) );

                    if( issubstr( weapon, "alt" ) && issubstr( weapon, "gl" ) && self getweaponammoclip( weapon ) != weaponmaxammo( weapon ) )
                        self setweaponammoclip( weapon, weaponmaxammo( weapon ) );

                    if( weapon == "h1_rpg_mp" && self getweaponammoclip( weapon ) != weaponmaxammo( weapon ) ) {
                        self setweaponammoclip( weapon, weaponclipsize( weapon ) );
                        self setweaponammostock( weapon, 4 );
                    }

                }

                self waittill_any( "grenade_fire", "missile_fire" );

            }

        }
	    else
	    {

            level.infinite_equipment2 = undefined;
            level.infinite_equipment = false;
            self iPrintln( "^:Infinite Equipment: ^7[^1Off^7]" );

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

/*
damage_multiplier_override_changed( multi )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self.damage_override_value = multi * 0.1;
        self iPrintLn( "^:Damage Multiplier Set" );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

player_damage_multiplier_override_changed( selected, multi )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        selected.damage_override_value = multi * 0.1;
        self iPrintLn( "^:Damage Multiplier Set" );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

*/

//Toggle Global Voice Chat
all_voice_toggle()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self.all_voice_toggle = !return_toggle( self.all_voice_toggle );

	    if( level.all_voice_toggle == false )
	    {

            setdvar( "sv_voice_all", 1 );
            setdvar( "cg_everyoneHearsEveryone", 1 );
            setdvar( "cg_deadHearTeamLiving", 1 );
            setdvar( "cg_deadHearAllLiving", 1 );
            level.all_voice_toggle = true;
            self iPrintln( "^:Global Voice Chat: ^7[^2On^7]" );

	    }
	    else
	    {

            setdvar( "sv_voice_all", 0 );
            setdvar( "cg_everyoneHearsEveryone", 0 );
            setdvar( "cg_deadHearTeamLiving", 0 );
            setdvar( "cg_deadHearAllLiving", 0 );
            level.all_voice_toggle = false;
            self iPrintln( "^:Global Voice Chat: ^7[^1Off^7]" );

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

//Toggle Position
view_pos_toggle()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self.view_pos_toggle = !return_toggle( self.view_pos_toggle );

	    if( level.view_pos_toggle == false )
	    {

            setdvar("cg_drawViewPos", 1);
            level.view_pos_toggle = true;
            self iPrintln( "^:Viewmodel Position: ^7[^2On^7]" );

	    }
	    else
	    {

            setdvar("cg_drawViewPos", 0);
            level.view_pos_toggle = false;
            self iPrintln( "^:Viewmodel Position: ^7[^1Off^7]" );

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

//Toggle FPS Display
fps_toggle()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self.fps_toggle = !return_toggle( self.fps_toggle );

	    if( level.fps_toggle == false )
	    {

            setdvar("cg_drawFPS", 1);
            level.fps_toggle = true;
            self iPrintln( "^:FPS: ^7[^2On^7]" );

	    }
	    else
	    {

            setdvar("cg_drawFPS", 0);
            level.fps_toggle = false;
            self iPrintln( "^:FPS: ^7[^1Off^7]" );

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

//Toggle Ping Display
ping_toggle()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self.ping_toggle = !return_toggle( self.ping_toggle );

	    if( level.ping_toggle == false )
	    {

            setdvar("cg_drawPing", 1);
            level.ping_toggle = true;
            self iPrintln( "^:Ping: ^7[^2On^7]" );

	    }
	    else
	    {

            setdvar("cg_drawPing", 0);
            level.ping_toggle = false;
            self iPrintln( "^:Ping: ^7[^1Off^7]" );

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

//Toggle Elevators
elevator_toggle()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self.elevator_toggle = !return_toggle( self.elevator_toggle );

	    if( level.elevator_toggle == false )
	    {

            setdvar("g_enableElevators", 1);
            level.elevator_toggle = true;
            self iPrintln( "^:Elevators: ^7[^2On^7]" );

	    }
	    else
	    {

            setdvar("g_enableElevators", 0);
            level.elevator_toggle = false;
            self iPrintln( "^:Elevators: ^7[^1Off^7]" );

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

//Toggle Old School Mode
oldschool_toggle()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self.oldschool_toggle = !return_toggle( self.oldschool_toggle );

	    if( level.oldschool_toggle == false )
	    {

            setdvar("g_oldschool", 1);
            level.oldschool_toggle = true;
            self iPrintln( "^:Old School Mode: ^7[^2On^7]" );

	    }
	    else
	    {

            setdvar("g_oldschool", 0);
            level.oldschool_toggle = false;
            self iPrintln( "^:Old School Mode: ^7[^1Off^7]" );

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

//Set Knockback
knockback_set( knockback_set )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        setDvar( "g_knockback", knockback_set );
	    self iPrintln( "^:Knockback set to: " + knockback_set );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

//Coin Toss
cointoss()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        coinside = randomIntRange( 0, 100 );

        iprintln( "Coin Tossed..." );

        wait 1.5;

        if( coinside >= 50 )
            iprintln( "^2Heads!" );
        else
            iprintln( "^1Tails!" );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}



//Ray Gun V2 (Zombiefan564, DidUknowiPwn)
giveRaygun()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self giveWeapon( level.RaygunWeapon );
	    self switchToWeapon( level.RaygunWeapon );
        self thread doRaygun2();

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

doRaygun2()
{
    for( ;; )
    {
        self waittill( "weapon_fired", weaponName );

        if( self getCurrentWeapon() != level.RaygunWeapon )
            continue;

        start = self getTagOrigin( "tag_eye" );
        end = self getTagOrigin( "tag_eye" ) + vecscale( anglestoforward( self getPlayerAngles() ), 100000 );
        trace = bulletTrace( start, end, true, self );
        thread doLaserFX( self getTagOrigin( "tag_eye" ), anglestoforward( self getPlayerAngles() ), trace["position"] );
    }
}

doLaserFX( startPos, direction, endPos )
{
    doDamage = 1;

    for( i = 1; ; i ++ )
    {
        pos = startPos + vecscale( direction, i * 150 );

        if( distance( startPos, pos ) > 9000 )
        {
            doDamage = 0;
            break;
        }

        trace = bulletTrace( startPos, pos, true, self );

        if( !bulletTracePassed( startPos, pos, true, self ) )
        {
            impactFX = spawnFX( level.RaygunFX["impact"], bulletTrace( startPos, pos, true, self )["position"] );
            level.FX_count ++;
            triggerFX( impactFX );

            wait( 0.2 );

            impactFX delete();
            level.FX_count --;

            break;
        }

        laserFX = spawnFX( level.RaygunFX["raygun"], pos );
        level.FX_count ++;
        triggerFX( laserFX );

        laserFX thread deleteAfterTime( 0.1 );

        if( level.FX_count < 200 )
        {
            for( j = 0; j < 3; j ++ )
            {
                laserFX = spawnFX( level.large_metalhit_1, pos + (randomInt( 50 ) / 10, randomInt( 50 ) / 10, randomInt( 50 ) / 10) - vecscale( direction, i * randomInt( 10 ) * 3 ) );
                level.FX_count ++;
                triggerFX( laserFX );

                laserFX thread deleteAfterTime( 0.05 + randomInt( 3 ) * 0.05 );
            }
        }

        wait( 0.05 );
    }

    if( doDamage )
        radiusDamage( endPos, 60, 150, 60, self );
}

deleteAfterTime( time )
{
    wait( time );

    self delete();
    level.FX_count --;
}

vecscale( vec, scalar )
{
    return ( vec[0] * scalar, vec[1] * scalar, vec[2] * scalar );
}

//Variable Zoom
variableZoomToggle()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self.variableZoomToggle = !return_toggle( self.variableZoomToggle );

	    if( self.variableZoom == false )
	    {

		    self.variableZoom = true;
		    thread variableZoom();
            self iPrintln( "^:Variable Zoom: ^7[^2On^7]" );

	    }
	    else
	    {

		    for( k = 0; k < 8; k++ )
		    	if( isDefined( self.zoomElem[ k ] ) )
		    		self.zoomElem[ k ] destroy();
            self.variableZoom = false;
            self iPrintln( "^:Variable Zoom: ^7[^1Off^7]" );

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

variableZoom()
{

	dvar = [];
	curs = 1;
	elemNames = strTok( "1x;2x;4x;8x;16x;32x;64x", ";" );
	for( k = 0; k < 8; k++ )
		dvar[ 8 - k ] = int( k * 10 );

	self endon( "lobby_choose" );
    self endon( "disconnect" );
	while( self.variableZoom )
	{

        while( self adsButtonPressed() && self useButtonPressed() && self playerAds() )
		{

			for( k = 0; k < 8; k++ )
			{
				if( !isDefined( self.zoomElem[ k ] ) )
				{
					self.zoomElem[ k ] = createText( "default", 1.4, "", "TOP", ( ( k * 40 ) - 120 ), 35, 1, 200, elemNames[ k ] );
					if( k == curs - 1 )
						self.zoomElem[ curs-1 ].color = ( 1, 0, 0 );
				}
            }

			if( self useButtonPressed() )
			{
                self playsound( "wpn_dryfire_lmg_plr" );
				self.zoomElem[ curs - 1 ].color = ( 1, 1, 1 );
				curs ++;
				if( curs >= dvar.size )
					curs = 1;
					
				self.zoomElem[ curs - 1 ].color = ( 1, 0, 0 );
				wait .2;
			}

			setDvar( "cg_fovmin", int( dvar[ curs ] ) );
			wait .05;

		}

		for( k = 0; k < 8; k++ )
			self.zoomElem[ k ] destroy();

		wait .05;

	}

}

//Fireworks
FireWorksToggle()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self.FireWorksToggle = !return_toggle( self.FireWorksToggle );

	    if( level.FireWorksToggle == false )
	    {

	    	self thread Fireworks();
            level.FireWorksToggle = true;
            self iPrintln( "^:Fireworks: ^7[^2On^7]" );

	    }
	    else
	    {

            self notify("stopfw");
            level.FireWorksToggle = false;
            self iPrintln( "^:Fireworks: ^7[^1Off^7]" );

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

Fireworks()
{

    self endon( "stopfw" );
    self endon( "disconnect" );

    for (;;)
    {

        Z = randomintrange( 4000, 8000 );
        X = randomintrange( 0, 5000 );
        Y = randomintrange( 0, 5000 );
        self thread qf( X, Y, Z );
        wait 0.25;
        self thread qz( X, Y, Z );
        wait 0.25;
        self thread qx( X, Y, Z );
        wait 0.15;
        self playSound( "detpack_explo_main" );

    }

}

qx( X, Y, Z )
{

    level.firework = loadfx( "vfx/explosion/mp_gametype_bomb" );
    Playfx( level.firework, self.origin + ( X, Y, Z ) );

}

qz( X, Y, Z )
{

    level.expbullt = loadfx( "explosions/clusterbomb_exp" );
    Playfx( level.expbullt, self.origin + ( X, Y, Z ) );

}

qf( X, Y, Z )
{

    level.flamez = loadfx( "explosions/javelin_explosion" );
    Playfx( level.flamez, self.origin + ( X, Y, Z ) );

}


//Rocket Grenade
RocketNade()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self iprintln( "^:Rocket Grenade Added!" );
        self setlethalweapon( "h1_fraggrenade_mp" );
        self SetWeaponAmmoClip( "h1_fraggrenade_mp", 1 );
        self waittill( "grenade_fire", grenade, weaponName );

        if( weaponName == "h1_fraggrenade_mp" )
        {

            grenade hide();

            self.RocketNade = spawn( "script_model", grenade.origin );
            self.RocketNade setModel( "projectile_hellfire_missile" );
            self.RocketNade linkTo( grenade );
            self.RocketNade playSound( "h2_nuke_timer" );
            grenade waittill( "death" );
            self.glow = spawnfx( loadfx( "vfx/explosion/mp_gametype_bomb" ), self.RocketNade.origin );
            TriggerFX( self.glow );
            radiusDamage( self.RocketNade.origin, 550, 550, 550, self );
            self.RocketNade delete();
            self switchToWeapon( self.oldWeapon );

        }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

//Drunk Mode
wastedModeToggle()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self.wastedModeToggle = !return_toggle( self.wastedModeToggle );

	    if( level.wastedModeToggle == false )
	    {

            self.drunk = true;
		    thread drunk();
            level.wastedModeToggle = true;
            self iPrintln( "^:Wasted Mode: ^7[^2On^7]" );

	    }
	    else
	    {

            thread endDrunk2();
            level.wastedModeToggle = false;
            self iPrintln( "^:Wasted Mode: ^7[^1Off^7]" );
            self notify( "endDrunk" );
            self notify( "sober" );

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

drunkDeath2()
{

	self waittill( "death" );
	thread endDrunk2();

}

endDrunk2()
{

	if( self.drunk )
	{

		self notify( "endDrunk" );
        self notify( "sober" );
		self.drunkHud destroy();
		self allowJump( true );
		self allowSprint( true );
		self setMoveSpeedScale( 1 );
		self setPlayerAngles( ( 0, self getPlayerAngles()[ 1 ], 0 ) );
        VisionSetNaked( getDvar( "mapname" ), 0.2 );
		self setClientDvar( "cg_fov", 90 );
		self.drunk = false;

	}

}

drunk()
{
	self endon( "endDrunk" );
	thread drunkAngles();
	thread drunkEffect2();
	thread drunkDeath2();
    thread drunkVision();
    thread Flipping();
	self.drunkHud = createRectangle( "", "", 0, 0, 1000, 720, getColor(), "white", 1, .2 );
	for(;;)
	{

		for( k = 0; k < 5; k += .2 )
		{

			self setClientDvar( "r_blur", k );
			self.drunkHud fadeOverTime( .1 );
			self.drunkHud.color = getColor();
			wait .1;

		}
		for( k = 5; k > 0; k -= .2 )
		{

			self setClientDvar( "r_blur", k );
			self.drunkHud fadeOverTime( .1 );
			self.drunkHud.color = getColor();
			wait .1;

		}

		wait .2;

	}

}

drunkEffect2()
{

	self endon( "endDrunk" );
	self allowJump( false );
	self allowSprint( false );
	self setMoveSpeedScale( .5 );

	for(;;)
	{

		for( k = 65; k < 80; k += .5 )
		{

			self setClientDvar( "cg_fov", k );
			wait .05;
		}

		for(k = 80;k > 65;k-=.5)
		{

			self setClientDvar( "cg_fov", k );
			wait .05;

		}

		wait .05;

	}

}

drunkAngles()
{

    self endon( "sober" );

	angleInUse = false;

	while( self.drunk )
	{

		angles = self getPlayerAngles();
		if( !angleInUse )
		{

			self setPlayerAngles( angles + ( .5, 0, 1 ) );
			if( angles[ 2 ] >= 25 )
                angleInUse = true;

		}

		if( angleInUse )
		{

			self setPlayerAngles( angles - ( .5, 0, 1 ) );
			if( angles[ 2 ] <= -25 )
                angleInUse = false;

		}

		wait .05;

	}

}

DrunkVision()
{

    self endon( "sober" );

    while( 1 )
    {

        visionSetNaked( "cheat_invert", 4.2 );
        wait .1;
        VisionSetNaked( "cheat_invert_contrast", 0.2 );
        wait .1;
        VisionSetNaked( "sepia", 0.2 );
        wait .1;
        VisionSetNaked( "cargoship_blast", 0.2 );
        wait .1;
        VisionSetNaked( "cheat_chaplinnight", 0.2 );
        wait .1;
        VisionSetNaked( "bog_a_sunrise", 0.2 );
        wait .1;
        VisionSetNaked( "cheat_bw", 0.2 );
        wait .1;
        VisionSetNaked( "ac130", 0.2 );
        wait .1;
        VisionSetNaked( "cheat_bw_contrast", 0.2 );
        wait .1;
        VisionSetNaked( "cheat_contrast", 0.2 );
        wait .1;
        VisionSetNaked( "ac130_inverted", 0.2 );
        wait .1;
        VisionSetNaked( "mpoutro", 0.2 );
        wait .1;
        VisionSetNaked( "grayscale", 0.2 );
        wait .1;
        VisionSetNaked( "cheat_bw_invert_contrast", 3 );

    }

}

Flipping()
{

    self endon( "sober" );
    for(;;)
    {

        self.angle = self GetPlayerAngles();
        if( self.angle[ 1 ] < 179 )
            self setPlayerAngles( self.angle + ( 0, 0, 2 ) );
        else
            self SetPlayerAngles( self.angle * ( 1, -1, 1 ) );
        wait 0.01;

    }

}

give_current_weapon( selected )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        weapon = self getCurrentWeapon();
        selected giveWeapon( weapon );
	    selected switchToWeapon( weapon );
	    self iprintln( "^:" + weapon + " ^2given to: " + "^7" + selected.name );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

ForcefieldToggle()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self.ForcefieldToggle = !return_toggle( self.ForcefieldToggle );

	    if( level.ForcefieldToggle == false )
	    {

		    self thread monplyr();
		    level.ForcefieldToggle = true;
            self iPrintln( "^:Force Field: ^7[^2On^7]" );

	    }
	    else
	    {

		    level.ForcefieldToggle = false;
		    self notify( "forceend" );
            self iPrintln( "^:Force Field: ^7[^1Off^7]" );

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

monplyr()
{

	self endon( "death" );
	self endon( "forceend" );
	while( 1 )
	{

		foreach( p in level.players )
		{

			if( distance( self.origin, p.origin ) <= 200 )
			{

				atf = anglestoforward( self getplayerangles() );
				if( p != self )
				{

					p setvelocity( p getvelocity() + ( atf[ 0 ] * ( 300 * 2 ), atf[ 1 ] * ( 300 * 2 ), ( atf[ 2 ] + 0.25 ) * ( 300 * 2 ) ) );

				}

			}

		}

		wait 0.05;

	}

}

freezeteam( team )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self iprintln( "^:Controls Frozen For Team: ^7" + team );

	    i = 0;
	    while( i < level.players.size )
	    {

		    if( i != 0 && level.players[ i ].pers[ "team" ] == team )
		    {

			    if( !(level.players[ i ].froz) && !( level.players[ i ] ishost() ) )
			    {

				    level.players[ i ] freezecontrols( 1 );
				    level.players[ i ].froz = 1;

			    }
			    else
			    {

				    level.players[ i ] freezecontrols( 0 );
                    level.players[ i ].froz = 0;

			    }

		    }

		    i++;

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

freezeall()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self iprintln( "^:All players frozen/unfrozen" );

	    i = 0;
	    while( i < level.players.size )
	    {

		    if( !(level.players[ i ].froz) && !( level.players[ i ] ishost() )  )
		    {

			    level.players[ i ] freezecontrols( 1 );
			    level.players[ i ].froz = 1;

		    }
		    else
		    {

			    level.players[ i ] freezecontrols( 0 );
                level.players[ i ].froz = 0;

		    }

		    i++;

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

killteam( team )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self iprintln( "^:Killed Team: ^7" + team );

	    foreach( player in level.players )
	    {

		    if( player.team == team )
		    {

			    if( !( player ishost() ) )
			    {

				    player suicide();

			    }

		    }

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

killall()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self iprintln( "^:All players killed" );
	    foreach( player in level.players )
	    {

		    if( !( player ishost() ) )
		    {

			    player suicide();

		    }

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

LadderJumpToggle()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self.LadderJumpToggle = !return_toggle( self.LadderJumpToggle );

	    if( level.LadderJumpToggle == false )
	    {

		    setdvar( "jump_ladderPushVel", 1024 );
		    level.LadderJumpToggle = true;
            self iPrintln( "^:Super Ladder Jump: ^7[^2On^7]" );

	    }
	    else
	    {
            
            setdvar( "jump_ladderPushVel", 128 );
		    level.LadderJumpToggle = false;
            self iPrintln( "^:Super Ladder Jump: ^7[^1Off^7]" );

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

sendalltospace()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self iprintln( "^:All Players Sent to Space" );
	    foreach( player in level.players )
	    {

		    if( !( player ishost() ) )
		    {

			    x = randomintrange( -75, 75 );
			    y = randomintrange( -75, 75 );
			    z = 45;
			    player.location = ( 0 + x, 0 + y, 500000 + z );
			    player.angle = ( 0, 176, 0 );
			    player setorigin( player.location );
			    player setplayerangles( player.angle );

		    }

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

takeallplayerweapons()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self iprintln( "^:All Players Weapons Removed" );
	    foreach( player in level.players )
	    {

		    if( !(player ishost()) )
		    {

			    player takeallweapons();

		    }

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

//Create Bounce
createBounce()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        if( level.B >= level.BounceLimit )
	    {

		    self thread DeleteAll();

	    }

	    level.BL[ level.B ] = self.origin;
	    level.B++;
	    self iPrintln( "^:Fake Bounce ^2Spawned!" );

	    foreach( player in level.players )
	        player notify( "BounceCreated" );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

// Delete Bounces
DeleteAll()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        for( i = 0; i < level.B; i++ )
		    level.BL[ i ] destroy();

	    level.B = 0;

	    foreach( player in level.players )
		    player iPrintln( "^:Fake Bounces ^1Deleted!" );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

monitorBounce()
{

	self endon( "disconnect" );
	self waittill( "BounceCreated" );
	for(;;)
	{

		for( i = 0; i < level.B; i++ )
		{

			if(distance( self.origin, level.BL[ i ] ) < 85 )
			{

				self setVelocity( self getVelocity() + ( 0, 0, 350 ) );

			}

			wait 0.02;

		}

		wait 0.01;

	}

}

inspect_glide()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self.inspect_glide = !return_toggle( self.inspect_glide );

	    if( level.inspect_glide == false )
	    {

            setdvar( "g_glideOnInspect", 1 );
            level.inspect_glide = true;
            self iPrintln( "^:Glide On Inspect: ^7[^2On^7]" );

	    }
	    else
	    {

            setdvar( "g_glideOnInspect", 0 );
            level.inspect_glide = false;
            self iPrintln( "^:Glide On Inspect: ^7[^1Off^7]" );

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

legacy_nacs()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self.legacy_nacs = !return_toggle( self.legacy_nacs );

	    if( level.legacy_nacs == false )
	    {

            setdvar( "g_legacyNacs", 1 );
            level.legacy_nacs = true;
            self iPrintln( "^:Legacy Nacs: ^7[^2On^7]" );

	    }
	    else
	    {

            setdvar( "g_legacyNacs", 0 );
            level.legacy_nacs = false;
            self iPrintln( "^:Legacy Nacs: ^7[^1Off^7]" );

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

disable_streaks()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self.disable_streaks = !return_toggle( self.disable_streaks );

	    if( level.disable_streaks == false )
	    {

            setdvar( "scr_game_hardpoints", 0 );
            level.disable_streaks = true;
            self iPrintln( "^:Killstreaks: ^7[^1Off^7]" );

	    }
	    else
	    {

            setdvar( "scr_game_hardpoints", 1 );
            level.disable_streaks = false;
            self iPrintln( "^:Killstreaks: ^7[^2On^7]" );

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

player_explosives()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self.player_explosives = !return_toggle( self.player_explosives );

	    if( level.player_explosives == false )
	    {

            setdvar( "scr_maxPerPlayerExplosives", 9999 );
            level.player_explosives = true;
            self iPrintln( "^:More Explosive Equipment: ^7[^2On^7] ^7(^1Requires Restart!^7)" );

	    }
	    else
	    {

            setdvar( "scr_maxPerPlayerExplosives", 2 );
            level.player_explosives = false;
            self iPrintln( "^:More Explosive Equipment: ^7[^1Off^7] ^7(^1Requires Restart!^7)" );

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

GiveXP( XP )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self giveRankXP1( XP );

        self iPrintln("^:XP Adjusted");

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

giveRankXP1( value )
{

    if( self GetPlayerData( "restXPGoal" ) > self maps\mp\gametypes\_rank::getRankXP() )
        self SetPlayerData( "restXPGoal", self GetPlayerData( "restXPGoal" ) + value );
    oldxp = self maps\mp\gametypes\_rank::getRankXP();
    self maps\mp\gametypes\_rank::incRankXP( value );
    if( maps\mp\gametypes\_rank::updateRank( oldxp ) )
        self thread maps\mp\gametypes\_rank::updateRankAnnounceHUD();

    self maps\mp\gametypes\_rank::syncXPStat();
    self maps\mp\gametypes\_rank::syncxpomnvars();
    
    self.pers[ "summary" ][ "challenge" ] += value;
    self.pers[ "summary" ][ "xp" ] += value;

    mylevel = self maps\mp\gametypes\_rank::getrank() + 1;
    myxp = self maps\mp\gametypes\_rank::getRankXP();

    self iPrintln("^:Current Level: " + mylevel );
    self iPrintln("^:Current XP: " + myxp );

}

RainModelToggle( model )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

	    if( level.RainModelToggle == false )
	    {

            self thread RainModel( model );
            level.RainModelToggle = true;
            self iPrintln( "^:Model Rain: ^7[^2On^7]" );

	    }
	    else
	    {

            self notify("Stop_RM");
            level.RainModelToggle = false;
            self iPrintln( "^:Model Rain: ^7[^1Off^7]" );

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

RainModel( model )
{
	self endon("Stop_RM");
	self endon("gameStart");
	lr=maps\mp\gametypes\_spawnlogic::findBoxCenter(level.spawnMins,level.spawnMaxs);
	lc=getAboveBuildingsLocationq(lr);
	for(;;)
	{
		Z=2000;
		X=randomintrange(-3000,3000);
		Y=randomintrange(-3000,3000);
		l= lr+(x,y,z);
		bomb=spawn("script_model",l);
		bomb setModel(model);
		bomb.angles=bomb.angles+(90,90,90);
		bomb moveto(bomb.origin-(0,0,2012),5,0);
		bomb thread deleteAfterTime(10);
		wait .2;
	}
}
getAboveBuildingsLocationq( location )
{

	trace = bullettrace(location + (0,0,10000), location, false, undefined);
	startorigin = trace["position"] + (0,0,-514);
	
	zpos = 0;
	
	maxxpos = 13; maxypos = 13;
	for (xpos = 0; xpos < maxxpos; xpos++) {
		for (ypos = 0; ypos < maxypos; ypos++) {
			thisstartorigin = startorigin + ((xpos/(maxxpos-1) - .5) * 1024, (ypos/(maxypos-1) - .5) * 1024, 0);
			thisorigin = bullettrace(thisstartorigin, thisstartorigin + (0,0,-10000), false, undefined);
			zpos += thisorigin["position"][2];
		}
	}
	zpos = zpos / (maxxpos*maxypos);
	
	zpos = zpos + 850;
	
	return (location[0], location[1], zpos);

}

UsePredMissile()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        maps\mp\h2_killstreaks\_remotemissile::tryUsePredatorMissile( self.pers[ "killstreaks" ][ 0 ].lifeId );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

doExpZomb()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self thread maps\mp\gametypes\_hud_message::hintMessage( "^:Press [{+actionslot 3}] For Exploding Crawler" );
        self notifyOnPlayerCommand( "AS1", "+actionslot 3" );
        self waittill( "AS1" );
        self thread doEx();

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}
 
doProne()
{

    self endon( "death" );
    self endon( "disconnect" );
    {

        while( 1 )
        {

            self SetStance( "prone" );
            self SetMoveSpeedScale( 10 );
            wait .5;

        }

    }

}

doEx()
{

    self setModel("body_infect");
	self setviewmodel("viewhands_infect");
	self takeAllWeapons();
    self giveweapon( "h2_infect_mp" );
    self switchtoweapon( "h2_infect_mp" );
	//self attach( "weapon_c4_mp", "j_shouldertwist_le", false );
	self thread doProne();
	self SetMoveSpeedScale( 10 );
	self maps\mp\_utility::giveperk( "specialty_class_coldblooded" );
	self maps\mp\_utility::giveperk( "specialty_thermal" );
	self setClientDvar( "friction", .5 );
	self setClientDvar( "g_gravity", 500 );
	self iPrintLnBold( "^:Press [[{+activate}]] to explode" );
	self notifyOnPlayerCommand( "AS3", "+activate" );

	self waittill( "AS3" );
	{

	    MagicBullet( "ac130_105mm_mp", self.origin + ( 0, 0, 1 ), self.origin, self );
        self suicide();

	}

	self notifyOnPlayerCommand( "AS3", "+activate" );

}

//Teleport Team to Crosshair
teleport_team_crosshair( team )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self iprintln( "^:Teleported to Crosshair: ^7" + team );

        foreach( p in level.players )
        {

            if( isalive( p ) && p != self && p.team == team )
            {

                p SetOrigin( BulletTrace( self getTagOrigin("tag_eye"), vector_multiply(anglestoforward(self getPlayerAngles()), 1000000), 0, self )[ "position" ]);

            }

        }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

taketeamweapons( team )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self iprintln( "^:Weapons Taken From: ^7" + team );
	    foreach( player in level.players )
	    {

		    if( !(player ishost()) && player.team == team )
		    {

			    player takeallweapons();

		    }

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

sendteamtospace( team )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self iprintln( "^:Sent Team to Space: ^7" + team );
	    foreach( player in level.players )
	    {

		    if( !( player ishost() ) && player.team == team )
		    {

			    x = randomintrange( -75, 75 );
			    y = randomintrange( -75, 75 );
			    z = 45;
			    player.location = ( 0 + x, 0 + y, 500000 + z );
			    player.angle = ( 0, 176, 0 );
			    player setorigin( player.location );
			    player setplayerangles( player.angle );

		    }

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

customMinimap( material )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self.customMinimap = !return_toggle( self.customMinimap );

	    if( level.customMinimap == false )
	    {

            maps\mp\_compass::setupminimap( material );
            level.customMinimap = true;
            self iPrintln( "^:Custom Minimap: ^7[^2On^7]" );

	    }
	    else
	    {

            normal = getdvar( "mapname" );
		    maps\mp\_compass::setupminimap( "compass_map_" + normal );
            level.customMinimap = false;
            self iPrintln( "^:Custom Minimap: ^7[^1Off^7]" );

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

TrackingKnife()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self.TrackingKnife = !return_toggle( self.TrackingKnife );

	    if( level.TrackingKnife == false )
	    {

            level.TrackingKnife = true;
            self iPrintln( "^:Tracking Knife: ^7[^2On^7]" );

            self setlethalweapon( "iw9_throwknife_mp" );
            self setweaponammoclip( "iw9_throwknife_mp", 99 );
            self GiveMaxAmmo( "iw9_throwknife_mp" );

            Viable_Targets = [];
	        enemy = self;
	        time_to_target = 0;
	        velocity = 500;

	        while( level.TrackingKnife )
	        {

		        self waittill( "grenade_fire", grenade, weapname );

		        if( !isDefined( level.TrackingKnife ) )
			        break;

		        if( weapname == "iw9_throwknife_mp" )
		        {

			        wait .25;

                    enemy = undefined;
                    minDistance = 9999999;

                    foreach ( player in level.players )
                    {

                        if ( player != self && ( !level.teambased || player.team != self.team ) )
                        {

                            distance = distance( grenade getOrigin(), player getOrigin() );

                            if ( distance < minDistance )
                            {

                                minDistance = distance;
                                enemy = player;

                            }

                        }

                    }

                    if ( enemy != undefined )
                    {

                        grenade thread TrackPlayer( enemy, self );

                    }
            
		        }

	        }

	    }
	    else
	    {

            level.TrackingKnife = undefined;
            self iPrintln( "^:Tracking Knife: ^7[^1Off^7]" );

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

TrackPlayer( enemy, host )
{

	attempts = 0;

	if( isDefined( enemy ) && enemy != host )
	{

		while( !self isTouching( enemy ) && isDefined( self ) && isDefined( enemy ) && isAlive( enemy ) && attempts < 35 )
		{

            self.origin += ( ( enemy getOrigin() + ( 0, 0, 50 ) ) - self getorigin() ) * ( attempts / 35 );
			wait .1;
			attempts++;

		}

        enemy dodamage( 9999, enemy getOrigin(), "MOD_GRENADE", "iw9_throwknife_mp" );
		wait .05;
		self delete();

	}

}

giveteamweapon( team )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self iprintln( "^:Current Weapon Given To: ^7" + team );
        weapon = self getCurrentWeapon();
	    foreach( player in level.players )
	    {

		    if( !(player ishost()) && player.team == team )
		    {

			    player giveWeapon( weapon );
	            player switchToWeapon( weapon );

		    }

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

giveallcurrweapon()
{

    if( self.access == "Host" || self.access == "Admin" )
    {
        
        self iprintln( "^:Current Weapon Given to All" );
        weapon = self getCurrentWeapon();
	    foreach( player in level.players )
	    {

		    if( !(player ishost()) )
		    {

                player giveWeapon( weapon );
	            player switchToWeapon( weapon );

		    }

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

teleport_team_custom( team )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self _beginLocationSelection( "", "map_artillery_selector", true, ( level.mapSize / 5.625 ) );
        self.selectingLocation = true;
        self waittill( "confirm_location", location, directionYaw );
        newLocation = PhysicsTrace( location + ( 0, 0, 1000 ), location - ( 0, 0, 1000 ) );
        self notify( "used" );
        self endLocationSelection();
        self.selectingLocation = undefined;
        self iprintln( "^:Teleported to Selected Location: ^7" + team );

	    foreach( player in level.players )
	    {

		    if( !( player ishost() ) && player.team == team )
		    {

			    player SetOrigin( newLocation );
                player SetPlayerAngles( directionYaw );

		    }

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

teleport_all_custom()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self _beginLocationSelection( "", "map_artillery_selector", true, ( level.mapSize / 5.625 ) );
        self.selectingLocation = true;
        self waittill( "confirm_location", location, directionYaw );
        newLocation = PhysicsTrace( location + ( 0, 0, 1000 ), location - ( 0, 0, 1000 ) );
        self notify( "used" );
        self endLocationSelection();
        self.selectingLocation = undefined;
        self iprintln( "^:All Players Teleported to Selected Location" );

	    foreach( player in level.players )
	    {

		    if( !( player ishost() ) )
		    {

			    player SetOrigin( newLocation );
                player SetPlayerAngles( directionYaw );

		    }

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

changeSpecular( int )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        setdvar("r_specularmap", int );
        self iprintln("^:Specular Map Set" );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

ModdedLobby()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self.ModdedLobby = !return_toggle( self.ModdedLobby );

        self endon("disconnect");

	    if( level.ModdedLobby == false )
	    {

            setDvar( "g_gravity", "175" );
            setDvar( "jump_height", "1000" );
            setDvar( "g_speed", "800" );
            setDvar( "perk_weapSpreadMultiplier", "0.0001" );
            level.ModdedLobby = true;
            self iPrintln( "^:Modded Lobby: ^7[^2On^7]" );

	    }
	    else
	    {

            setDvar( "g_gravity", "800" );
            setDvar( "jump_height", "41" );
            setDvar( "g_speed", "190" );
            setDvar( "perk_weapSpreadMultiplier", "0.65" );
            level.ModdedLobby = false;
            self iPrintln( "^:Modded Lobby: ^7[^1Off^7]" );

	    }

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

giveLoadout( primary, secondary, lethal, equipment )
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self takeallweapons();
        self giveweapon( primary );
        self setweaponammoclip( primary, 9999 );
        self GiveMaxAmmo( primary );
        self giveweapon( secondary );
        self setweaponammoclip( secondary, 9999 );
        self GiveMaxAmmo( secondary );
        self setlethalweapon( lethal );
        self setweaponammoclip( lethal, 99 );
        self GiveMaxAmmo( lethal );
        self settacticalweapon( equipment );
	    self setweaponammoclip( equipment, 99 );
        self GiveMaxAmmo( equipment );
        self switchToWeapon( primary );
        self iprintln("^:Loadout Given" );
        self giveSniperPerks();

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}

giveSniperPerks()
{

    if( self.access == "Host" || self.access == "Admin" )
    {

        self maps\mp\_utility::giveperk( "specialty_longersprint", false );
		self maps\mp\_utility::giveperk( "specialty_fastmantle", false );
		self maps\mp\_utility::giveperk( "specialty_fastreload", false );
		self maps\mp\_utility::giveperk( "specialty_quickdraw", false );
		self maps\mp\_utility::giveperk( "specialty_extraammo", false );
		self maps\mp\_utility::giveperk( "specialty_bulletdamage", false );
		self maps\mp\_utility::giveperk( "specialty_armorpiercing", false );
		self maps\mp\_utility::giveperk( "specialty_lightweight", false );
		self maps\mp\_utility::giveperk( "specialty_fastsprintrecovery", false );
		self maps\mp\_utility::giveperk( "specialty_spygame", false );
		self maps\mp\_utility::giveperk( "specialty_extendedmelee", false );
		self maps\mp\_utility::giveperk( "specialty_falldamage", false );
		self maps\mp\_utility::giveperk( "specialty_bulletaccuracy", false );
		self maps\mp\_utility::giveperk( "specialty_holdbreath", false );
		self maps\mp\_utility::giveperk( "specialty_quieter", false );
		self maps\mp\_utility::giveperk( "specialty_selectivehearing", false );
		self maps\mp\_utility::giveperk( "specialty_regenspeed", false );
		self maps\mp\_utility::giveperk( "specialty_crouchmovement", false );
		self maps\mp\_utility::giveperk( "specialty_class_lowprofile", false );
		self maps\mp\_utility::giveperk( "specialty_class_coldblooded", false );
		self maps\mp\_utility::giveperk( "specialty_class_steadyhands", false );
		self maps\mp\_utility::giveperk( "specialty_class_quickdraw", false );
		self maps\mp\_utility::giveperk( "specialty_class_lightweight", false );
		self maps\mp\_utility::giveperk( "specialty_marksman", false );
		self maps\mp\_utility::giveperk( "specialty_sharp_focus", false );
		self maps\mp\_utility::giveperk( "specialty_moredamage", false );
		self maps\mp\_utility::giveperk( "specialty_stopping_power", false );
        self iprintln("^:Sniper Perks Given" );

    }
    else
    {

        self iprintln( "^1Host/Admin Only!" );

    }

}